/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class InstallPlatformHyperlink
extends NotificationHyperlink {
    @NotNull
    private final AndroidVersion[] myAndroidVersions;

    public InstallPlatformHyperlink(AndroidVersion ... androidVersions) {
        super("install.android.platform", "Install missing platform(s) and sync project");
        this.myAndroidVersions = androidVersions;
    }

    @Override
    protected void execute(@NotNull Project project) {
        ArrayList requested = Lists.newArrayList();
        for (AndroidVersion version : this.myAndroidVersions) {
            requested.add(DetailsTypes.getPlatformPath((AndroidVersion)version));
        }
        ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, requested);
        if (dialog != null && dialog.showAndGet()) {
            GradleProjectImporter.getInstance().requestProjectSync(project, null);
        }
    }
}

