/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.externalSystem.service.notification.EditableNotificationMessageElement;
import com.intellij.openapi.project.Project;
import java.io.File;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class FixGradleVersionInWrapperHyperlink
extends NotificationHyperlink {
    @NotNull
    private final File myWrapperPropertiesFile;
    @NotNull
    private final String myGradleVersion;

    @Nullable
    public static NotificationHyperlink createIfProjectUsesGradleWrapper(@NotNull Project project, @Nullable String gradleVersion) {
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        if (wrapperPropertiesFile != null) {
            String version = gradleVersion != null ? gradleVersion : "2.14.1";
            return new FixGradleVersionInWrapperHyperlink(wrapperPropertiesFile, version);
        }
        return null;
    }

    private FixGradleVersionInWrapperHyperlink(@NotNull File wrapperPropertiesFile, @NotNull String gradleVersion) {
        super("fixGradleVersionInWrapper", "Fix Gradle wrapper and re-import project");
        this.myWrapperPropertiesFile = wrapperPropertiesFile;
        this.myGradleVersion = gradleVersion;
    }

    @Override
    protected void execute(@NotNull Project project) {
        GradleUtil.updateGradleDistributionUrl(project, this.myWrapperPropertiesFile, this.myGradleVersion);
        FixGradleVersionInWrapperHyperlink.setDistributionTypeAndSync(project);
    }

    @Override
    public boolean executeIfClicked(@NotNull Project project, @NotNull HyperlinkEvent event) {
        boolean updated = GradleUtil.updateGradleDistributionUrl(project, this.myWrapperPropertiesFile, this.myGradleVersion);
        if (updated) {
            EditableNotificationMessageElement.disableLink((HyperlinkEvent)event);
            FixGradleVersionInWrapperHyperlink.setDistributionTypeAndSync(project);
        }
        return updated;
    }

    private static void setDistributionTypeAndSync(@NotNull Project project) {
        GradleProjectSettings settings = GradleUtil.getGradleProjectSettings(project);
        if (settings != null) {
            settings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
        }
        GradleProjectImporter.getInstance().requestProjectSync(project, null);
    }
}

