/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class FixBuildToolsVersionHyperlink
extends NotificationHyperlink {
    @NotNull
    private final VirtualFile myBuildFile;
    @NotNull
    private final String myVersion;

    public FixBuildToolsVersionHyperlink(@NotNull VirtualFile buildFile, @NotNull String version) {
        super("fix.build.tools.version", "Update Build Tools version and sync project");
        this.myBuildFile = buildFile;
        this.myVersion = version;
    }

    @Override
    protected void execute(@NotNull Project project) {
        FixBuildToolsVersionHyperlink.setBuildToolsVersion(project, this.myBuildFile, this.myVersion, true);
    }

    static void setBuildToolsVersion(@NotNull Project project, @NotNull VirtualFile buildFile, @NotNull String version, boolean requestSync) {
        final GradleBuildModel buildModel = GradleBuildModel.parseBuildFile(buildFile, project);
        AndroidModel android = buildModel.android();
        if (!version.equals(android.buildToolsVersion())) {
            android.setBuildToolsVersion(version);
            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    buildModel.applyChanges();
                }
            });
            if (requestSync) {
                GradleProjectImporter.getInstance().requestProjectSync(project, null);
            }
        }
    }
}

