/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.ToggleOfflineModeHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class UnknownHostErrorHandler
extends AbstractSyncErrorHandler {
    private static final Pattern UNKNOWN_HOST_PATTERN = Pattern.compile("Unknown host '(.*)'(.*)");
    @VisibleForTesting
    static final String GRADLE_PROXY_ACCESS_DOCS_URL = "https://docs.gradle.org/current/userguide/userguide_single.html#sec:accessing_the_web_via_a_proxy";

    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        String firstLine = message.get(0);
        Matcher matcher = UNKNOWN_HOST_PATTERN.matcher(firstLine);
        if (matcher.matches()) {
            ArrayList hyperlinks = Lists.newArrayList();
            ToggleOfflineModeHyperlink enableOfflineMode = ToggleOfflineModeHyperlink.enableOfflineMode(project);
            if (enableOfflineMode != null) {
                hyperlinks.add(enableOfflineMode);
            }
            hyperlinks.add(new OpenUrlHyperlink(GRADLE_PROXY_ACCESS_DOCS_URL, "Learn about configuring HTTP proxies in Gradle"));
            UnknownHostErrorHandler.updateNotification(notification, project, error.getMessage(), hyperlinks);
            return true;
        }
        return false;
    }
}

