/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.InstallPlatformHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenAndroidSdkManagerHyperlink;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingPlatformErrorHandler
extends AbstractSyncErrorHandler {
    private static final Pattern MISSING_PLATFORM_PATTERN_0 = Pattern.compile("(Cause: )?(F|f)ailed to find target with hash string '(.*)' in: (.*)");
    private static final Pattern MISSING_PLATFORM_PATTERN_1 = Pattern.compile("(Cause: )?(F|f)ailed to find target (.*) : (.*)");
    private static final Pattern MISSING_PLATFORM_PATTERN_2 = Pattern.compile("(Cause: )?(F|f)ailed to find target (.*)");

    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        String missingPlatform = MissingPlatformErrorHandler.getMissingPlatform(message.get(0));
        if (missingPlatform != null) {
            List facets;
            AndroidVersion version;
            String loadError = null;
            ArrayList hyperlinks = Lists.newArrayList();
            AndroidSdkHandler sdkHandler = null;
            AndroidSdkData androidSdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
            if (androidSdkData != null) {
                sdkHandler = androidSdkData.getSdkHandler();
            }
            if (sdkHandler != null && (version = AndroidTargetHash.getPlatformVersion((String)missingPlatform)) != null) {
                StudioLoggerProgressIndicator logger = new StudioLoggerProgressIndicator(this.getClass());
                loadError = sdkHandler.getAndroidTargetManager((ProgressIndicator)logger).getErrorForPackage(DetailsTypes.getPlatformPath((AndroidVersion)version));
                hyperlinks.add(new InstallPlatformHyperlink(version));
            }
            if (hyperlinks.isEmpty() && !(facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID)).isEmpty()) {
                hyperlinks.add(new OpenAndroidSdkManagerHyperlink());
            }
            String newMsg = error.getMessage();
            if (StringUtil.isNotEmpty(loadError)) {
                newMsg = newMsg + "\nPossible cause: " + loadError;
            }
            MissingPlatformErrorHandler.updateNotification(notification, project, newMsg, hyperlinks);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    @Nullable
    static String getMissingPlatform(@NotNull String errorMessageFirstLine) {
        Matcher matcher = MISSING_PLATFORM_PATTERN_0.matcher(errorMessageFirstLine);
        boolean missingPlatform = matcher.matches();
        if (!missingPlatform) {
            matcher = MISSING_PLATFORM_PATTERN_1.matcher(errorMessageFirstLine);
            missingPlatform = matcher.matches();
        }
        if (!missingPlatform) {
            matcher = MISSING_PLATFORM_PATTERN_2.matcher(errorMessageFirstLine);
            missingPlatform = matcher.matches();
        }
        if (missingPlatform) {
            return matcher.group(3);
        }
        return null;
    }
}

