/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenUrlHyperlink;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaHeapSpaceErrorHandler
extends AbstractSyncErrorHandler {
    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        int lineCount = message.size();
        String newMsg = null;
        String firstLine = message.get(0);
        if (firstLine.endsWith("Java heap space")) {
            newMsg = firstLine + ".";
        } else if (lineCount > 1 && firstLine.startsWith("Unable to start the daemon process")) {
            String cause = null;
            for (int i = 1; i < lineCount; ++i) {
                String line = message.get(i);
                if (!"Error occurred during initialization of VM".equals(line) || i >= lineCount - 1) continue;
                cause = message.get(i + 1);
                break;
            }
            if (cause != null && cause.startsWith("Could not reserve enough space for object heap")) {
                if (firstLine.endsWith(".")) {
                    firstLine = firstLine.substring(0, firstLine.length() - 1);
                }
                if (!cause.endsWith(".")) {
                    cause = cause + ".";
                }
                newMsg = firstLine + ": " + StringUtil.decapitalize((String)cause);
            }
        }
        if (StringUtil.isNotEmpty(newMsg)) {
            ArrayList hyperlinks = Lists.newArrayList();
            newMsg = newMsg + "\nPlease assign more memory to Gradle in the project's gradle.properties file.\nFor example, the following line, in the gradle.properties file, sets the maximum Java heap size to 1,024 MB:\n<em>org.gradle.jvmargs=-Xmx1024m</em>";
            hyperlinks.add(new OpenUrlHyperlink("http://www.gradle.org/docs/current/userguide/build_environment.html", "Read Gradle's configuration guide"));
            hyperlinks.add(new OpenUrlHyperlink("http://docs.oracle.com/javase/7/docs/technotes/guides/vm/gc-ergonomics.html", "Read about Java's heap size"));
            JavaHeapSpaceErrorHandler.updateNotification(notification, project, newMsg, hyperlinks);
            return true;
        }
        return false;
    }
}

