/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenFileHyperlink;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GenericErrorHandler
extends AbstractSyncErrorHandler {
    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        Pair<String, Integer> errorLocation;
        String lastLine = message.get(message.size() - 1);
        if (lastLine != null && (errorLocation = GenericErrorHandler.getErrorLocation(lastLine)) != null) {
            String filePath = (String)errorLocation.getFirst();
            int line = (Integer)errorLocation.getSecond();
            GenericErrorHandler.updateNotification(notification, project, error.getMessage(), new OpenFileHyperlink(filePath, line - 1));
            return false;
        }
        String filePath = notification.getFilePath();
        if (StringUtil.isNotEmpty((String)filePath)) {
            int lineIndex = notification.getLine() - 1;
            int column = notification.getColumn();
            GenericErrorHandler.updateNotification(notification, project, error.getMessage(), new OpenFileHyperlink(filePath, "Open File", lineIndex, column));
        }
        return false;
    }
}

