/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.tools.idea.gradle.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.Semaphore;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GradleTaskRunner {
    public static final String USE_SPLIT_APK = "USE_SPLIT_APK";

    public boolean run(@NotNull List<String> var1, @Nullable BuildMode var2, @NotNull List<String> var3) throws InvocationTargetException, InterruptedException;

    public static GradleTaskRunner newRunner(final @NotNull Project project) {
        return new GradleTaskRunner(){

            @Override
            public boolean run(@NotNull List<String> tasks, @Nullable BuildMode buildMode, @NotNull List<String> commandLineArguments) throws InvocationTargetException, InterruptedException {
                assert (!ApplicationManager.getApplication().isDispatchThread());
                final GradleInvoker gradleInvoker = GradleInvoker.getInstance(project);
                final AtomicBoolean success = new AtomicBoolean();
                final Semaphore done = new Semaphore();
                done.down();
                GradleInvoker.AfterGradleInvocationTask afterTask = new GradleInvoker.AfterGradleInvocationTask(){

                    @Override
                    public void execute(@NotNull GradleInvocationResult result) {
                        success.set(result.isBuildSuccessful());
                        gradleInvoker.removeAfterGradleInvocationTask(this);
                        done.up();
                    }
                };
                ArrayList<String> args = new ArrayList<String>(commandLineArguments);
                if (!Boolean.valueOf(System.getenv(GradleTaskRunner.USE_SPLIT_APK)).booleanValue()) {
                    args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.coldswap.mode", (String)"MULTIDEX"));
                }
                SwingUtilities.invokeAndWait(() -> {
                    gradleInvoker.addAfterGradleInvocationTask(afterTask);
                    gradleInvoker.executeTasks(tasks, buildMode, args);
                });
                done.waitFor();
                return success.get();
            }
        };
    }
}

