/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.subset;

import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.GradleModel;
import com.android.tools.idea.gradle.JavaProject;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.subset.ModulesToImportDialog;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectSubset {
    @NonNls
    private static final String PROJECT_SUBSET_PROPERTY_NAME = "com.android.studio.selected.modules.on.import";
    private static final String MODULE_LOOKUP_MESSAGE_TITLE = "Module Lookup";
    @NotNull
    private final Project myProject;

    @NotNull
    public static ProjectSubset getInstance(@NotNull Project project) {
        return (ProjectSubset)ServiceManager.getService((Project)project, ProjectSubset.class);
    }

    public ProjectSubset(@NotNull Project project) {
        this.myProject = project;
    }

    public static boolean isSettingEnabled() {
        return GradleExperimentalSettings.getInstance().SELECT_MODULES_ON_PROJECT_IMPORT;
    }

    public boolean hasCachedModules() {
        DataNode<ProjectData> projectInfo = GradleUtil.getCachedProjectData(this.myProject);
        if (projectInfo != null) {
            return !ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE).isEmpty();
        }
        return false;
    }

    public void addOrRemoveModules() {
        Collection<DataNode<ModuleData>> selectedModules;
        DataNode<ProjectData> projectInfo = GradleUtil.getCachedProjectData(this.myProject);
        if (projectInfo == null) {
            return;
        }
        Collection moduleInfos = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        HashSet selectedModuleNames = Collections.emptySet();
        Object[] selection = this.getSelection();
        if (selection != null) {
            selectedModuleNames = Sets.newHashSet((Object[])selection);
        }
        if ((selectedModules = this.showModuleSelectionDialog(moduleInfos, selectedModuleNames)) != null) {
            this.setSelection(selectedModules);
            if (!Arrays.equals(this.getSelection(), selection)) {
                Projects.populate(this.myProject, projectInfo, selectedModules, true);
            }
        }
    }

    public void findAndIncludeModuleContainingSourceFile(@NotNull VirtualFile virtualFile) {
        final DataNode<ProjectData> projectInfo = GradleUtil.getCachedProjectData(this.myProject);
        if (projectInfo == null) {
            return;
        }
        final Collection moduleInfos = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        if (!moduleInfos.isEmpty()) {
            final File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            new Task.Modal(this.myProject, "Looking up Module", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    ArrayList results = Lists.newArrayList();
                    Object[] storedSelection = ProjectSubset.this.getSelection();
                    HashSet selection = storedSelection != null ? Sets.newHashSet((Object[])storedSelection) : Sets.newHashSet();
                    ArrayList selectedModules = Lists.newArrayList();
                    int doneCount = 0;
                    for (DataNode moduleNode : moduleInfos) {
                        ModuleSearchResult result;
                        indicator.setFraction((double)(++doneCount / moduleInfos.size()));
                        ModuleData module = (ModuleData)moduleNode.getData();
                        String name = module.getExternalName();
                        boolean selected = selection.contains(name);
                        if (selected) {
                            selectedModules.add(moduleNode);
                        }
                        if ((result = ProjectSubset.containsSourceFile((DataNode<ModuleData>)moduleNode, file, selected)) == null) continue;
                        results.add(result);
                    }
                    int resultCount = results.size();
                    if (resultCount == 0) {
                        UIUtil.invokeLaterIfNeeded(() -> {
                            String text = String.format("Unable to find a module containing the file '%1$s' in a source directory.", file.getName());
                            AndroidGradleNotification notification = AndroidGradleNotification.getInstance(ProjectSubset.this.myProject);
                            notification.showBalloon(ProjectSubset.MODULE_LOOKUP_MESSAGE_TITLE, text, NotificationType.ERROR);
                        });
                    } else if (resultCount == 1) {
                        ProjectSubset.this.addResultAndPopulateProject((ModuleSearchResult)results.get(0), (DataNode<ProjectData>)projectInfo, selectedModules, file);
                    } else {
                        ProjectSubset.this.showModuleSelectionDialog(results, (DataNode<ProjectData>)projectInfo, selectedModules, file);
                    }
                }
            }.queue();
        }
    }

    @Nullable
    private static ModuleSearchResult containsSourceFile(@NotNull DataNode<ModuleData> moduleInfos, @NotNull File file, boolean selected) {
        JavaProject javaProject;
        AndroidGradleModel androidModel;
        AndroidGradleModel.SourceFileContainerInfo result;
        DataNode androidProjectNode = ExternalSystemApiUtil.find(moduleInfos, AndroidProjectKeys.ANDROID_MODEL);
        if (androidProjectNode != null && (result = (androidModel = (AndroidGradleModel)androidProjectNode.getData()).containsSourceFile(file)) != null) {
            return new ModuleSearchResult(moduleInfos, result, selected);
        }
        DataNode javaProjectNode = ExternalSystemApiUtil.find(moduleInfos, AndroidProjectKeys.JAVA_PROJECT);
        if (javaProjectNode != null && (javaProject = (JavaProject)javaProjectNode.getData()).containsSourceFile(file)) {
            return new ModuleSearchResult(moduleInfos, null, selected);
        }
        return null;
    }

    private void addResultAndPopulateProject(@NotNull ModuleSearchResult result, @NotNull DataNode<ProjectData> projectInfo, @NotNull List<DataNode<ModuleData>> selectedModules, @NotNull File file) {
        String text;
        DataNode<ModuleData> moduleNode = result.moduleNode;
        String moduleName = ProjectSubset.getNameOf(moduleNode);
        if (result.selected) {
            String tmp = String.format("File '%1$s' is already in module '%2$s'", file.getName(), moduleName);
            AndroidGradleModel.SourceFileContainerInfo containerInfo = result.containerInfo;
            if (containerInfo != null) {
                containerInfo.updateSelectedVariantIn(moduleNode);
                Variant variant = containerInfo.variant;
                if (variant != null) {
                    tmp = tmp + String.format(", variant '%1$s'", variant.getName());
                }
            }
            text = tmp;
        } else {
            text = String.format("Module '%1$s' was added to the project.", moduleName);
            AndroidGradleModel.SourceFileContainerInfo containerInfo = result.containerInfo;
            if (containerInfo != null) {
                containerInfo.updateSelectedVariantIn(moduleNode);
            }
            selectedModules.add(moduleNode);
            this.setSelection(selectedModules);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            AndroidGradleNotification notification = AndroidGradleNotification.getInstance(this.myProject);
            notification.showBalloon(MODULE_LOOKUP_MESSAGE_TITLE, text, NotificationType.INFORMATION);
        });
        Projects.populate(this.myProject, projectInfo, selectedModules, true);
    }

    private void showModuleSelectionDialog(@NotNull List<ModuleSearchResult> searchResults, @NotNull DataNode<ProjectData> projectInfo, @NotNull List<DataNode<ModuleData>> selection, @NotNull File file) {
        ArrayList finalSelection = Lists.newArrayList(selection);
        ArrayList modulesToDisplayInDialog = Lists.newArrayList();
        HashMap resultsByModuleName = Maps.newHashMap();
        for (ModuleSearchResult result : searchResults) {
            DataNode<ModuleData> module = result.moduleNode;
            modulesToDisplayInDialog.add(module);
            if (result.selected) {
                finalSelection.remove(module);
            }
            String moduleName = ProjectSubset.getNameOf(module);
            resultsByModuleName.put(moduleName, result);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            Collection<DataNode<ModuleData>> selectedModules;
            ModulesToImportDialog dialog = new ModulesToImportDialog(modulesToDisplayInDialog, this.myProject);
            String description = String.format("The file '%1$s' may be include in one of the following modules.", file.getName());
            dialog.setDescription(description);
            dialog.clearSelection();
            if (dialog.showAndGet() && !(selectedModules = dialog.getSelectedModules()).isEmpty()) {
                for (DataNode<ModuleData> selectedModule : selectedModules) {
                    AndroidGradleModel.SourceFileContainerInfo containerInfo;
                    String name = ProjectSubset.getNameOf(selectedModule);
                    ModuleSearchResult result = (ModuleSearchResult)resultsByModuleName.get(name);
                    if (result == null || (containerInfo = result.containerInfo) == null) continue;
                    containerInfo.updateSelectedVariantIn(selectedModule);
                }
                finalSelection.addAll(selectedModules);
                this.setSelection(finalSelection);
                Projects.populate(this.myProject, projectInfo, finalSelection, true);
            }
        });
    }

    public void findAndIncludeModules(final @NotNull Collection<String> moduleGradlePaths) {
        final DataNode<ProjectData> projectInfo = GradleUtil.getCachedProjectData(this.myProject);
        if (projectInfo == null) {
            return;
        }
        final Collection moduleInfos = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        if (!moduleInfos.isEmpty()) {
            final Project project = this.myProject;
            new Task.Modal(project, "Finding Missing Modules", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    Object[] originalSelection = ProjectSubset.this.getSelection();
                    HashSet selection = originalSelection != null ? Sets.newHashSet((Object[])originalSelection) : Sets.newHashSet();
                    ArrayList selectedModules = Lists.newArrayList();
                    boolean found = false;
                    int doneCount = 0;
                    for (DataNode moduleInfo : moduleInfos) {
                        GradleModel gradleModel;
                        indicator.setFraction((double)(++doneCount / moduleInfos.size()));
                        String name = ProjectSubset.getNameOf((DataNode<ModuleData>)moduleInfo);
                        if (selection.contains(name)) {
                            selectedModules.add(moduleInfo);
                            continue;
                        }
                        DataNode gradleProjectNode = ExternalSystemApiUtil.find((DataNode)moduleInfo, AndroidProjectKeys.GRADLE_MODEL);
                        if (gradleProjectNode == null || !moduleGradlePaths.contains((gradleModel = (GradleModel)gradleProjectNode.getData()).getGradlePath())) continue;
                        selection.add(name);
                        selectedModules.add(moduleInfo);
                        found = true;
                    }
                    if (!selectedModules.isEmpty() && found) {
                        ProjectSubset.this.setSelection(selectedModules);
                        Projects.populate(project, (DataNode<ProjectData>)projectInfo, selectedModules, true);
                    }
                }
            }.queue();
        }
    }

    @Nullable
    public Collection<DataNode<ModuleData>> showModuleSelectionDialog(@NotNull Collection<DataNode<ModuleData>> modules) {
        Set<String> noSelection = Collections.emptySet();
        return this.showModuleSelectionDialog(modules, noSelection);
    }

    @Nullable
    private Collection<DataNode<ModuleData>> showModuleSelectionDialog(@NotNull Collection<DataNode<ModuleData>> modules, @NotNull Collection<String> selectedModuleNames) {
        ModulesToImportDialog dialog = new ModulesToImportDialog(modules, this.myProject);
        if (!selectedModuleNames.isEmpty()) {
            dialog.updateSelection(selectedModuleNames);
        }
        if (dialog.showAndGet()) {
            Collection<DataNode<ModuleData>> selectedModules = dialog.getSelectedModules();
            this.setSelection(selectedModules);
            return selectedModules;
        }
        return null;
    }

    private void setSelection(@NotNull Collection<DataNode<ModuleData>> modules) {
        ArrayList moduleNames = Lists.newArrayListWithExpectedSize((int)modules.size());
        for (DataNode<ModuleData> module : modules) {
            moduleNames.add(ProjectSubset.getNameOf(module));
        }
        this.updateSelection(moduleNames);
    }

    @NotNull
    private static String getNameOf(@NotNull DataNode<ModuleData> module) {
        return ((ModuleData)module.getData()).getExternalName();
    }

    public void clearSelection() {
        this.updateSelection(null);
    }

    private void updateSelection(@Nullable List<String> moduleNames) {
        String[] values = moduleNames != null ? ArrayUtil.toStringArray(moduleNames) : null;
        PropertiesComponent.getInstance((Project)this.myProject).setValues(PROJECT_SUBSET_PROPERTY_NAME, values);
    }

    @Nullable
    public String[] getSelection() {
        return PropertiesComponent.getInstance((Project)this.myProject).getValues(PROJECT_SUBSET_PROPERTY_NAME);
    }

    private static class ModuleSearchResult {
        @NotNull
        public final DataNode<ModuleData> moduleNode;
        @Nullable
        public final AndroidGradleModel.SourceFileContainerInfo containerInfo;
        public final boolean selected;

        ModuleSearchResult(@NotNull DataNode<ModuleData> moduleNode, @Nullable AndroidGradleModel.SourceFileContainerInfo containerInfo, boolean selected) {
            this.moduleNode = moduleNode;
            this.containerInfo = containerInfo;
            this.selected = selected;
        }
    }
}

