/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidGradleModelVersions {
    @NotNull
    private final GradleVersion myCurrent;
    @NotNull
    private final GradleVersion myLatest;
    private final boolean myExperimentalPlugin;

    @Nullable
    static AndroidGradleModelVersions find(@NotNull Project project) {
        AndroidProject androidProject;
        Module module = AndroidGradleModelVersions.getAppAndroidModule(project);
        if (module != null && (androidProject = GradleUtil.getAndroidProject(module)) != null) {
            if (GradleUtil.isUsingExperimentalPlugin(module)) {
                GradleVersion current = GradleUtil.getAndroidGradleExperimentalPluginVersionFromBuildFile(project);
                if (current != null) {
                    return new AndroidGradleModelVersions(current, true);
                }
            } else {
                GradleVersion current = GradleVersion.parse((String)androidProject.getModelVersion());
                return new AndroidGradleModelVersions(current, false);
            }
        }
        return null;
    }

    @Nullable
    private static Module getAppAndroidModule(@NotNull Project project) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidProject androidProject = GradleUtil.getAndroidProject(module);
            if (androidProject == null || androidProject.isLibrary()) continue;
            return module;
        }
        return null;
    }

    private AndroidGradleModelVersions(@NotNull GradleVersion current, boolean experimentalPlugin) {
        this(current, AndroidGradleModelVersions.getLatest(experimentalPlugin), experimentalPlugin);
    }

    @NotNull
    private static GradleVersion getLatest(boolean experimentalPlugin) {
        String latest = experimentalPlugin ? "0.8.2" : "2.2.2";
        return GradleVersion.parse((String)latest);
    }

    AndroidGradleModelVersions(@NotNull GradleVersion current, @NotNull GradleVersion latest, boolean experimentalPlugin) {
        this.myCurrent = current;
        this.myLatest = latest;
        this.myExperimentalPlugin = experimentalPlugin;
    }

    @NotNull
    GradleVersion getCurrent() {
        return this.myCurrent;
    }

    @NotNull
    GradleVersion getLatest() {
        return this.myLatest;
    }

    boolean isExperimentalPlugin() {
        return this.myExperimentalPlugin;
    }
}

