/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.notification;

import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ThreeState;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSyncStatusNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.gradle.sync.status");
    @NotNull
    private final Project myProject;

    public ProjectSyncStatusNotificationProvider(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        NotificationPanel oldPanel = (NotificationPanel)((Object)fileEditor.getUserData(this.getKey()));
        NotificationPanel.Type newPanelType = this.notificationPanelType();
        return oldPanel != null && oldPanel.type == newPanelType ? oldPanel : newPanelType.create(this.myProject);
    }

    @NotNull
    private NotificationPanel.Type notificationPanelType() {
        if (!Projects.isBuildWithGradle(this.myProject)) {
            return NotificationPanel.Type.NONE;
        }
        GradleSyncState syncState = GradleSyncState.getInstance(this.myProject);
        if (!syncState.areSyncNotificationsEnabled()) {
            return NotificationPanel.Type.NONE;
        }
        if (syncState.isSyncInProgress()) {
            return NotificationPanel.Type.IN_PROGRESS;
        }
        if (Projects.lastGradleSyncFailed(this.myProject)) {
            return NotificationPanel.Type.FAILED;
        }
        if (Projects.hasErrors(this.myProject)) {
            return NotificationPanel.Type.ERRORS;
        }
        ThreeState gradleSyncNeeded = syncState.isSyncNeeded();
        if (gradleSyncNeeded == ThreeState.YES) {
            return NotificationPanel.Type.SYNC_NEEDED;
        }
        return NotificationPanel.Type.NONE;
    }

    private static class SyncProblemNotificationPanel
    extends NotificationPanel {
        SyncProblemNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text) {
            super(type, text);
            this.createActionLabel("Try Again", () -> GradleProjectImporter.getInstance().requestProjectSync(project, null));
            this.createActionLabel("Open 'Messages' View", () -> ExternalSystemNotificationManager.getInstance((Project)project).openMessageView(GradleUtil.GRADLE_SYSTEM_ID, NotificationSource.PROJECT_SYNC));
            this.createActionLabel("Show Log in " + ShowFilePathAction.getFileManagerName(), () -> {
                File logFile = new File(PathManager.getLogPath(), "idea.log");
                ShowFilePathAction.openFile((File)logFile);
            });
        }
    }

    private static class StaleGradleModelNotificationPanel
    extends NotificationPanel {
        StaleGradleModelNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text) {
            super(type, text);
            this.createActionLabel("Sync Now", () -> GradleProjectImporter.getInstance().requestProjectSync(project, null));
        }
    }

    private static class NotificationPanel
    extends EditorNotificationPanel {
        @NotNull
        private final Type type;

        NotificationPanel(@NotNull Type type, @NotNull String text) {
            this.type = type;
            this.setText(text);
        }

        static enum Type {
            NONE{

                @Override
                @Nullable
                NotificationPanel create(@NotNull Project project) {
                    return null;
                }
            }
            ,
            IN_PROGRESS{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project) {
                    return new NotificationPanel(this, "Gradle project sync in progress...");
                }
            }
            ,
            FAILED{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project) {
                    return new SyncProblemNotificationPanel(project, this, "Gradle project sync failed. Basic functionality (e.g. editing, debugging) will not work properly.");
                }
            }
            ,
            ERRORS{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project) {
                    return new SyncProblemNotificationPanel(project, this, "Gradle project sync completed with some errors. Open the 'Messages' view to see the errors found.");
                }
            }
            ,
            SYNC_NEEDED{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project) {
                    boolean areExternalBuildFilesChanged = (Boolean)GradleSyncState.PROJECT_EXTERNAL_BUILD_FILES_CHANGED.get((UserDataHolder)project, (Object)false);
                    String buildFiles = areExternalBuildFilesChanged ? "External build files" : "Gradle files";
                    return new StaleGradleModelNotificationPanel(project, this, buildFiles + " have changed since last project sync. A project sync may be necessary for the IDE to work properly.");
                }
            };


            @Nullable
            abstract NotificationPanel create(@NotNull Project var1);
        }
    }
}

