/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.model.java;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaSourceDirectory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaContentRoot;

public class JavaModuleContentRoot
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final File myRootDirPath;
    @NotNull
    private final Collection<File> mySourceDirPaths;
    @NotNull
    private final Collection<File> myGenSourceDirPaths;
    @NotNull
    private final Collection<File> myResourceDirPaths;
    @NotNull
    private final Collection<File> myTestDirPaths;
    @NotNull
    private final Collection<File> myGenTestDirPaths;
    @NotNull
    private final Collection<File> myTestResourceDirPaths;
    @NotNull
    private final Collection<File> myExcludeDirPaths;

    @NotNull
    public static JavaModuleContentRoot copy(@NotNull IdeaContentRoot original) {
        File rootDirPath = original.getRootDirectory();
        Collection<File> sourceDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)original.getSourceDirectories());
        Collection<File> genSourceDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)original.getGeneratedSourceDirectories());
        Collection<File> testDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)original.getTestDirectories());
        Collection<File> genTestDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)original.getGeneratedTestDirectories());
        Set<File> resourceDirPaths = Collections.emptySet();
        Set<File> testResourceDirPaths = Collections.emptySet();
        if (original instanceof ExtIdeaContentRoot) {
            ExtIdeaContentRoot extContentRoot = (ExtIdeaContentRoot)original;
            resourceDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)extContentRoot.getResourceDirectories());
            testResourceDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)extContentRoot.getTestResourceDirectories());
        }
        HashSet excludeDirPaths = Collections.emptySet();
        Set exclude = original.getExcludeDirectories();
        if (exclude != null) {
            excludeDirPaths = Sets.newHashSet();
            for (File path : exclude) {
                if (path == null) continue;
                excludeDirPaths.add(path);
            }
        }
        return new JavaModuleContentRoot(rootDirPath, sourceDirPaths, genSourceDirPaths, resourceDirPaths, testDirPaths, genTestDirPaths, testResourceDirPaths, excludeDirPaths);
    }

    @NotNull
    private static Collection<File> copy(@Nullable DomainObjectSet<? extends IdeaSourceDirectory> directories) {
        if (directories == null) {
            return Collections.emptySet();
        }
        HashSet paths = Sets.newHashSet();
        for (IdeaSourceDirectory directory : directories) {
            paths.add(directory.getDirectory());
        }
        return paths;
    }

    public JavaModuleContentRoot(@NotNull File rootDirPath, @NotNull Collection<File> sourceDirPaths, @NotNull Collection<File> genSourceDirPaths, @NotNull Collection<File> resourceDirPaths, @NotNull Collection<File> testDirPaths, @NotNull Collection<File> genTestDirPaths, @NotNull Collection<File> testResourceDirPaths, @NotNull Collection<File> excludeDirPaths) {
        this.myRootDirPath = rootDirPath;
        this.mySourceDirPaths = sourceDirPaths;
        this.myGenSourceDirPaths = genSourceDirPaths;
        this.myResourceDirPaths = resourceDirPaths;
        this.myTestDirPaths = testDirPaths;
        this.myGenTestDirPaths = genTestDirPaths;
        this.myTestResourceDirPaths = testResourceDirPaths;
        this.myExcludeDirPaths = excludeDirPaths;
    }

    @NotNull
    public File getRootDirPath() {
        return this.myRootDirPath;
    }

    @NotNull
    public Collection<File> getSourceDirPaths() {
        return this.mySourceDirPaths;
    }

    @NotNull
    public Collection<File> getGenSourceDirPaths() {
        return this.myGenSourceDirPaths;
    }

    @NotNull
    public Collection<File> getResourceDirPaths() {
        return this.myResourceDirPaths;
    }

    @NotNull
    public Collection<File> getTestDirPaths() {
        return this.myTestDirPaths;
    }

    @NotNull
    public Collection<File> getGenTestDirPaths() {
        return this.myGenTestDirPaths;
    }

    @NotNull
    public Collection<File> getTestResourceDirPaths() {
        return this.myTestResourceDirPaths;
    }

    @NotNull
    public Collection<File> getExcludeDirPaths() {
        return this.myExcludeDirPaths;
    }
}

