/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.messages;

import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Message {
    @NotNull
    private final String myGroupName;
    @NotNull
    private final Type myType;
    @NotNull
    private final String[] myText;
    @NotNull
    private final Navigatable myNavigatable;
    @Nullable
    private final VirtualFile myFile;
    private final int myLine;
    private final int myColumn;

    public Message(@NotNull String groupName, @NotNull Type type, String ... text) {
        this(groupName, type, NonNavigatable.INSTANCE, text);
    }

    public Message(@NotNull Project project, @NotNull String groupName, @NotNull Type type, @NotNull VirtualFile file, int line, int column, String ... text) {
        this(groupName, type, (Navigatable)new OpenFileDescriptor(project, file, line, column), file, line, column, text);
    }

    public Message(@NotNull String groupName, @NotNull Type type, @NotNull Navigatable navigatable, String ... text) {
        this(groupName, type, navigatable, null, -1, -1, text);
    }

    private Message(@NotNull String groupName, @NotNull Type type, @NotNull Navigatable navigatable, @Nullable VirtualFile file, int line, int column, String ... text) {
        this.myType = type;
        this.myText = text;
        this.myGroupName = groupName;
        this.myNavigatable = navigatable;
        this.myFile = file;
        this.myLine = line;
        this.myColumn = column;
    }

    @NotNull
    public String getGroupName() {
        return this.myGroupName;
    }

    @NotNull
    public Type getType() {
        return this.myType;
    }

    @NotNull
    public String[] getText() {
        return this.myText;
    }

    @NotNull
    public Navigatable getNavigatable() {
        return this.myNavigatable;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.myFile;
    }

    public int getLine() {
        return this.myLine;
    }

    public int getColumn() {
        return this.myColumn;
    }

    public static enum Type {
        ERROR(4),
        INFO(3),
        SIMPLE(1),
        WARNING(5);

        private final int myValue;

        private Type(int value) {
            this.myValue = value;
        }

        public int getValue() {
            return this.myValue;
        }

        @Nullable
        public static Type find(@NotNull String value) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(value)) continue;
                return type;
            }
            return null;
        }
    }
}

