/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.invoker.messages;

import com.android.tools.idea.gradle.invoker.messages.GradleBuildTreeStructure;
import com.android.tools.idea.gradle.invoker.messages.GradleBuildTreeViewConfiguration;
import com.android.tools.idea.gradle.invoker.messages.MessageTreeRenderer;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.ErrorViewTreeBuilder;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.MultilineTreeCellRenderer;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import icons.AndroidIcons;
import java.awt.Component;
import java.awt.Container;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildTreeViewPanel
extends NewErrorTreeViewPanel {
    private final GradleBuildTreeStructure myTreeStructure;
    private final ErrorViewTreeBuilder myBuilder;
    private final GradleBuildTreeViewConfiguration myConfiguration;
    private volatile boolean myDisposed;

    public GradleBuildTreeViewPanel(@NotNull Project project) {
        super(project, null);
        this.myConfiguration = GradleBuildTreeViewConfiguration.getInstance(project);
        this.myTreeStructure = new GradleBuildTreeStructure(this.myProject, this.myConfiguration);
        DefaultTreeModel model = (DefaultTreeModel)this.myTree.getModel();
        this.myBuilder = new ErrorViewTreeBuilder((JTree)this.myTree, model, (AbstractTreeStructure)this.myTreeStructure);
        super.dispose();
        JScrollPane scrollPane = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)this.myTree);
        assert (scrollPane != null);
        this.myTree.getParent().remove((Component)this.myTree);
        Container parent = scrollPane.getParent();
        assert (parent instanceof JPanel);
        parent.remove(scrollPane);
        scrollPane = MultilineTreeCellRenderer.installRenderer((JTree)this.myTree, (MultilineTreeCellRenderer)new MessageTreeRenderer());
        parent.add((Component)scrollPane, "Center");
        new TreeSpeedSearch(this.myTree, (Convertor)new Convertor<TreePath, String>(){

            public String convert(TreePath treePath) {
                ErrorTreeElement e;
                Object[] text;
                Object data;
                Object last = treePath.getLastPathComponent();
                if (last instanceof DefaultMutableTreeNode && (data = ((DefaultMutableTreeNode)last).getUserObject()) instanceof ErrorTreeNodeDescriptor && (text = (e = ((ErrorTreeNodeDescriptor)data).getElement()).getText()) != null) {
                    return Joiner.on((char)' ').join(text);
                }
                return "";
            }
        });
    }

    @Nullable
    private GradleBuildTreeViewConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    protected void fillRightToolbarGroup(DefaultActionGroup group) {
        super.fillRightToolbarGroup(group);
        group.add((AnAction)new DumbAwareAction("Show Console Output", null, AndroidIcons.GradleConsole){

            public void actionPerformed(AnActionEvent e) {
                ToolWindow window = ToolWindowManager.getInstance((Project)GradleBuildTreeViewPanel.this.myProject).getToolWindow("Gradle Console");
                if (window != null) {
                    window.activate(null, false);
                }
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabledAndVisible(true);
            }
        });
        DefaultActionGroup filterGroup = new DefaultActionGroup("GradleBuildMessagesFilter", true){

            public void update(AnActionEvent e) {
                Presentation presentation = e.getPresentation();
                presentation.setDescription("Filter messages to display");
                presentation.setIcon(AllIcons.General.Filter);
            }

            public boolean isDumbAware() {
                return true;
            }
        };
        filterGroup.add((AnAction)new FilterMessagesByKindAction(ErrorTreeElementKind.ERROR));
        filterGroup.add((AnAction)new FilterMessagesByKindAction(ErrorTreeElementKind.WARNING));
        filterGroup.add((AnAction)new FilterMessagesByKindAction(ErrorTreeElementKind.INFO));
        filterGroup.add((AnAction)new FilterMessagesByKindAction(ErrorTreeElementKind.NOTE));
        filterGroup.add((AnAction)new FilterMessagesByKindAction(ErrorTreeElementKind.GENERIC));
        group.add((AnAction)filterGroup);
    }

    protected boolean canHideWarnings() {
        return false;
    }

    public void dispose() {
        this.myDisposed = true;
        this.myTreeStructure.clear();
        Disposer.dispose((Disposable)this.myBuilder);
    }

    public void updateTree() {
        if (!this.myDisposed) {
            this.myBuilder.updateTree();
        }
    }

    public void reload() {
        this.myBuilder.updateTree();
    }

    public void addMessage(int type, @NotNull String[] text, @Nullable VirtualFile underFileGroup, @Nullable VirtualFile file, int line, int column, @Nullable Object data) {
        if (this.myDisposed) {
            return;
        }
        ErrorTreeElementKind kind = ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)type);
        this.myTreeStructure.addMessage(kind, text, underFileGroup, file, line, column, data);
        this.myBuilder.updateTree();
    }

    public void addMessage(int type, @NotNull String[] text, @Nullable String groupName, @NotNull Navigatable navigatable, @Nullable String exportTextPrefix, @Nullable String rendererTextPrefix, @Nullable Object data) {
        VirtualFile file;
        if (this.myDisposed) {
            return;
        }
        VirtualFile virtualFile = file = data instanceof VirtualFile ? (VirtualFile)data : null;
        if (file == null && navigatable instanceof OpenFileDescriptor) {
            file = ((OpenFileDescriptor)navigatable).getFile();
        }
        ErrorTreeElementKind kind = ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)type);
        this.myTreeStructure.addNavigatableMessage(groupName, navigatable, kind, text, data, Strings.nullToEmpty((String)exportTextPrefix), Strings.nullToEmpty((String)rendererTextPrefix), file);
        this.myBuilder.updateTree();
    }

    public GradleBuildTreeStructure getErrorViewStructure() {
        return this.myTreeStructure;
    }

    public void selectFirstMessage() {
        ErrorTreeElement firstError = this.myTreeStructure.getFirstMessage(ErrorTreeElementKind.ERROR);
        if (firstError != null) {
            this.selectElement(firstError, new Runnable(){

                @Override
                public void run() {
                    if (GradleBuildTreeViewPanel.this.shouldShowFirstErrorInEditor()) {
                        GradleBuildTreeViewPanel.this.navigateToSource(false);
                    }
                }
            });
        } else {
            TreeUtil.selectFirstNode((JTree)this.myTree);
        }
    }

    protected boolean shouldShowFirstErrorInEditor() {
        return true;
    }

    private void selectElement(@NotNull ErrorTreeElement element, @Nullable Runnable onDone) {
        this.myBuilder.select((Object)element, onDone);
    }

    private void navigateToSource(boolean focusEditor) {
        NavigatableMessageElement element = this.getSelectedMessageElement();
        if (element == null) {
            return;
        }
        Navigatable navigatable = element.getNavigatable();
        if (navigatable.canNavigate()) {
            navigatable.navigate(focusEditor);
        }
    }

    @Nullable
    private NavigatableMessageElement getSelectedMessageElement() {
        ErrorTreeElement selectedElement = this.getSelectedErrorTreeElement();
        return selectedElement instanceof NavigatableMessageElement ? (NavigatableMessageElement)selectedElement : null;
    }

    private class FilterMessagesByKindAction
    extends ToggleAction {
        @NotNull
        private final ErrorTreeElementKind myElementKind;

        FilterMessagesByKindAction(ErrorTreeElementKind elementKind) {
            super(StringUtil.capitalize((String)elementKind.toString().toLowerCase(Locale.getDefault())));
            this.myElementKind = elementKind;
        }

        public boolean isSelected(AnActionEvent e) {
            GradleBuildTreeViewConfiguration configuration = GradleBuildTreeViewPanel.this.getConfiguration();
            if (configuration == null) {
                return false;
            }
            return configuration.canShow(this.myElementKind);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            GradleBuildTreeViewPanel.this.myConfiguration.update(this.myElementKind, state);
            GradleBuildTreeViewPanel.this.myBuilder.updateTree();
        }
    }
}

