/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.invoker;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.tools.idea.fd.FlightRecorder;
import com.android.tools.idea.fd.InstantRunBuildProgressListener;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.gradle.GradleModel;
import com.android.tools.idea.gradle.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.invoker.GradleOutputForwarder;
import com.android.tools.idea.gradle.invoker.GradleTaskExecutionContext;
import com.android.tools.idea.gradle.invoker.console.view.GradleConsoleView;
import com.android.tools.idea.gradle.invoker.messages.GradleBuildTreeViewPanel;
import com.android.tools.idea.gradle.output.parser.BuildOutputParser;
import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SelectSdkDialog;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AppIcon;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import net.jcip.annotations.GuardedBy;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressEventConverter;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

public class GradleTasksExecutor
extends Task.Backgroundable {
    private static final ExternalSystemTaskNotificationListener GRADLE_LISTENER = new ExternalSystemTaskNotificationListenerAdapter(){};
    private static final long ONE_MINUTE_MS = 60000L;
    private static final Logger LOG = Logger.getInstance(GradleInvoker.class);
    @NotNull
    public static final NotificationGroup LOGGING_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"Gradle Build (Logging)");
    @NotNull
    public static final NotificationGroup BALLOON_NOTIFICATION = NotificationGroup.balloonGroup((String)"Gradle Build (Balloon)");
    private static final Notification DUMMY_NOTIFICATION = new Notification("dummy", "dummy", "dummy", NotificationType.ERROR);
    private static final Object DUMMY_EVENT_SOURCE = new Object();
    @NonNls
    private static final String CONTENT_NAME = "Gradle Build";
    @NonNls
    private static final String APP_ICON_ID = "compiler";
    private static final Key<Key<?>> CONTENT_ID_KEY = Key.create((String)"CONTENT_ID");
    private static final int BUFFER_SIZE = 2048;
    private static final String GRADLE_RUNNING_MSG_TITLE = "Gradle Running";
    private static final String PASSWORD_KEY_SUFFIX = ".password=";
    public static final String ANDROID_ADDITIONAL_PLUGINS = "android.additional.plugins";
    public static final String COM_ANDROID_TOOLS_PROFILER = "com.android.tools.profiler";
    @NotNull
    private final Key<Key<?>> myContentId = Key.create((String)"compile_content");
    @NotNull
    private final Object myMessageViewLock = new Object();
    @NotNull
    private final Object myCompletionLock = new Object();
    @GuardedBy(value="myCompletionLock")
    private int myCompletionCounter;
    @NotNull
    private final GradleTaskExecutionContext myContext;
    @GuardedBy(value="myMessageViewLock")
    @Nullable
    private GradleBuildTreeViewPanel myErrorTreeView;
    @NotNull
    private final GradleExecutionHelper myHelper = new GradleExecutionHelper();
    private volatile int myErrorCount;
    private volatile int myWarningCount;
    @NotNull
    private volatile ProgressIndicator myIndicator = new EmptyProgressIndicator();
    private volatile boolean myMessageViewIsPrepared;
    private volatile boolean myMessagesAutoActivated;
    private CloseListener myCloseListener;

    GradleTasksExecutor(@NotNull GradleTaskExecutionContext context) {
        super(context.getProject(), "Gradle Build Running", true);
        this.myContext = context;
    }

    public String getProcessId() {
        return "GradleTaskInvocation";
    }

    @Nullable
    public Task.NotificationInfo getNotificationInfo() {
        return new Task.NotificationInfo(this.myErrorCount > 0 ? "Gradle Invocation (errors)" : "Gradle Invocation (success)", "Gradle Invocation Finished", this.myErrorCount + " Errors, " + this.myWarningCount + " Warnings", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        if (AndroidStudioInitializer.isAndroidStudio()) {
            GradleUtil.clearStoredGradleJvmArgs(this.getNotNullProject());
        }
        this.myIndicator = indicator;
        ProjectManager projectManager = ProjectManager.getInstance();
        Project project = this.getNotNullProject();
        this.myCloseListener = new CloseListener();
        projectManager.addProjectManagerListener(project, (ProjectManagerListener)this.myCloseListener);
        Semaphore semaphore = ((CompilerManagerImpl)CompilerManager.getInstance((Project)project)).getCompilationSemaphore();
        boolean acquired = false;
        try {
            try {
                while (!acquired) {
                    acquired = semaphore.tryAcquire(300L, TimeUnit.MILLISECONDS);
                    if (!indicator.isCanceled()) continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!this.isHeadless()) {
                this.addIndicatorDelegate();
            }
            this.invokeGradleTasks();
        }
        finally {
            try {
                indicator.stop();
                projectManager.removeProjectManagerListener(project, (ProjectManagerListener)this.myCloseListener);
            }
            finally {
                if (acquired) {
                    semaphore.release();
                }
            }
        }
    }

    private void addIndicatorDelegate() {
        if (this.myIndicator instanceof ProgressIndicatorEx) {
            ProgressIndicatorEx indicator = (ProgressIndicatorEx)this.myIndicator;
            indicator.addStateDelegate((ProgressIndicatorEx)new ProgressIndicatorStateDelegate());
        }
    }

    private void closeView() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = GradleTasksExecutor.this.myMessageViewLock;
                synchronized (object) {
                    if (GradleTasksExecutor.this.myErrorTreeView != null && !GradleTasksExecutor.this.getNotNullProject().isDisposed()) {
                        this.addStatisticsMessage(CompilerBundle.message((String)"statistics.error.count", (Object[])new Object[]{GradleTasksExecutor.this.myErrorCount}));
                        this.addStatisticsMessage(CompilerBundle.message((String)"statistics.warnings.count", (Object[])new Object[]{GradleTasksExecutor.this.myWarningCount}));
                        GradleTasksExecutor.this.addMessage(new Message(Message.Kind.INFO, "See complete output in console", SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), new OpenGradleConsole());
                        GradleTasksExecutor.this.myErrorTreeView.selectFirstMessage();
                    }
                }
            }

            private void addStatisticsMessage(@NotNull String text) {
                GradleTasksExecutor.this.addMessage(new Message(Message.Kind.STATISTICS, text, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), null);
            }
        }, ModalityState.NON_MODAL);
    }

    private void invokeGradleTasks() {
        File buildFilePath;
        Application application;
        Runnable task;
        Project project = this.getNotNullProject();
        GradleExecutionSettings executionSettings = this.getOrCreateGradleExecutionSettings(project);
        Function executeTasksFunction = connection -> {
            block22: {
                String testOutput;
                Stopwatch stopwatch = Stopwatch.createStarted();
                GradleConsoleView consoleView = GradleConsoleView.getInstance(project);
                consoleView.clear();
                this.addMessage(new Message(Message.Kind.INFO, "Gradle tasks " + this.myContext.getGradleTasks(), SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), null);
                String executingTasksText = "Executing tasks: " + this.myContext.getGradleTasks();
                consoleView.print(executingTasksText + SystemProperties.getLineSeparator() + SystemProperties.getLineSeparator(), ConsoleViewContentType.NORMAL_OUTPUT);
                this.addToEventLog(executingTasksText, MessageType.INFO);
                GradleOutputForwarder output = new GradleOutputForwarder(consoleView);
                BuildException buildError = null;
                InstantRunBuildProgressListener instantRunProgressListener = null;
                ExternalSystemTaskId id = this.myContext.getTaskId();
                CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
                try {
                    String logMessage;
                    AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(project);
                    ArrayList commandLineArgs = Lists.newArrayList((Object[])buildConfiguration.getCommandLineOptions());
                    if (buildConfiguration.USE_CONFIGURATION_ON_DEMAND && !commandLineArgs.contains("--configure-on-demand")) {
                        commandLineArgs.add("--configure-on-demand");
                    }
                    if (!commandLineArgs.contains("--parallel") && CompilerWorkspaceConfiguration.getInstance((Project)project).PARALLEL_COMPILATION) {
                        commandLineArgs.add("--parallel");
                    }
                    commandLineArgs.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.invoked.from.ide", (boolean)true));
                    commandLineArgs.addAll(this.myContext.getCommandLineArgs());
                    GradleUtil.addLocalMavenRepoInitScriptCommandLineOption(commandLineArgs);
                    GradleUtil.attemptToUseEmbeddedGradle(project);
                    if (System.getProperty("enable.experimental.profiling") != null) {
                        GradleUtil.addProfilerClassPathInitScriptCommandLineOption(commandLineArgs);
                        commandLineArgs.add(AndroidGradleSettings.createProjectProperty((String)ANDROID_ADDITIONAL_PLUGINS, (String)COM_ANDROID_TOOLS_PROFILER));
                    }
                    if ((logMessage = "Build command line options: " + commandLineArgs).contains(PASSWORD_KEY_SUFFIX)) {
                        ArrayList replaced = Lists.newArrayListWithExpectedSize((int)commandLineArgs.size());
                        for (String option : commandLineArgs) {
                            int index = option.indexOf(PASSWORD_KEY_SUFFIX);
                            if (index == -1) {
                                replaced.add(option);
                                continue;
                            }
                            replaced.add(option.substring(0, index + PASSWORD_KEY_SUFFIX.length()) + "*********");
                        }
                        logMessage = ((Object)replaced).toString();
                    }
                    LOG.info(logMessage);
                    ArrayList jvmArgs = Lists.newArrayList(this.myContext.getJvmArgs());
                    BuildLauncher launcher = connection.newBuild();
                    GradleExecutionHelper.prepare((LongRunningOperation)launcher, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)GRADLE_LISTENER, (List)jvmArgs, (List)commandLineArgs, (ProjectConnection)connection);
                    File javaHome = IdeSdks.getJdkPath();
                    if (javaHome != null) {
                        launcher.setJavaHome(javaHome);
                    }
                    this.myContext.storeCancellationInfoFor(id, cancellationTokenSource);
                    launcher.forTasks(ArrayUtil.toStringArray(this.myContext.getGradleTasks()));
                    launcher.withCancellationToken(cancellationTokenSource.token());
                    GradleOutputForwarder.Listener outputListener = null;
                    if (this.myContext.getTaskNotificationListener() != null) {
                        outputListener = (contentType, data, offset, length) -> {
                            if (this.myContext.isActive(id)) {
                                this.myContext.getTaskNotificationListener().onTaskOutput(id, new String(data, offset, length), contentType != ConsoleViewContentType.ERROR_OUTPUT);
                            }
                        };
                    }
                    output.attachTo(launcher, outputListener);
                    launcher.addProgressListener(event -> {
                        ExternalSystemTaskNotificationListener listener;
                        if (this.myContext.isActive(id) && (listener = this.myContext.getTaskNotificationListener()) != null) {
                            listener.onStatusChange(GradleProgressEventConverter.convert((ExternalSystemTaskId)id, (ProgressEvent)event));
                        }
                    });
                    if (InstantRunSettings.isInstantRunEnabled() && InstantRunSettings.isRecorderEnabled()) {
                        instantRunProgressListener = new InstantRunBuildProgressListener();
                        launcher.addProgressListener((ProgressListener)instantRunProgressListener);
                    }
                    launcher.run();
                    this.myContext.dropCancellationInfoFor(id);
                }
                catch (BuildException e) {
                    buildError = e;
                    break block22;
                }
                catch (Throwable e2) {
                    String testOutput2;
                    this.handleTaskExecutionError(e2);
                    this.myContext.dropCancellationInfoFor(id);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    String gradleOutput = output.toString();
                    if (instantRunProgressListener != null) {
                        FlightRecorder.get(this.myProject).saveBuildOutput(gradleOutput, instantRunProgressListener);
                    }
                    Application application = ApplicationManager.getApplication();
                    if (AndroidPlugin.isGuiTestingMode() && StringUtil.isNotEmpty((String)(testOutput2 = (String)application.getUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY)))) {
                        gradleOutput = testOutput2;
                        application.putUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY, null);
                    }
                    this.showGradleOutput(gradleOutput, output, stopwatch, buildError);
                    break block22;
                }
                finally {
                    String testOutput3;
                    this.myContext.dropCancellationInfoFor(id);
                    String gradleOutput = output.toString();
                    if (instantRunProgressListener != null) {
                        FlightRecorder.get(this.myProject).saveBuildOutput(gradleOutput, instantRunProgressListener);
                    }
                    Application application = ApplicationManager.getApplication();
                    if (AndroidPlugin.isGuiTestingMode() && StringUtil.isNotEmpty((String)(testOutput3 = (String)application.getUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY)))) {
                        gradleOutput = testOutput3;
                        application.putUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY, null);
                    }
                    this.showGradleOutput(gradleOutput, output, stopwatch, buildError);
                }
                String gradleOutput = output.toString();
                if (instantRunProgressListener != null) {
                    FlightRecorder.get(this.myProject).saveBuildOutput(gradleOutput, instantRunProgressListener);
                }
                Application application = ApplicationManager.getApplication();
                if (AndroidPlugin.isGuiTestingMode() && StringUtil.isNotEmpty((String)(testOutput = (String)application.getUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY)))) {
                    gradleOutput = testOutput;
                    application.putUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY, null);
                }
                this.showGradleOutput(gradleOutput, output, stopwatch, buildError);
            }
            return null;
        };
        if (AndroidPlugin.isGuiTestingMode() && (task = (Runnable)(application = ApplicationManager.getApplication()).getUserData(AndroidPlugin.EXECUTE_BEFORE_PROJECT_BUILD_IN_GUI_TEST_KEY)) != null) {
            application.putUserData(AndroidPlugin.EXECUTE_BEFORE_PROJECT_BUILD_IN_GUI_TEST_KEY, null);
            task.run();
        }
        File projectDirPath = (buildFilePath = this.myContext.getBuildFilePath()) != null ? buildFilePath : Projects.getBaseDirPath(project);
        this.myHelper.execute(projectDirPath.getPath(), executionSettings, executeTasksFunction);
    }

    private void showGradleOutput(@NotNull String gradleOutput, @NotNull GradleOutputForwarder output, @NotNull Stopwatch stopwatch, @Nullable BuildException buildError) {
        Application application = ApplicationManager.getApplication();
        ArrayList buildMessages = Lists.newArrayList();
        GradleTasksExecutor.collectMessages(gradleOutput, buildMessages).doWhenDone(() -> {
            boolean hasError = false;
            for (Message message : buildMessages) {
                if (message.getKind() != Message.Kind.ERROR) continue;
                hasError = true;
                break;
            }
            if (!hasError && this.myErrorCount == 0 && buildError != null && !GradleUtil.hasCause(buildError, BuildCancelledException.class)) {
                GradleTasksExecutor.addBuildExceptionAsMessage(buildError, output.getStdErr(), buildMessages);
            }
            output.close();
            stopwatch.stop();
            this.add(buildMessages);
            if (!this.myIndicator.isCanceled()) {
                this.closeView();
            }
            application.invokeLater(() -> this.notifyGradleInvocationCompleted(stopwatch.elapsed(TimeUnit.MILLISECONDS)));
            if (buildError == null || !GradleUtil.hasCause(buildError, BuildCancelledException.class)) {
                application.invokeLater(this::showMessages);
            }
            boolean buildSuccessful = buildError == null;
            GradleInvocationResult result = new GradleInvocationResult(this.myContext.getGradleTasks(), buildMessages, buildSuccessful);
            for (GradleInvoker.AfterGradleInvocationTask task : this.myContext.getGradleInvoker().getAfterInvocationTasks()) {
                task.execute(result);
            }
        });
    }

    @NotNull
    private static ActionCallback collectMessages(@NotNull String gradleOutput, @NotNull List<Message> messages) {
        ActionCallback callback = new ActionCallback();
        Runnable task = () -> {
            Iterable parsers = JpsServiceManager.getInstance().getExtensions(PatternAwareOutputParser.class);
            List compilerMessages = new BuildOutputParser(parsers).parseGradleOutput(gradleOutput, true);
            messages.addAll(compilerMessages);
            callback.setDone();
        };
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            task.run();
        } else {
            application.executeOnPooledThread(task);
        }
        return callback;
    }

    private void add(@NotNull List<Message> buildMessages) {
        this.prepareMessageView();
        Runnable addMessageTask = () -> {
            this.openMessageView();
            for (Message message : buildMessages) {
                this.incrementErrorOrWarningCount(message);
                if (!GradleTasksExecutor.shouldShow(message)) continue;
                this.add(message, null);
            }
        };
        UIUtil.invokeLaterIfNeeded((Runnable)addMessageTask);
    }

    @Nullable
    private GradleExecutionSettings getOrCreateGradleExecutionSettings(Project project) {
        GradleExecutionSettings executionSettings = GradleUtil.getGradleExecutionSettings(project);
        if (AndroidStudioInitializer.isAndroidStudio() && this.myContext.getUseEmbeddedGradle() && executionSettings == null) {
            File gradlePath = EmbeddedDistributionPaths.findEmbeddedGradleDistributionPath();
            assert (gradlePath != null && gradlePath.isDirectory());
            executionSettings = new GradleExecutionSettings(gradlePath.getPath(), null, DistributionType.LOCAL, null, false);
            File jdkPath = IdeSdks.getJdkPath();
            if (jdkPath != null) {
                executionSettings.setJavaHome(jdkPath.getPath());
            }
        }
        return executionSettings;
    }

    private void handleTaskExecutionError(@NotNull Throwable e) {
        if (this.myIndicator.isCanceled()) {
            LOG.info("Failed to complete Gradle execution. Project may be closing or already closed.", e);
            return;
        }
        Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
        String error = Strings.nullToEmpty((String)rootCause.getMessage());
        if (error.contains("Build cancelled")) {
            return;
        }
        Runnable showErrorTask = () -> {
            String msg = "Failed to complete Gradle execution.";
            msg = StringUtil.isEmpty((String)error) ? msg + " Cause: unknown." : msg + "\n\nCause:\n" + error;
            this.addMessage(new Message(Message.Kind.ERROR, msg, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), null);
            this.showMessages();
            if (AndroidStudioInitializer.isAndroidStudio() && error.startsWith("Supplied javaHome is not a valid folder")) {
                File androidHome = IdeSdks.getAndroidSdkPath();
                String androidSdkPath = androidHome != null ? androidHome.getPath() : null;
                SelectSdkDialog selectSdkDialog = new SelectSdkDialog(null, androidSdkPath);
                selectSdkDialog.setModal(true);
                if (selectSdkDialog.showAndGet()) {
                    String jdkHome = selectSdkDialog.getJdkHome();
                    UIUtil.invokeLaterIfNeeded(() -> ApplicationManager.getApplication().runWriteAction(() -> IdeSdks.setJdkPath(new File(jdkHome))));
                }
            }
        };
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.getNotNullProject(), (Runnable)showErrorTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addBuildExceptionAsMessage(@NotNull BuildException e, @NotNull String stdErr, @NotNull List<Message> buildMessages) {
        if (!stdErr.trim().isEmpty()) {
            Message msg = new Message(Message.Kind.ERROR, stdErr, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]);
            buildMessages.add(msg);
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
            try {
                e.printStackTrace(new PrintStream(out));
                String message = "Internal error:" + SystemProperties.getLineSeparator() + out.toString();
                Message msg = new Message(Message.Kind.ERROR, message, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]);
                buildMessages.add(msg);
            }
            finally {
                try {
                    Closeables.close((Closeable)out, (boolean)true);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void addMessage(@NotNull Message message, @Nullable Navigatable navigatable) {
        this.prepareMessageView();
        this.incrementErrorOrWarningCount(message);
        if (GradleTasksExecutor.shouldShow(message)) {
            Runnable addMessageTask = () -> {
                this.openMessageView();
                this.add(message, navigatable);
            };
            UIUtil.invokeLaterIfNeeded((Runnable)addMessageTask);
        }
    }

    private void incrementErrorOrWarningCount(@NotNull Message message) {
        Message.Kind kind = message.getKind();
        if (kind == Message.Kind.WARNING) {
            ++this.myWarningCount;
        } else if (kind == Message.Kind.ERROR) {
            ++this.myErrorCount;
        }
    }

    private static boolean shouldShow(@NotNull Message message) {
        Message.Kind kind = message.getKind();
        return kind != Message.Kind.SIMPLE && kind != Message.Kind.UNKNOWN;
    }

    private void prepareMessageView() {
        if (!this.myIndicator.isRunning() || this.myMessageViewIsPrepared) {
            return;
        }
        this.myMessageViewIsPrepared = true;
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.getNotNullProject().isDisposed()) {
                Object object = this.myMessageViewLock;
                synchronized (object) {
                    if (this.myErrorTreeView == null) {
                        GradleTasksExecutor.removeUnpinnedBuildMessages(this.getNotNullProject(), null);
                    }
                }
            }
        });
    }

    static void clearMessageView(@NotNull Project project) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!project.isDisposed()) {
                GradleTasksExecutor.removeUnpinnedBuildMessages(project, null);
            }
        });
    }

    private static void removeUnpinnedBuildMessages(@NotNull Project project, @Nullable Content toKeep) {
        if (project.isInitialized()) {
            Content[] contents;
            MessageView messageView = MessageView.SERVICE.getInstance((Project)project);
            for (Content content : contents = messageView.getContentManager().getContents()) {
                if (content.isPinned() || content == toKeep || content.getUserData(CONTENT_ID_KEY) == null) continue;
                messageView.getContentManager().removeContent(content, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openMessageView() {
        JComponent component;
        if (this.myIndicator.isCanceled()) {
            return;
        }
        Project project = this.getNotNullProject();
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null) {
                return;
            }
            this.myErrorTreeView = new GradleBuildTreeViewPanel(project);
            this.myErrorTreeView.setProcessController(new NewErrorTreeViewPanel.ProcessController(){

                public void stopProcess() {
                    GradleTasksExecutor.this.stopBuild();
                }

                public boolean isProcessStopped() {
                    return !GradleTasksExecutor.this.myIndicator.isRunning();
                }
            });
            component = this.myErrorTreeView.getComponent();
        }
        Content content = ContentFactory.SERVICE.getInstance().createContent(component, CONTENT_NAME, true);
        content.putUserData(CONTENT_ID_KEY, this.myContentId);
        MessageView messageView = this.getMessageView();
        ContentManager contentManager = messageView.getContentManager();
        contentManager.addContent(content);
        this.myCloseListener.setContent(contentManager, content);
        GradleTasksExecutor.removeUnpinnedBuildMessages(this.getNotNullProject(), content);
        contentManager.setSelectedContent(content);
    }

    private void activateGradleConsole() {
        ToolWindow window = this.getToolWindowManager().getToolWindow("Gradle Console");
        if (window != null) {
            window.activate(null, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(@NotNull Message message, @Nullable Navigatable navigatable) {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null && !this.getNotNullProject().isDisposed()) {
                boolean autoActivate;
                Message.Kind messageKind = message.getKind();
                int type = GradleTasksExecutor.translateMessageKind(messageKind);
                LinkAwareMessageData messageData = this.prepareMessage(message);
                if (navigatable == null) {
                    VirtualFile file = this.findFileFrom(message);
                    List sourceFilePositions = message.getSourceFilePositions();
                    assert (!sourceFilePositions.isEmpty());
                    SourcePosition position = ((SourceFilePosition)sourceFilePositions.get(0)).getPosition();
                    int line = position.getStartLine();
                    int column = position.getStartColumn();
                    this.myErrorTreeView.addMessage(type, messageData.textLines, file, line, column, messageData.hyperlinkListener);
                } else {
                    this.myErrorTreeView.addMessage(type, messageData.textLines, null, navigatable, null, null, messageData.hyperlinkListener);
                }
                boolean bl = autoActivate = !this.myMessagesAutoActivated && type == 4;
                if (autoActivate) {
                    this.myMessagesAutoActivated = true;
                    this.activateMessageView();
                }
            }
        }
    }

    @NotNull
    private LinkAwareMessageData prepareMessage(@NotNull Message message) {
        Consumer hyperlinkListener;
        ArrayList textLinesToUse;
        String text = message.getText();
        ArrayList rawTextLines = text.indexOf(10) == -1 ? Collections.singletonList(text) : Lists.newArrayList((Iterable)Splitter.on((char)'\n').split((CharSequence)text));
        if (message.getKind() != Message.Kind.ERROR) {
            return new LinkAwareMessageData(ArrayUtil.toStringArray((Collection)rawTextLines), null);
        }
        ArrayList enhancedTextLines = null;
        ArrayList linesBuffer = Lists.newArrayListWithExpectedSize((int)1);
        linesBuffer.add("");
        NotificationData dummyData = new NotificationData("", message.getText(), NotificationCategory.ERROR, NotificationSource.PROJECT_SYNC);
        String previousMessage = dummyData.getMessage();
        for (AbstractSyncErrorHandler handler : (AbstractSyncErrorHandler[])AbstractSyncErrorHandler.EP_NAME.getExtensions()) {
            for (int i = 0; i < rawTextLines.size(); ++i) {
                String currentMessage;
                String line = (String)rawTextLines.get(i);
                String prefixToStrip = "> ";
                line = StringUtil.trimStart((String)line, (String)prefixToStrip);
                linesBuffer.set(0, line);
                boolean handled = handler.handleError(linesBuffer, new ExternalSystemException(message.getText()), dummyData, this.getNotNullProject());
                if (!handled || (currentMessage = dummyData.getMessage()).length() <= previousMessage.length()) continue;
                int j = previousMessage.length();
                if (currentMessage.charAt(j) == '\n') {
                    ++j;
                }
                String addedText = currentMessage.substring(j);
                if (enhancedTextLines == null) {
                    enhancedTextLines = Lists.newArrayList((Iterable)rawTextLines);
                }
                enhancedTextLines.add(addedText);
                previousMessage = currentMessage;
            }
        }
        if (enhancedTextLines == null) {
            textLinesToUse = rawTextLines;
            hyperlinkListener = null;
        } else {
            textLinesToUse = enhancedTextLines;
            hyperlinkListener = url -> {
                HyperlinkEvent event = new HyperlinkEvent(DUMMY_EVENT_SOURCE, HyperlinkEvent.EventType.ACTIVATED, null, (String)url);
                dummyData.getListener().hyperlinkUpdate(DUMMY_NOTIFICATION, event);
            };
        }
        return new LinkAwareMessageData(ArrayUtil.toStringArray((Collection)textLinesToUse), (Consumer<String>)hyperlinkListener);
    }

    @Nullable
    private VirtualFile findFileFrom(@NotNull Message message) {
        SourceFile source = ((SourceFilePosition)message.getSourceFilePositions().get(0)).getFile();
        if (source.getSourceFile() != null) {
            return VfsUtil.findFileByIoFile((File)source.getSourceFile(), (boolean)true);
        }
        if (source.getDescription() != null) {
            String gradlePath = source.getDescription();
            Module module = GradleUtil.findModuleByGradlePath(this.getNotNullProject(), gradlePath);
            if (module != null) {
                AndroidGradleFacet facet = AndroidGradleFacet.getInstance(module);
                assert (facet != null);
                GradleModel gradleModel = facet.getGradleModel();
                return gradleModel != null ? gradleModel.getBuildFile() : null;
            }
        }
        return null;
    }

    private static int translateMessageKind(@NotNull Message.Kind kind) {
        switch (kind) {
            case INFO: {
                return 3;
            }
            case WARNING: {
                return 5;
            }
            case ERROR: {
                return 4;
            }
            case STATISTICS: {
                return 2;
            }
            case SIMPLE: {
                return 1;
            }
        }
        LOG.info("Unknown message kind: " + kind);
        return 0;
    }

    private void notifyGradleInvocationCompleted(long durationMillis) {
        Project project = this.getNotNullProject();
        if (!project.isDisposed()) {
            MessageType messageType;
            String statusMsg = this.createStatusMessage(durationMillis);
            MessageType messageType2 = this.myErrorCount > 0 ? MessageType.ERROR : (messageType = this.myWarningCount > 0 ? MessageType.WARNING : MessageType.INFO);
            if (durationMillis > 60000L) {
                BALLOON_NOTIFICATION.createNotification(statusMsg, messageType).notify(project);
            } else {
                this.addToEventLog(statusMsg, messageType);
            }
        }
    }

    @NotNull
    private String createStatusMessage(long durationMillis) {
        String message = "Gradle build finished";
        if (this.myErrorCount > 0) {
            message = this.myWarningCount > 0 ? message + String.format(" with %d error(s) and %d warning(s)", this.myErrorCount, this.myWarningCount) : message + String.format(" with %d error(s)", this.myErrorCount);
        } else if (this.myWarningCount > 0) {
            message = message + String.format(" with %d warnings(s)", this.myWarningCount);
        }
        message = message + " in " + StringUtil.formatDuration((long)durationMillis);
        return message;
    }

    private void addToEventLog(@NotNull String message, @NotNull MessageType type) {
        LOGGING_NOTIFICATION.createNotification(message, type).notify(this.myProject);
    }

    @NotNull
    private ToolWindowManager getToolWindowManager() {
        return ToolWindowManager.getInstance((Project)this.getNotNullProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMessages() {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null && !this.getNotNullProject().isDisposed()) {
                Content[] contents;
                MessageView messageView = this.getMessageView();
                for (Content content : contents = messageView.getContentManager().getContents()) {
                    if (content.getUserData(CONTENT_ID_KEY) == null) continue;
                    messageView.getContentManager().setSelectedContent(content);
                    return;
                }
            }
        }
    }

    @NotNull
    private MessageView getMessageView() {
        return MessageView.SERVICE.getInstance((Project)this.getNotNullProject());
    }

    @NotNull
    private Project getNotNullProject() {
        assert (this.myProject != null);
        return this.myProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateMessageView() {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            ToolWindow window;
            if (this.myErrorTreeView != null && (window = this.getToolWindowManager().getToolWindow(ToolWindowId.MESSAGES_WINDOW)) != null) {
                window.activate(null, false);
            }
        }
    }

    private void cancel() {
        if (!this.myIndicator.isCanceled()) {
            this.stopBuild();
            this.myIndicator.cancel();
        }
    }

    private void stopBuild() {
        ExternalSystemTaskId taskId = this.myContext.getTaskId();
        if (this.myIndicator.isRunning()) {
            this.myIndicator.setText("Stopping Gradle build...");
        }
        GradleInvoker.getInstance(this.getNotNullProject()).cancelTask(taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAndWaitForCompletion() {
        int counterBefore;
        Object object = this.myCompletionLock;
        synchronized (object) {
            counterBefore = this.myCompletionCounter;
        }
        UIUtil.invokeLaterIfNeeded(() -> ((GradleTasksExecutor)this).queue());
        object = this.myCompletionLock;
        synchronized (object) {
            while (this.myCompletionCounter <= counterBefore) {
                try {
                    this.myCompletionLock.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    public void onSuccess() {
        super.onSuccess();
        this.onCompletion();
    }

    public void onCancel() {
        super.onCancel();
        this.onCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCompletion() {
        Object object = this.myCompletionLock;
        synchronized (object) {
            ++this.myCompletionCounter;
            this.myCompletionLock.notifyAll();
        }
    }

    private static class LinkAwareMessageData {
        @NotNull
        final String[] textLines;
        @Nullable
        final Consumer<String> hyperlinkListener;

        LinkAwareMessageData(@NotNull String[] textLines, @Nullable Consumer<String> hyperlinkListener) {
            this.textLines = textLines;
            this.hyperlinkListener = hyperlinkListener;
        }
    }

    private class OpenGradleConsole
    implements Navigatable {
        private OpenGradleConsole() {
        }

        public void navigate(boolean requestFocus) {
            GradleTasksExecutor.this.activateGradleConsole();
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return false;
        }
    }

    private class ProgressIndicatorStateDelegate
    extends AbstractProgressIndicatorExBase {
        private ProgressIndicatorStateDelegate() {
        }

        public void cancel() {
            super.cancel();
            GradleTasksExecutor.this.closeView();
            this.stopAppIconProgress();
        }

        public void stop() {
            super.stop();
            this.stopAppIconProgress();
        }

        private void stopAppIconProgress() {
            UIUtil.invokeLaterIfNeeded(() -> {
                Project project;
                AppIcon appIcon = AppIcon.getInstance();
                if (appIcon.hideProgress(project = GradleTasksExecutor.this.getNotNullProject(), (Object)GradleTasksExecutor.APP_ICON_ID)) {
                    if (GradleTasksExecutor.this.myErrorCount > 0) {
                        appIcon.setErrorBadge(project, String.valueOf(GradleTasksExecutor.this.myErrorCount));
                        appIcon.requestAttention(project, true);
                    } else {
                        appIcon.setOkBadge(project, true);
                        appIcon.requestAttention(project, false);
                    }
                }
            });
        }

        protected void onProgressChange() {
            GradleTasksExecutor.this.prepareMessageView();
        }
    }

    private class CloseListener
    extends ContentManagerAdapter
    implements ProjectManagerListener {
        private ContentManager myContentManager;
        @Nullable
        private Content myContent;
        private boolean myIsApplicationExitingOrProjectClosing;
        private boolean myUserAcceptedCancel;

        private CloseListener() {
        }

        public void projectOpened(Project project) {
        }

        public boolean canCloseProject(Project project) {
            if (!project.equals(GradleTasksExecutor.this.myProject)) {
                return true;
            }
            if (this.shouldPromptUser()) {
                this.myUserAcceptedCancel = this.askUserToCancelGradleExecution();
                if (!this.myUserAcceptedCancel) {
                    return false;
                }
                GradleTasksExecutor.this.cancel();
                return true;
            }
            return !GradleTasksExecutor.this.myIndicator.isRunning();
        }

        public void projectClosed(Project project) {
            if (project.equals(GradleTasksExecutor.this.myProject) && this.myContent != null) {
                this.myContentManager.removeContent(this.myContent, true);
            }
        }

        public void projectClosing(Project project) {
            if (project.equals(GradleTasksExecutor.this.myProject)) {
                this.myIsApplicationExitingOrProjectClosing = true;
            }
        }

        void setContent(@NotNull ContentManager contentManager, @Nullable Content content) {
            this.myContent = content;
            this.myContentManager = contentManager;
            contentManager.addContentManagerListener((ContentManagerListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contentRemoved(ContentManagerEvent event) {
            if (event.getContent() == this.myContent) {
                Object object = GradleTasksExecutor.this.myMessageViewLock;
                synchronized (object) {
                    Project project = GradleTasksExecutor.this.getNotNullProject();
                    if (GradleTasksExecutor.this.myErrorTreeView != null && !project.isDisposed()) {
                        AppIcon appIcon;
                        Disposer.dispose((Disposable)GradleTasksExecutor.this.myErrorTreeView);
                        GradleTasksExecutor.this.myErrorTreeView = null;
                        if (GradleTasksExecutor.this.myIndicator.isRunning()) {
                            GradleTasksExecutor.this.cancel();
                        }
                        if ((appIcon = AppIcon.getInstance()).hideProgress(project, (Object)GradleTasksExecutor.APP_ICON_ID)) {
                            appIcon.setErrorBadge(project, null);
                        }
                    }
                }
                this.myContentManager.removeContentManagerListener((ContentManagerListener)this);
                if (this.myContent != null) {
                    this.myContent.release();
                }
                this.myContent = null;
            }
        }

        public void contentRemoveQuery(ContentManagerEvent event) {
            if (event.getContent() == this.myContent && !GradleTasksExecutor.this.myIndicator.isCanceled() && this.shouldPromptUser()) {
                this.myUserAcceptedCancel = this.askUserToCancelGradleExecution();
                if (!this.myUserAcceptedCancel) {
                    event.consume();
                }
            }
        }

        private boolean shouldPromptUser() {
            return !this.myUserAcceptedCancel && !this.myIsApplicationExitingOrProjectClosing && GradleTasksExecutor.this.myIndicator.isRunning();
        }

        private boolean askUserToCancelGradleExecution() {
            String msg = "Gradle is running. Proceed with Project closing?";
            int result = Messages.showYesNoDialog((Project)GradleTasksExecutor.this.myProject, (String)msg, (String)GradleTasksExecutor.GRADLE_RUNNING_MSG_TITLE, (Icon)Messages.getQuestionIcon());
            return result == 0;
        }
    }
}

