/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.invoker;

import com.android.tools.idea.gradle.invoker.console.view.GradleConsoleView;
import com.android.utils.SdkUtils;
import com.google.common.io.Closeables;
import com.intellij.execution.ui.ConsoleViewContentType;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.gradle.tooling.BuildLauncher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GradleOutputForwarder {
    private static final int SIZE = 2048;
    @NotNull
    private final ByteArrayOutputStream myStdErr;
    @NotNull
    private final ByteArrayOutputStream myOutput;
    @NotNull
    private final GradleConsoleView myConsoleView;
    private ConsoleViewContentType myPreviousContentType;

    GradleOutputForwarder(@NotNull GradleConsoleView consoleView) {
        this.myConsoleView = consoleView;
        this.myStdErr = new ByteArrayOutputStream(2048);
        this.myOutput = new ByteArrayOutputStream(4096);
    }

    void attachTo(@NotNull BuildLauncher launcher, @Nullable Listener listener) {
        ConsoleAwareOutputStream stdout = new ConsoleAwareOutputStream(this, ConsoleViewContentType.NORMAL_OUTPUT, listener);
        ConsoleAwareOutputStream stderr = new ConsoleAwareOutputStream(this, ConsoleViewContentType.ERROR_OUTPUT, listener);
        launcher.setStandardOutput((OutputStream)stdout);
        launcher.setStandardError((OutputStream)stderr);
    }

    void close() {
        try {
            Closeables.close((Closeable)this.myOutput, (boolean)true);
            Closeables.close((Closeable)this.myStdErr, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    String getStdErr() {
        return this.myStdErr.toString();
    }

    void write(@NotNull ConsoleViewContentType contentType, @NotNull byte[] b, int off, int len) {
        String text;
        boolean addNewLine = false;
        if (contentType != this.myPreviousContentType) {
            addNewLine = this.myPreviousContentType != null;
            this.myPreviousContentType = contentType;
        }
        String lineSeparator = SdkUtils.getLineSeparator();
        boolean newLineAdded = false;
        if (addNewLine) {
            byte[] bytes = lineSeparator.getBytes();
            this.myOutput.write(bytes, 0, bytes.length);
            this.myConsoleView.print(lineSeparator, contentType);
            newLineAdded = true;
        }
        if (lineSeparator.equals(text = new String(b, off, len)) && newLineAdded) {
            return;
        }
        this.myOutput.write(b, off, len);
        if (contentType == ConsoleViewContentType.ERROR_OUTPUT) {
            this.myStdErr.write(b, off, len);
        }
        this.myConsoleView.print(text, contentType);
    }

    public String toString() {
        return this.myOutput.toString();
    }

    private static class ConsoleAwareOutputStream
    extends OutputStream {
        @NotNull
        private final GradleOutputForwarder myOutput;
        @NotNull
        private final ConsoleViewContentType myContentType;
        @Nullable
        private final Listener myListener;

        ConsoleAwareOutputStream(@NotNull GradleOutputForwarder output, @NotNull ConsoleViewContentType contentType, @Nullable Listener listener) {
            this.myOutput = output;
            this.myContentType = contentType;
            this.myListener = listener;
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) {
            if (this.myListener != null) {
                this.myListener.onOutput(this.myContentType, b, off, len);
            }
            this.myOutput.write(this.myContentType, b, off, len);
        }
    }

    static interface Listener {
        public void onOutput(@NotNull ConsoleViewContentType var1, @NotNull byte[] var2, int var3, int var4);
    }
}

