/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.ui;

import com.android.tools.idea.gradle.editor.entity.GradleEditorEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorEntityGroup;
import com.android.tools.idea.gradle.editor.ui.GradleEditorEntityTable;
import com.android.tools.idea.gradle.editor.ui.GradleEditorUiConstants;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class GradleEditorComponent
extends JBScrollPane {
    private final Map<String, GradleEditorEntityTable> myTablesByGroupName = Maps.newHashMap();
    private final Map<String, JBPanel> myPanelsByGroupName = Maps.newHashMap();
    private final JBPanel myCanvas = new JBPanel((LayoutManager)new GridBagLayout());
    @NotNull
    private final Project myProject;

    public GradleEditorComponent(@NotNull Project project, @NotNull List<GradleEditorEntityGroup> groups) {
        this.myProject = project;
        this.setViewportView((Component)this.myCanvas);
        this.myCanvas.setBackground(GradleEditorUiConstants.BACKGROUND_COLOR);
        this.setData(groups);
    }

    private void addUiForGroup(@NotNull GradleEditorEntityGroup group) {
        JBPanel panel = new JBPanel((LayoutManager)new BorderLayout());
        panel.setBackground(UIUtil.getTableBackground());
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)group.getName()));
        GradleEditorEntityTable table = new GradleEditorEntityTable(this.myProject);
        for (GradleEditorEntity entity : group.getEntities()) {
            table.getModel().add(entity);
        }
        panel.add((Component)((Object)table));
        this.addUiForGroup(group.getName(), panel, table);
    }

    private void addUiForGroup(@NotNull String groupName, @NotNull JBPanel component, @NotNull GradleEditorEntityTable table) {
        GridBag constraints = new GridBag().weightx(1.0).anchor(17).fillCellHorizontally().coverLine().insets(8, 8, 8, 8);
        this.myCanvas.add((Component)component, (Object)constraints);
        this.myTablesByGroupName.put(groupName, table);
        this.myPanelsByGroupName.put(groupName, component);
    }

    public void flushChanges() {
        for (GradleEditorEntityTable table : this.myTablesByGroupName.values()) {
            if (!table.isEditing()) continue;
            table.getCellEditor().stopCellEditing();
        }
    }

    public void setData(@NotNull List<GradleEditorEntityGroup> groups) {
        boolean sameTables = groups.size() == this.myTablesByGroupName.size();
        for (GradleEditorEntityGroup group : groups) {
            GradleEditorEntityTable table = this.myTablesByGroupName.get(group.getName());
            if (table == null) {
                sameTables = false;
                continue;
            }
            if (table.isEditing()) {
                table.getCellEditor().stopCellEditing();
            }
            table.getModel().setData(group.getEntities());
        }
        if (sameTables) {
            return;
        }
        this.myCanvas.removeAll();
        HashMap tablesByGroupName = Maps.newHashMap(this.myTablesByGroupName);
        this.myTablesByGroupName.clear();
        HashMap panelsByGroupName = Maps.newHashMap(this.myPanelsByGroupName);
        this.myPanelsByGroupName.clear();
        for (GradleEditorEntityGroup group : groups) {
            JBPanel panel = (JBPanel)panelsByGroupName.get(group.getName());
            GradleEditorEntityTable table = (GradleEditorEntityTable)((Object)tablesByGroupName.get(group.getName()));
            if (panel != null && table != null) {
                this.addUiForGroup(group.getName(), panel, table);
                continue;
            }
            this.addUiForGroup(group);
        }
        this.myCanvas.add((Component)new JLabel(" "), (Object)new GridBag().weighty(1.0));
    }
}

