/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.parser;

import com.android.tools.idea.gradle.editor.parser.GradleEditorModelUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleEditorModelParseContext {
    public static final String NO_ARGS_METHOD_ASSIGNMENT_VALUE = "()";
    private final Multimap<Variable, Assignment> myAssignmentsByVariable = HashMultimap.create();
    private final Multimap<List<String>, Assignment> myAssignmentsByCodeStructure = HashMultimap.create();
    private final List<String> myCodeStructure = Lists.newArrayList();
    private final List<String> myCachedVariableQualifier = Lists.newArrayList();
    private final Multimap<Variable, Location> myCachedVariables = HashMultimap.create();
    private final List<Value> myCachedValues = Lists.newArrayList();
    @NotNull
    private final VirtualFile myTargetFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private VirtualFile myCurrentFile;

    public GradleEditorModelParseContext(@NotNull VirtualFile targetFile, @NotNull Project project) {
        this.myTargetFile = targetFile;
        this.myCurrentFile = targetFile;
        this.myProject = project;
    }

    @NotNull
    public VirtualFile getTargetFile() {
        return this.myTargetFile;
    }

    @NotNull
    public VirtualFile getCurrentFile() {
        return this.myCurrentFile;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public List<Value> getCachedValues() {
        return this.myCachedValues;
    }

    public void addCachedValue(@NotNull String value, @NotNull TextRange range) {
        this.addCachedValue(new Value(value, new Location(this.myCurrentFile, range)));
    }

    public void addCachedValue(@Nullable Value value) {
        this.myCachedValues.add(value);
    }

    public void setCachedValues(@NotNull List<Value> values) {
        this.myCachedValues.clear();
        this.myCachedValues.addAll(values);
    }

    @NotNull
    public Multimap<Variable, Location> getCachedVariables() {
        return this.myCachedVariables;
    }

    public void addCachedVariable(@NotNull String variableName, @NotNull TextRange range) {
        this.addCachedVariable(new Variable(variableName, this.myCachedVariableQualifier), range);
    }

    public void addCachedVariable(@Nullable Variable variable, @NotNull TextRange range) {
        this.myCachedVariables.put((Object)variable, (Object)new Location(this.myCurrentFile, range));
    }

    @NotNull
    public Collection<Assignment> getAssignments(@NotNull Variable variable) {
        Collection result = this.myAssignmentsByVariable.get((Object)variable);
        return result == null ? Collections.emptyList() : result;
    }

    @NotNull
    public Collection<Assignment> getAssignments(@NotNull List<String> codeStructure) {
        Collection result = this.myAssignmentsByCodeStructure.get(codeStructure);
        return result == null ? Collections.emptyList() : result;
    }

    public void onChangeFile(@NotNull VirtualFile file) {
        this.myCurrentFile = file;
    }

    public void onMethodEnter(@NotNull String methodName) {
        this.myCodeStructure.add(methodName);
    }

    public void onMethodExit() {
        if (!this.myCodeStructure.isEmpty()) {
            this.myCodeStructure.remove(this.myCodeStructure.size() - 1);
        }
    }

    public boolean registerAssignmentFromCachedData(String lValueVariableName, @NotNull TextRange range, @NotNull PsiElement valueElement) {
        return this.registerAssignmentFromCachedData(new Variable(lValueVariableName, this.myCachedVariableQualifier), range, valueElement);
    }

    public boolean registerAssignmentFromCachedData(Variable lValue, @NotNull TextRange lValueRange, @NotNull PsiElement valueElement) {
        return this.registerAssignmentFromCachedData(lValue, new Location(this.myCurrentFile, lValueRange), valueElement);
    }

    public boolean registerAssignmentFromCachedData(Variable lValue, @NotNull Location lValueLocation, @NotNull PsiElement valueElement) {
        Value valueToUse;
        if (this.myCachedValues.isEmpty() && this.myCachedVariables.isEmpty()) {
            return false;
        }
        String wholeElementText = GradleEditorModelUtil.unquote(valueElement.getText());
        TextRange wholeElementRange = GradleEditorModelUtil.interestedRange(valueElement);
        if (this.myCachedVariables.isEmpty()) {
            switch (this.myCachedValues.size()) {
                case 0: {
                    valueToUse = null;
                    break;
                }
                case 1: {
                    valueToUse = this.myCachedValues.get(0);
                    break;
                }
                default: {
                    valueToUse = new Value(wholeElementText, new Location(this.myCurrentFile, wholeElementRange));
                    break;
                }
            }
        } else {
            valueToUse = this.myCachedVariables.size() == 1 && GradleEditorModelUtil.isVariable(valueElement.getText(), ((Variable)this.myCachedVariables.keys().iterator().next()).name) ? null : new Value("", new Location(this.myCurrentFile, wholeElementRange));
        }
        TextRange assignmentRange = TextRange.create((int)lValueLocation.range.getStartOffset(), (int)valueElement.getTextRange().getEndOffset());
        this.onAssignment(assignmentRange, lValue, lValueLocation, new Location(this.myCurrentFile, wholeElementRange), valueToUse, wholeElementText, this.myCachedVariables);
        this.resetCaches();
        return true;
    }

    public void onAssignment(@NotNull TextRange assignmentRange, Variable lValue, @NotNull Location lValueLocation, @NotNull Location rValueLocation, @Nullable Value rValue, @Nullable String rValueString, @NotNull Multimap<Variable, Location> dependencies) {
        this.onAssignment(new Assignment(assignmentRange, lValue, lValueLocation, rValueLocation, this.myCodeStructure, rValue, rValueString, dependencies));
    }

    public void onAssignment(@NotNull Assignment assignment) {
        this.myAssignmentsByVariable.put((Object)assignment.lValue, (Object)assignment);
        this.myAssignmentsByCodeStructure.put(assignment.codeStructure, (Object)assignment);
    }

    public void rememberVariableQualifier(@NotNull String qualifier) {
        if (!qualifier.isEmpty()) {
            this.myCachedVariableQualifier.add(qualifier);
        }
    }

    public void resetCaches() {
        this.myCachedVariableQualifier.clear();
        this.myCachedVariables.clear();
        this.myCachedValues.clear();
    }

    public static class Location {
        @NotNull
        public final VirtualFile file;
        @NotNull
        public final TextRange range;

        public Location(@NotNull VirtualFile file, @NotNull TextRange range) {
            this.file = file;
            this.range = range;
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = 31 * result + this.range.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            return this.file.equals(location.file) && this.range.equals((Object)location.range);
        }

        public String toString() {
            return String.format("%s [%d;%d)", this.file.getName(), this.range.getStartOffset(), this.range.getEndOffset());
        }
    }

    public static class Value {
        @NotNull
        public final String value;
        @NotNull
        public final Location location;

        public Value(@NotNull String value, @NotNull Location location) {
            this.value = value;
            this.location = location;
        }

        @NotNull
        public Value shrink(@NotNull TextRange range) {
            if (range.equals((Object)this.location.range)) {
                return this;
            }
            if (range.getStartOffset() < this.location.range.getStartOffset() || range.getStartOffset() >= this.location.range.getEndOffset() || range.getEndOffset() > this.location.range.getEndOffset()) {
                throw new IllegalArgumentException(String.format("Can't shrink value '%s' to range %s. Reason - given range is not inside the current one (%s)", this, range, this.location.range));
            }
            int newValueStartOffset = range.getStartOffset() - this.location.range.getStartOffset();
            int newValueEndOffset = this.value.length() - (this.location.range.getEndOffset() - range.getEndOffset());
            return new Value(this.value.substring(newValueStartOffset, newValueEndOffset), new Location(this.location.file, range));
        }

        public String toString() {
            return String.format("'%s' at %s", this.value, this.location);
        }
    }

    public static class Assignment {
        @NotNull
        public final TextRange assignmentRange;
        @NotNull
        public final Variable lValue;
        @NotNull
        public final Location lValueLocation;
        @NotNull
        public final Location rValueLocation;
        @NotNull
        public final List<String> codeStructure;
        @Nullable
        public final Value value;
        @Nullable
        public final String rValueString;
        @NotNull
        public final Multimap<Variable, Location> dependencies;

        public Assignment(@NotNull TextRange assignmentRange, @NotNull Variable lValue, @NotNull Location lValueLocation, @NotNull Location rValueLocation, @NotNull List<String> codeStructure, @Nullable Value value, @Nullable String rValueString, @NotNull Multimap<Variable, Location> dependencies) {
            this.assignmentRange = assignmentRange;
            this.lValue = lValue;
            this.lValueLocation = lValueLocation;
            this.rValueLocation = rValueLocation;
            this.codeStructure = codeStructure.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf(codeStructure);
            this.value = value;
            this.rValueString = rValueString;
            this.dependencies = dependencies.isEmpty() ? ImmutableMultimap.of() : ImmutableMultimap.copyOf(dependencies);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(StringUtil.join(this.codeStructure, (String)"->"));
            if (buffer.length() > 0) {
                buffer.append(": ");
            }
            buffer.append(this.lValue);
            if (this.rValueString != null) {
                buffer.append(" = ").append(this.rValueString);
            } else if (this.value != null) {
                buffer.append(" = ").append(this.value);
            }
            if (!this.dependencies.isEmpty()) {
                buffer.append(" depends on ").append(StringUtil.join((Iterable)this.dependencies.keySet(), (String)","));
            }
            return buffer.toString();
        }
    }

    public static final class Variable {
        @NotNull
        public final String name;
        @NotNull
        public final List<String> qualifier;

        public Variable(@NotNull String name, @NotNull List<String> qualifier) {
            this.name = name;
            this.qualifier = ImmutableList.copyOf(qualifier);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            return 31 * result + this.qualifier.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            return this.name.equals(variable.name) && this.qualifier.equals(variable.qualifier);
        }

        public String toString() {
            String q = this.qualifier.isEmpty() ? "" : StringUtil.join(this.qualifier, (String)".") + ".";
            return q + this.name;
        }
    }
}

