/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.action;

import com.android.tools.idea.gradle.editor.action.AbstractGradleEntityAction;
import com.android.tools.idea.gradle.editor.entity.GradleEditorEntity;
import com.google.common.base.Strings;
import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class GradleEntityHelpAction
extends AbstractGradleEntityAction {
    public GradleEntityHelpAction() {
        Presentation presentation = this.getTemplatePresentation();
        presentation.setIcon(AllIcons.Actions.Help);
        presentation.setText(CommonBundle.getHelpButtonText());
    }

    @Override
    protected void doActionPerformed(@NotNull GradleEditorEntity entity, AnActionEvent event) {
        String helpId = entity.getHelpId();
        if (Strings.isNullOrEmpty((String)helpId)) {
            return;
        }
        assert (helpId != null);
        Project project = (Project)CommonDataKeys.PROJECT.getData(event.getDataContext());
        BrowserUtil.browse((String)helpId, (Project)project);
    }
}

