/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.java;

import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageLevelUtil {
    @Nullable
    public static LanguageLevel parseFromGradleString(@NotNull String gradleString) {
        String digitalVersion = gradleString.startsWith("JavaVersion.VERSION_") ? gradleString.substring("JavaVersion.VERSION_".length()).replace('_', '.') : (gradleString.startsWith("VERSION_") ? gradleString.substring("VERSION_".length()).replace('_', '.') : (gradleString.startsWith("'") || gradleString.startsWith("\"") ? gradleString.substring(1, gradleString.length() - 1) : gradleString));
        return LanguageLevel.parse((String)digitalVersion);
    }

    @NotNull
    public static String convertToGradleString(@NotNull LanguageLevel languageLevel, @Nullable String sampleGradleString) {
        String underscoreVersion = languageLevel.name().substring("JDK_".length());
        String dotVersion = underscoreVersion.replace('_', '.');
        if (sampleGradleString != null) {
            if (sampleGradleString.startsWith("JavaVersion.VERSION_")) {
                return "JavaVersion.VERSION_" + underscoreVersion;
            }
            if (sampleGradleString.startsWith("VERSION_")) {
                return "VERSION_" + underscoreVersion;
            }
            if (sampleGradleString.startsWith("'")) {
                return "'" + dotVersion + "'";
            }
            if (sampleGradleString.startsWith("\"")) {
                return "\"" + dotVersion + "\"";
            }
        }
        return dotVersion;
    }
}

