/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;

public abstract class GradlePropertiesDslElement
extends GradleDslElement {
    @NotNull
    private Map<String, GradleDslElement> myProperties = Maps.newLinkedHashMap();
    @NotNull
    private Map<String, GradleDslElement> myToBeAddedProperties = Maps.newLinkedHashMap();
    @NotNull
    private Set<String> myToBeRemovedProperties = Sets.newLinkedHashSet();

    protected GradlePropertiesDslElement(@Nullable GradleDslElement parent, @Nullable GroovyPsiElement psiElement, @NotNull String name) {
        super(parent, psiElement, name);
    }

    public void setParsedElement(@NotNull String property, @NotNull GradleDslElement element) {
        element.myParent = this;
        this.myProperties.put(property, element);
    }

    public void addParsedElement(@NotNull String property, @NotNull GradleDslElement element) {
        element.myParent = this;
        this.myProperties.put(property, element);
    }

    protected void addAsParsedDslExpressionList(@NotNull String property, GradleDslExpression dslLiteral) {
        GroovyPsiElement psiElement = dslLiteral.getPsiElement();
        if (psiElement == null) {
            return;
        }
        GradleDslExpressionList literalList = new GradleDslExpressionList(this, psiElement, property);
        literalList.addParsedExpression(dslLiteral);
        this.myProperties.put(property, literalList);
    }

    public void addToParsedExpressionList(@NotNull String property, @NotNull GradleDslElement element) {
        GroovyPsiElement psiElement = element.getPsiElement();
        if (psiElement == null) {
            return;
        }
        GradleDslExpressionList gradleDslExpressionList = this.getProperty(property, GradleDslExpressionList.class);
        if (gradleDslExpressionList == null) {
            gradleDslExpressionList = new GradleDslExpressionList(this, psiElement, property);
            this.myProperties.put(property, gradleDslExpressionList);
        } else {
            gradleDslExpressionList.setPsiElement(psiElement);
        }
        if (element instanceof GradleDslExpression) {
            gradleDslExpressionList.addParsedExpression((GradleDslExpression)element);
        } else if (element instanceof GradleDslExpressionList) {
            List<GradleDslExpression> gradleExpressions = ((GradleDslExpressionList)element).getExpressions();
            for (GradleDslExpression expression : gradleExpressions) {
                gradleDslExpressionList.addParsedExpression(expression);
            }
        }
    }

    @NotNull
    public List<String> getProperties() {
        ArrayList result = Lists.newArrayList();
        result.addAll(this.myProperties.keySet());
        result.addAll(this.myToBeAddedProperties.keySet());
        result.removeAll(this.myToBeRemovedProperties);
        return result;
    }

    @NotNull
    public Map<String, GradleDslElement> getPropertyElements() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        result.putAll(this.myProperties);
        result.putAll(this.myToBeAddedProperties);
        for (String toBeRemoved : this.myToBeRemovedProperties) {
            result.remove(toBeRemoved);
        }
        return result;
    }

    @Nullable
    public GradleDslElement getPropertyElement(@NotNull String property) {
        if (!property.contains(".")) {
            if (this.myToBeRemovedProperties.contains(property)) {
                return null;
            }
            GradleDslElement toBeAddedElement = this.myToBeAddedProperties.get(property);
            return toBeAddedElement != null ? toBeAddedElement : this.myProperties.get(property);
        }
        List propertyNameSegments = Splitter.on((char)'.').splitToList((CharSequence)property);
        GradlePropertiesDslElement nestedElement = this;
        for (int i = 0; i < propertyNameSegments.size() - 1; ++i) {
            GradleDslElement element = nestedElement.getPropertyElement(((String)propertyNameSegments.get(i)).trim());
            if (!(element instanceof GradlePropertiesDslElement)) {
                return null;
            }
            nestedElement = (GradlePropertiesDslElement)element;
        }
        return nestedElement.getPropertyElement((String)propertyNameSegments.get(propertyNameSegments.size() - 1));
    }

    @NotNull
    public <T> GradleNullableValue<T> getPropertyValue(@NotNull String property, @NotNull Class<T> clazz) {
        GradleDslElement propertyElement = this.getPropertyElement(property);
        if (propertyElement != null) {
            Object resultValue = null;
            if (clazz.isInstance(propertyElement)) {
                resultValue = clazz.cast(propertyElement);
            } else if (propertyElement instanceof GradleDslExpression) {
                resultValue = ((GradleDslExpression)propertyElement).getValue(clazz);
            }
            if (resultValue != null) {
                return new GradleNullableValue<Object>(propertyElement, resultValue);
            }
        }
        return new GradleNullableValue<Object>(this, null);
    }

    @Nullable
    public <T> T getProperty(@NotNull String property, @NotNull Class<T> clazz) {
        return this.getPropertyValue(property, clazz).value();
    }

    @NotNull
    public GradlePropertiesDslElement setNewElement(@NotNull String property, @NotNull GradleDslElement newElement) {
        newElement.myParent = this;
        this.myToBeAddedProperties.put(property, newElement);
        this.setModified(true);
        return this;
    }

    @NotNull
    public GradlePropertiesDslElement setNewLiteral(@NotNull String property, @NotNull String value) {
        return this.setNewLiteralImpl(property, value);
    }

    @NotNull
    public GradlePropertiesDslElement setNewLiteral(@NotNull String property, @NotNull Integer value) {
        return this.setNewLiteralImpl(property, value);
    }

    @NotNull
    public GradlePropertiesDslElement setNewLiteral(@NotNull String property, @NotNull Boolean value) {
        return this.setNewLiteralImpl(property, value);
    }

    @NotNull
    private GradlePropertiesDslElement setNewLiteralImpl(@NotNull String property, @NotNull Object value) {
        GradleDslLiteral literalElement = this.getProperty(property, GradleDslLiteral.class);
        if (literalElement == null) {
            literalElement = new GradleDslLiteral(this, property);
            this.myToBeAddedProperties.put(property, literalElement);
        }
        literalElement.setValue(value);
        return this;
    }

    @NotNull
    public GradlePropertiesDslElement addToNewLiteralList(@NotNull String property, @NotNull String value) {
        return this.addToNewLiteralListImpl(property, value);
    }

    @NotNull
    private GradlePropertiesDslElement addToNewLiteralListImpl(@NotNull String property, @NotNull Object value) {
        GradleDslExpressionList gradleDslExpressionList = this.getProperty(property, GradleDslExpressionList.class);
        if (gradleDslExpressionList == null) {
            gradleDslExpressionList = new GradleDslExpressionList(this, property);
            this.myToBeAddedProperties.put(property, gradleDslExpressionList);
        }
        gradleDslExpressionList.addNewLiteral(value);
        return this;
    }

    @NotNull
    public GradlePropertiesDslElement removeFromExpressionList(@NotNull String property, @NotNull String value) {
        return this.removeFromExpressionListImpl(property, value);
    }

    @NotNull
    private GradlePropertiesDslElement removeFromExpressionListImpl(@NotNull String property, @NotNull Object value) {
        GradleDslExpressionList gradleDslExpressionList = this.getProperty(property, GradleDslExpressionList.class);
        if (gradleDslExpressionList != null) {
            gradleDslExpressionList.removeExpression(value);
        }
        return this;
    }

    @NotNull
    public GradlePropertiesDslElement replaceInExpressionList(@NotNull String property, @NotNull String oldValue, @NotNull String newValue) {
        return this.replaceInExpressionListImpl(property, oldValue, newValue);
    }

    @NotNull
    private GradlePropertiesDslElement replaceInExpressionListImpl(@NotNull String property, @NotNull Object oldValue, @NotNull Object newValue) {
        GradleDslExpressionList gradleDslExpressionList = this.getProperty(property, GradleDslExpressionList.class);
        if (gradleDslExpressionList != null) {
            gradleDslExpressionList.replaceExpression(oldValue, newValue);
        }
        return this;
    }

    @NotNull
    public GradlePropertiesDslElement setInNewLiteralMap(@NotNull String property, @NotNull String name, @NotNull String value) {
        return this.setInNewLiteralMapImpl(property, name, value);
    }

    @NotNull
    public GradlePropertiesDslElement setInNewLiteralMap(@NotNull String property, @NotNull String name, @NotNull Integer value) {
        return this.setInNewLiteralMapImpl(property, name, value);
    }

    @NotNull
    public GradlePropertiesDslElement setInNewLiteralMap(@NotNull String property, @NotNull String name, @NotNull Boolean value) {
        return this.setInNewLiteralMapImpl(property, name, value);
    }

    @NotNull
    private GradlePropertiesDslElement setInNewLiteralMapImpl(@NotNull String property, @NotNull String name, @NotNull Object value) {
        GradleDslExpressionMap gradleDslExpressionMap = this.getProperty(property, GradleDslExpressionMap.class);
        if (gradleDslExpressionMap == null) {
            gradleDslExpressionMap = new GradleDslExpressionMap(this, property);
            this.myToBeAddedProperties.put(property, gradleDslExpressionMap);
        }
        gradleDslExpressionMap.addNewLiteral(name, value);
        return this;
    }

    @NotNull
    public GradlePropertiesDslElement removeFromExpressionMap(@NotNull String property, @NotNull String name) {
        GradleDslExpressionMap gradleDslExpressionMap = this.getProperty(property, GradleDslExpressionMap.class);
        if (gradleDslExpressionMap != null) {
            gradleDslExpressionMap.removeProperty(name);
        }
        return this;
    }

    public void removeProperty(@NotNull String property) {
        this.myToBeRemovedProperties.add(property);
        this.setModified(true);
    }

    @Nullable
    public <E> List<E> getListProperty(@NotNull String property, @NotNull Class<E> clazz) {
        GradleDslExpressionList gradleDslExpressionList = this.getProperty(property, GradleDslExpressionList.class);
        if (gradleDslExpressionList != null) {
            return gradleDslExpressionList.getValues(clazz);
        }
        return null;
    }

    @Nullable
    public <V> Map<String, V> getMapProperty(@NotNull String property, @NotNull Class<V> clazz) {
        GradleDslExpressionMap gradleDslExpressionMap = this.getProperty(property, GradleDslExpressionMap.class);
        if (gradleDslExpressionMap != null) {
            return gradleDslExpressionMap.getValues(clazz);
        }
        return null;
    }

    @Override
    @NotNull
    protected Collection<GradleDslElement> getChildren() {
        return this.getPropertyElements().values();
    }

    @Override
    protected void apply() {
        for (Map.Entry<String, GradleDslElement> entry : this.myToBeAddedProperties.entrySet()) {
            String property = entry.getKey();
            GradleDslElement element = entry.getValue();
            if (element.create() == null) continue;
            this.setParsedElement(property, element);
        }
        this.myToBeAddedProperties.clear();
        for (String property : this.myToBeRemovedProperties) {
            GradleDslElement element = this.myProperties.remove(property);
            if (element == null) continue;
            element.delete();
        }
        this.myToBeRemovedProperties.clear();
        for (GradleDslElement element : this.myProperties.values()) {
            if (!element.isModified()) continue;
            element.applyChanges();
        }
    }

    @Override
    protected void reset() {
        for (GradleDslElement element : this.getPropertyElements().values()) {
            if (!element.isModified()) continue;
            element.resetState();
        }
        this.myToBeAddedProperties.clear();
        this.myToBeRemovedProperties.clear();
    }

    protected void clear() {
        this.myToBeRemovedProperties.clear();
        this.myToBeAddedProperties.clear();
        this.myProperties.clear();
    }
}

