/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslReference;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;

public final class GradleDslNewExpression
extends GradleDslExpression {
    @NotNull
    private final List<GradleDslExpression> myArguments = Lists.newArrayList();

    public GradleDslNewExpression(@NotNull GradleDslElement parent, @NotNull GrNewExpression newExpression, @NotNull String name) {
        super(parent, (GroovyPsiElement)newExpression, name, (GrExpression)newExpression);
    }

    public void addParsedExpression(@NotNull GradleDslExpression expression) {
        expression.myParent = this;
        this.myArguments.add(expression);
    }

    @NotNull
    public List<GradleDslExpression> getArguments() {
        ArrayList result = Lists.newArrayList();
        for (GradleDslExpression argument : this.myArguments) {
            GradleDslExpressionList listValue;
            if (argument instanceof GradleDslReference && (listValue = argument.getValue(GradleDslExpressionList.class)) != null) {
                result.addAll(listValue.getExpressions());
                continue;
            }
            result.add(argument);
        }
        return result;
    }

    @Override
    @NotNull
    protected Collection<GradleDslElement> getChildren() {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public Object getValue() {
        GroovyPsiElement psiElement = this.getPsiElement();
        return psiElement != null ? psiElement.getText() : null;
    }

    @Override
    @Nullable
    public <T> T getValue(@NotNull Class<T> clazz) {
        if (clazz.isAssignableFrom(File.class)) {
            return clazz.cast(this.getFileValue());
        }
        Object value = this.getValue();
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        return null;
    }

    @Nullable
    private File getFileValue() {
        if (!this.myName.equals("File")) {
            return null;
        }
        List<GradleDslExpression> arguments = this.getArguments();
        if (arguments.isEmpty()) {
            return null;
        }
        String firstArgumentValue = arguments.get(0).getValue(String.class);
        if (firstArgumentValue == null) {
            return null;
        }
        File result = new File(firstArgumentValue);
        for (int i = 1; i < arguments.size(); ++i) {
            String value = arguments.get(i).getValue(String.class);
            if (value == null) {
                return null;
            }
            result = new File(result, value);
        }
        return result;
    }

    @Override
    public void setValue(@NotNull Object value) {
    }

    @Override
    protected void apply() {
    }

    @Override
    protected void reset() {
    }

    @Override
    @Nullable
    public GroovyPsiElement create() {
        return this.getPsiElement();
    }
}

