/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.values;

import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.parser.GradleResolvedVariable;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;

public abstract class GradleValue {
    @NotNull
    protected final GradleDslElement myDslElement;

    protected GradleValue(@NotNull GradleDslElement dslElement) {
        this.myDslElement = dslElement;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myDslElement.getDslFile().getFile();
    }

    @NotNull
    public String getPropertyName() {
        return this.myDslElement.getQualifiedName();
    }

    @Nullable
    public String getDslText() {
        GroovyPsiElement psiElement = this.myDslElement.getPsiElement();
        return psiElement != null ? psiElement.getText() : null;
    }

    @NotNull
    public Map<String, GradleNotNullValue<Object>> getResolvedVariables() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (GradleResolvedVariable variable : this.myDslElement.getResolvedVariables()) {
            String variableName = variable.getVariableName();
            Object resolvedValue = variable.getValue();
            GradleDslElement element = variable.getElement();
            builder.put((Object)variableName, new GradleNotNullValue<Object>(element, resolvedValue));
        }
        return builder.build();
    }
}

