/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.repositories;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.repositories.FlatDirRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.JCenterDefaultRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.JCenterRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.MavenCentralRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.MavenRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.RepositoryModel;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.FlatDirRepositoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.MavenRepositoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RepositoriesModel
extends GradleDslBlockModel {
    public RepositoriesModel(@NotNull RepositoriesDslElement dslElement) {
        super(dslElement);
    }

    @NotNull
    public List<RepositoryModel> repositories() {
        GradleDslElementList repositoriesElementList = this.myDslElement.getProperty("repositories", GradleDslElementList.class);
        if (repositoriesElementList == null) {
            return ImmutableList.of();
        }
        ArrayList result = Lists.newArrayList();
        for (GradleDslElement element : repositoriesElementList.getElements()) {
            if (element instanceof GradleDslMethodCall) {
                if ("mavenCentral".equals(element.getName())) {
                    result.add(new MavenCentralRepositoryModel());
                    continue;
                }
                if (!"jcenter".equals(element.getName())) continue;
                result.add(new JCenterDefaultRepositoryModel());
                continue;
            }
            if (element instanceof MavenRepositoryDslElement) {
                if ("maven".equals(element.getName())) {
                    result.add(new MavenRepositoryModel((MavenRepositoryDslElement)element));
                    continue;
                }
                if (!"jcenter".equals(element.getName())) continue;
                result.add(new JCenterRepositoryModel((MavenRepositoryDslElement)element));
                continue;
            }
            if (element instanceof FlatDirRepositoryDslElement) {
                result.add(new FlatDirRepositoryModel((FlatDirRepositoryDslElement)element));
                continue;
            }
            if (!(element instanceof GradleDslExpressionMap)) continue;
            if ("mavenCentral".equals(element.getName())) {
                result.add(new MavenCentralRepositoryModel((GradleDslExpressionMap)element));
                continue;
            }
            if (!"flatDir".equals(element.getName())) continue;
            result.add(new FlatDirRepositoryModel((GradlePropertiesDslElement)element));
        }
        return result;
    }
}

