/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.repositories;

import com.android.tools.idea.gradle.dsl.model.repositories.MavenCredentialsModel;
import com.android.tools.idea.gradle.dsl.model.repositories.UrlBasedRepositoryModel;
import com.android.tools.idea.gradle.dsl.parser.repositories.MavenCredentialsDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.MavenRepositoryDslElement;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenRepositoryModel
extends UrlBasedRepositoryModel {
    @NonNls
    private static final String URL = "url";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String ARTIFACT_URLS = "artifactUrls";
    @NotNull
    private final MavenRepositoryDslElement myDslElement;
    @NotNull
    private final String myDefaultRepoName;
    @NotNull
    private final String myDefaultRepoUrl;

    public MavenRepositoryModel(@NotNull MavenRepositoryDslElement dslElement) {
        this(dslElement, "maven", "https://repo1.maven.org/maven2/");
    }

    protected MavenRepositoryModel(@NotNull MavenRepositoryDslElement dslElement, @NotNull String defaultRepoName, @NotNull String defaultRepoUrl) {
        this.myDslElement = dslElement;
        this.myDefaultRepoName = defaultRepoName;
        this.myDefaultRepoUrl = defaultRepoUrl;
    }

    @Override
    @NotNull
    public String name() {
        String name = this.myDslElement.getProperty(NAME, String.class);
        return name != null ? name : this.myDefaultRepoName;
    }

    @Override
    @NotNull
    public String url() {
        String url = this.myDslElement.getProperty(URL, String.class);
        return url != null ? url : this.myDefaultRepoUrl;
    }

    @NotNull
    public List<String> artifactUrls() {
        ImmutableList artifactUrls = this.myDslElement.getListProperty(ARTIFACT_URLS, String.class);
        return artifactUrls != null ? artifactUrls : ImmutableList.of();
    }

    @Nullable
    public MavenCredentialsModel credentials() {
        MavenCredentialsDslElement credentials = this.myDslElement.getProperty("credentials", MavenCredentialsDslElement.class);
        return credentials != null ? new MavenCredentialsModel(credentials) : null;
    }
}

