/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDependencyModel
extends DependencyModel {
    private static final Logger LOG = Logger.getInstance(ModuleDependencyModel.class);
    @NonNls
    private static final String PROJECT = "project";
    @NonNls
    private static final String PATH = "path";
    @NonNls
    private static final String CONFIGURATION = "configuration";
    @NotNull
    private String myConfigurationName;
    @NotNull
    private GradleDslMethodCall myDslElement;
    @NotNull
    private GradleDslExpression myPath;
    @Nullable
    private GradleDslExpression myConfiguration;

    @NotNull
    protected static List<ModuleDependencyModel> create(@NotNull String configurationName, @NotNull GradleDslMethodCall methodCall) {
        ArrayList result = Lists.newArrayList();
        if (PROJECT.equals(methodCall.getName())) {
            for (GradleDslElement argument : methodCall.getArguments()) {
                if (argument instanceof GradleDslExpression) {
                    result.add(new ModuleDependencyModel(configurationName, methodCall, (GradleDslExpression)argument, null));
                    continue;
                }
                if (!(argument instanceof GradleDslExpressionMap)) continue;
                GradleDslExpressionMap dslMap = (GradleDslExpressionMap)argument;
                GradleDslExpression pathElement = dslMap.getProperty(PATH, GradleDslExpression.class);
                if (pathElement == null) {
                    assert (methodCall.getPsiElement() != null);
                    String msg = String.format("'%1$s' is not a valid module dependency", methodCall.getPsiElement().getText());
                    LOG.warn(msg);
                    continue;
                }
                GradleDslExpression configuration = dslMap.getProperty(CONFIGURATION, GradleDslExpression.class);
                result.add(new ModuleDependencyModel(configurationName, methodCall, pathElement, configuration));
            }
        }
        return result;
    }

    public static void createAndAddToList(@NotNull GradleDslElementList list, @NotNull String configurationName, @NotNull String path, @Nullable String config) {
        String methodName = PROJECT;
        GradleDslMethodCall methodCall = new GradleDslMethodCall((GradleDslElement)list, methodName, configurationName);
        GradleDslExpressionMap mapArguments = new GradleDslExpressionMap(methodCall, methodName);
        mapArguments.setNewLiteral(PATH, path);
        if (config != null) {
            mapArguments.setNewLiteral(CONFIGURATION, config);
        }
        methodCall.addNewArgument(mapArguments);
        list.addNewElement(methodCall);
    }

    private ModuleDependencyModel(@NotNull String configurationName, @NotNull GradleDslMethodCall dslElement, @NotNull GradleDslExpression path, @Nullable GradleDslExpression configuration) {
        this.myConfigurationName = configurationName;
        this.myDslElement = dslElement;
        this.myPath = path;
        this.myConfiguration = configuration;
    }

    @Override
    @NotNull
    protected GradleDslMethodCall getDslElement() {
        return this.myDslElement;
    }

    @Override
    @NotNull
    public String configurationName() {
        return this.myConfigurationName;
    }

    @NotNull
    public String name() {
        List<String> pathSegments = GradleUtil.getPathSegments(this.path());
        int segmentCount = pathSegments.size();
        return segmentCount > 0 ? pathSegments.get(segmentCount - 1) : "";
    }

    public void setName(@NotNull String name) {
        String newPath;
        List segments = Splitter.on((String)":").splitToList((CharSequence)this.path());
        ArrayList modifiableSegments = Lists.newArrayList((Iterable)segments);
        int segmentCount = modifiableSegments.size();
        if (segmentCount == 0) {
            newPath = ":" + name.trim();
        } else {
            modifiableSegments.set(segmentCount - 1, name);
            newPath = Joiner.on((String)":").join((Iterable)modifiableSegments);
        }
        this.setPath(newPath);
    }

    @NotNull
    public String path() {
        String path = this.myPath.getValue(String.class);
        assert (path != null);
        return path;
    }

    public void setPath(@NotNull String path) {
        this.myPath.setValue(path);
    }

    @Nullable
    public String configuration() {
        if (this.myConfiguration == null) {
            return null;
        }
        return this.myConfiguration.getValue(String.class);
    }

    void setConfiguration(@NotNull String configuration) {
        if (this.myConfiguration != null) {
            this.myConfiguration.setValue(configuration);
            return;
        }
        GradleDslElement parent = this.myPath.getParent();
        if (parent instanceof GradleDslExpressionMap) {
            ((GradleDslExpressionMap)parent).setNewLiteral(CONFIGURATION, configuration);
        } else {
            String path = this.path();
            if (this.myPath instanceof GradleDslLiteral) {
                GradleDslExpressionMap newMapArgument = new GradleDslExpressionMap(this.myDslElement, PROJECT);
                newMapArgument.setNewLiteral(PATH, path);
                newMapArgument.setNewLiteral(CONFIGURATION, configuration);
                this.myDslElement.remove(this.myPath);
                this.myDslElement.addNewArgument(newMapArgument);
            }
        }
    }

    void removeConfiguration() {
        GradleDslElement parent;
        if (this.myConfiguration != null && (parent = this.myConfiguration.getParent()) instanceof GradleDslExpressionMap) {
            ((GradleDslExpressionMap)parent).removeProperty(CONFIGURATION);
            this.myConfiguration = null;
        }
    }
}

