/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTreeDependencyModel
extends DependencyModel {
    private static final Logger LOG = Logger.getInstance(FileTreeDependencyModel.class);
    @NonNls
    private static final String FILE_TREE = "fileTree";
    @NonNls
    private static final String DIR = "dir";
    @NonNls
    private static final String INCLUDE = "include";
    @NonNls
    private static final String EXCLUDE = "exclude";
    @NotNull
    private final GradleDslMethodCall myDslElement;
    @NotNull
    private final GradleDslExpression myDir;
    @Nullable
    private final GradleDslElement myIncludeElement;
    @Nullable
    private final GradleDslElement myExcludeElement;

    public FileTreeDependencyModel(@NotNull GradleDslMethodCall dslElement, @NotNull GradleDslExpression dir, @Nullable GradleDslElement includeElement, @Nullable GradleDslElement excludeElement) {
        this.myDslElement = dslElement;
        this.myDir = dir;
        this.myIncludeElement = includeElement;
        this.myExcludeElement = excludeElement;
    }

    @Override
    @NotNull
    protected GradleDslElement getDslElement() {
        return this.myDslElement;
    }

    @NotNull
    public String dir() {
        String dir = this.myDir.getValue(String.class);
        assert (dir != null);
        return dir;
    }

    public void setDir(@NotNull String dir) {
        this.myDir.setValue(dir);
    }

    @NotNull
    public List<String> include() {
        return FileTreeDependencyModel.getStringValues(this.myIncludeElement);
    }

    @NotNull
    public List<String> exclude() {
        return FileTreeDependencyModel.getStringValues(this.myExcludeElement);
    }

    @NotNull
    private static List<String> getStringValues(@Nullable GradleDslElement expressionOrList) {
        String value;
        if (expressionOrList instanceof GradleDslExpressionList) {
            return ((GradleDslExpressionList)expressionOrList).getValues(String.class);
        }
        if (expressionOrList instanceof GradleDslExpression && (value = ((GradleDslExpression)expressionOrList).getValue(String.class)) != null) {
            return Collections.singletonList(value);
        }
        return Collections.emptyList();
    }

    public static Collection<? extends FileTreeDependencyModel> create(@NotNull GradleDslMethodCall methodCall) {
        ArrayList result = Lists.newArrayList();
        if (FILE_TREE.equals(methodCall.getName())) {
            List<GradleDslElement> arguments = methodCall.getArguments();
            for (GradleDslElement argument : arguments) {
                if (argument instanceof GradleDslExpression) {
                    result.add(new FileTreeDependencyModel(methodCall, (GradleDslExpression)argument, null, null));
                    continue;
                }
                if (!(argument instanceof GradleDslExpressionMap)) continue;
                GradleDslExpressionMap dslMap = (GradleDslExpressionMap)argument;
                GradleDslExpression dirElement = dslMap.getProperty(DIR, GradleDslExpression.class);
                if (dirElement == null) {
                    assert (methodCall.getPsiElement() != null);
                    String msg = String.format("'%1$s' is not a valid file tree dependency", methodCall.getPsiElement().getText());
                    LOG.warn(msg);
                    continue;
                }
                GradleDslElement includeElement = dslMap.getPropertyElement(INCLUDE);
                GradleDslElement excludeElement = dslMap.getPropertyElement(EXCLUDE);
                result.add(new FileTreeDependencyModel(methodCall, dirElement, includeElement, excludeElement));
            }
        }
        return result;
    }
}

