/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.model.android.AbstractFlavorTypeModel;
import com.android.tools.idea.gradle.dsl.parser.android.BuildTypeDslElement;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildTypeModel
extends AbstractFlavorTypeModel {
    @NonNls
    private static final String APPLICATION_ID_SUFFIX = "applicationIdSuffix";
    @NonNls
    private static final String BUILD_CONFIG_FIELD = "buildConfigField";
    @NonNls
    private static final String DEBUGGABLE = "debuggable";
    @NonNls
    private static final String EMBED_MICRO_APP = "embedMicroApp";
    @NonNls
    private static final String JNI_DEBUGGABLE = "jniDebuggable";
    @NonNls
    private static final String MINIFY_ENABLED = "minifyEnabled";
    @NonNls
    private static final String PSEUDO_LOCALES_ENABLED = "pseudoLocalesEnabled";
    @NonNls
    private static final String RENDERSCRIPT_DEBUGGABLE = "renderscriptDebuggable";
    @NonNls
    private static final String RENDERSCRIPT_OPTIM_LEVEL = "renderscriptOptimLevel";
    @NonNls
    private static final String SHRINK_RESOURCES = "shrinkResources";
    @NonNls
    private static final String TEST_COVERAGE_ENABLED = "testCoverageEnabled";
    @NonNls
    private static final String VERSION_NAME_SUFFIX = "versionNameSuffix";
    @NonNls
    private static final String ZIP_ALIGN_ENABLED = "zipAlignEnabled";

    public BuildTypeModel(@NotNull BuildTypeDslElement dslElement) {
        super(dslElement);
    }

    @Nullable
    public String applicationIdSuffix() {
        return this.myDslElement.getProperty(APPLICATION_ID_SUFFIX, String.class);
    }

    @NotNull
    public BuildTypeModel setApplicationIdSuffix(@NotNull String applicationIdSuffix) {
        this.myDslElement.setNewLiteral(APPLICATION_ID_SUFFIX, applicationIdSuffix);
        return this;
    }

    @NotNull
    public BuildTypeModel removeApplicationIdSuffix() {
        this.myDslElement.removeProperty(APPLICATION_ID_SUFFIX);
        return this;
    }

    @Nullable
    public List<BuildConfigField> buildConfigFields() {
        List<AbstractFlavorTypeModel.TypeNameValueElement> typeNameValueElements = this.getTypeNameValueElements(BUILD_CONFIG_FIELD);
        if (typeNameValueElements == null) {
            return null;
        }
        ArrayList buildConfigFields = Lists.newArrayListWithCapacity((int)typeNameValueElements.size());
        for (AbstractFlavorTypeModel.TypeNameValueElement typeNameValueElement : typeNameValueElements) {
            buildConfigFields.add(new BuildConfigField(typeNameValueElement.type(), typeNameValueElement.name(), typeNameValueElement.value()));
        }
        return buildConfigFields;
    }

    @NotNull
    public BuildTypeModel addBuildConfigField(@NotNull BuildConfigField buildConfigField) {
        return (BuildTypeModel)this.addTypeNameValueElement(buildConfigField);
    }

    @NotNull
    public BuildTypeModel removeBuildConfigField(@NotNull BuildConfigField buildConfigField) {
        return (BuildTypeModel)this.removeTypeNameValueElement(buildConfigField);
    }

    @NotNull
    public BuildTypeModel removeAllBuildConfigFields() {
        this.myDslElement.removeProperty(BUILD_CONFIG_FIELD);
        return this;
    }

    @NotNull
    public BuildTypeModel replaceBuildConfigField(@NotNull BuildConfigField oldBuildConfigField, @NotNull BuildConfigField newBuildConfigField) {
        return (BuildTypeModel)this.replaceTypeNameValueElement(oldBuildConfigField, newBuildConfigField);
    }

    @Nullable
    public Boolean debuggable() {
        return this.myDslElement.getProperty(DEBUGGABLE, Boolean.class);
    }

    @NotNull
    public BuildTypeModel setDebuggable(@NotNull Boolean debuggable) {
        this.myDslElement.setNewLiteral(DEBUGGABLE, debuggable);
        return this;
    }

    @NotNull
    public BuildTypeModel removeDebuggable() {
        this.myDslElement.removeProperty(DEBUGGABLE);
        return this;
    }

    @Nullable
    public Boolean embedMicroApp() {
        return this.myDslElement.getProperty(EMBED_MICRO_APP, Boolean.class);
    }

    @NotNull
    public BuildTypeModel setEmbedMicroApp(@NotNull Boolean embedMicroApp) {
        this.myDslElement.setNewLiteral(EMBED_MICRO_APP, embedMicroApp);
        return this;
    }

    @NotNull
    public BuildTypeModel removeEmbedMicroApp() {
        this.myDslElement.removeProperty(EMBED_MICRO_APP);
        return this;
    }

    @Nullable
    public Boolean jniDebuggable() {
        return this.myDslElement.getProperty(JNI_DEBUGGABLE, Boolean.class);
    }

    @NotNull
    public BuildTypeModel setJniDebuggable(@NotNull Boolean jniDebuggable) {
        this.myDslElement.setNewLiteral(JNI_DEBUGGABLE, jniDebuggable);
        return this;
    }

    @NotNull
    public BuildTypeModel removeJniDebuggable() {
        this.myDslElement.removeProperty(JNI_DEBUGGABLE);
        return this;
    }

    @Nullable
    public Boolean minifyEnabled() {
        return this.myDslElement.getProperty(MINIFY_ENABLED, Boolean.class);
    }

    @NotNull
    public BuildTypeModel setMinifyEnabled(@NotNull Boolean minifyEnabled) {
        this.myDslElement.setNewLiteral(MINIFY_ENABLED, minifyEnabled);
        return this;
    }

    @NotNull
    public BuildTypeModel removeMinifyEnabled() {
        this.myDslElement.removeProperty(MINIFY_ENABLED);
        return this;
    }

    @Nullable
    public Boolean pseudoLocalesEnabled() {
        return this.myDslElement.getProperty(PSEUDO_LOCALES_ENABLED, Boolean.class);
    }

    @NotNull
    public BuildTypeModel setPseudoLocalesEnabled(@NotNull Boolean pseudoLocalesEnabled) {
        this.myDslElement.setNewLiteral(PSEUDO_LOCALES_ENABLED, pseudoLocalesEnabled);
        return this;
    }

    @NotNull
    public BuildTypeModel removePseudoLocalesEnabled() {
        this.myDslElement.removeProperty(PSEUDO_LOCALES_ENABLED);
        return this;
    }

    @Nullable
    public Boolean renderscriptDebuggable() {
        return this.myDslElement.getProperty(RENDERSCRIPT_DEBUGGABLE, Boolean.class);
    }

    @NotNull
    public BuildTypeModel setRenderscriptDebuggable(@NotNull Boolean renderscriptDebuggable) {
        this.myDslElement.setNewLiteral(RENDERSCRIPT_DEBUGGABLE, renderscriptDebuggable);
        return this;
    }

    @NotNull
    public BuildTypeModel removeRenderscriptDebuggable() {
        this.myDslElement.removeProperty(RENDERSCRIPT_DEBUGGABLE);
        return this;
    }

    @Nullable
    public Integer renderscriptOptimLevel() {
        return this.myDslElement.getProperty(RENDERSCRIPT_OPTIM_LEVEL, Integer.class);
    }

    @NotNull
    public BuildTypeModel setRenderscriptOptimLevel(@NotNull Integer renderscriptOptimLevel) {
        this.myDslElement.setNewLiteral(RENDERSCRIPT_OPTIM_LEVEL, renderscriptOptimLevel);
        return this;
    }

    @NotNull
    public BuildTypeModel removeRenderscriptOptimLevel() {
        this.myDslElement.removeProperty(RENDERSCRIPT_OPTIM_LEVEL);
        return this;
    }

    @Nullable
    public Boolean shrinkResources() {
        return this.myDslElement.getProperty(SHRINK_RESOURCES, Boolean.class);
    }

    @NotNull
    public BuildTypeModel setShrinkResources(@NotNull Boolean shrinkResources) {
        this.myDslElement.setNewLiteral(SHRINK_RESOURCES, shrinkResources);
        return this;
    }

    @NotNull
    public BuildTypeModel removeShrinkResources() {
        this.myDslElement.removeProperty(SHRINK_RESOURCES);
        return this;
    }

    @Nullable
    public Boolean testCoverageEnabled() {
        return this.myDslElement.getProperty(TEST_COVERAGE_ENABLED, Boolean.class);
    }

    @NotNull
    public BuildTypeModel setTestCoverageEnabled(@NotNull Boolean testCoverageEnabled) {
        this.myDslElement.setNewLiteral(TEST_COVERAGE_ENABLED, testCoverageEnabled);
        return this;
    }

    @NotNull
    public BuildTypeModel removeTestCoverageEnabled() {
        this.myDslElement.removeProperty(TEST_COVERAGE_ENABLED);
        return this;
    }

    @Nullable
    public String versionNameSuffix() {
        return this.myDslElement.getProperty(VERSION_NAME_SUFFIX, String.class);
    }

    @NotNull
    public BuildTypeModel setVersionNameSuffix(@NotNull String versionNameSuffix) {
        this.myDslElement.setNewLiteral(VERSION_NAME_SUFFIX, versionNameSuffix);
        return this;
    }

    @NotNull
    public BuildTypeModel removeVersionNameSuffix() {
        this.myDslElement.removeProperty(VERSION_NAME_SUFFIX);
        return this;
    }

    @Nullable
    public Boolean zipAlignEnabled() {
        return this.myDslElement.getProperty(ZIP_ALIGN_ENABLED, Boolean.class);
    }

    @NotNull
    public BuildTypeModel setZipAlignEnabled(@NotNull Boolean zipAlignEnabled) {
        this.myDslElement.setNewLiteral(ZIP_ALIGN_ENABLED, zipAlignEnabled);
        return this;
    }

    @NotNull
    public BuildTypeModel removeZipAlignEnabled() {
        this.myDslElement.removeProperty(ZIP_ALIGN_ENABLED);
        return this;
    }

    @Override
    @NotNull
    public BuildTypeModel addConsumerProguardFile(@NotNull String consumerProguardFile) {
        return (BuildTypeModel)super.addConsumerProguardFile(consumerProguardFile);
    }

    @Override
    @NotNull
    public BuildTypeModel removeConsumerProguardFile(@NotNull String consumerProguardFile) {
        return (BuildTypeModel)super.removeConsumerProguardFile(consumerProguardFile);
    }

    @Override
    @NotNull
    public BuildTypeModel removeAllConsumerProguardFiles() {
        return (BuildTypeModel)super.removeAllConsumerProguardFiles();
    }

    @Override
    @NotNull
    public BuildTypeModel replaceConsumerProguardFile(@NotNull String oldConsumerProguardFile, @NotNull String newConsumerProguardFile) {
        return (BuildTypeModel)super.replaceConsumerProguardFile(oldConsumerProguardFile, newConsumerProguardFile);
    }

    @Override
    @NotNull
    public BuildTypeModel setManifestPlaceholder(@NotNull String name, @NotNull String value) {
        return (BuildTypeModel)super.setManifestPlaceholder(name, value);
    }

    @Override
    @NotNull
    public BuildTypeModel setManifestPlaceholder(@NotNull String name, int value) {
        return (BuildTypeModel)super.setManifestPlaceholder(name, value);
    }

    @Override
    @NotNull
    public BuildTypeModel setManifestPlaceholder(@NotNull String name, boolean value) {
        return (BuildTypeModel)super.setManifestPlaceholder(name, value);
    }

    @Override
    @NotNull
    public BuildTypeModel removeManifestPlaceholder(@NotNull String name) {
        return (BuildTypeModel)super.removeManifestPlaceholder(name);
    }

    @Override
    @NotNull
    public BuildTypeModel removeAllManifestPlaceholders() {
        return (BuildTypeModel)super.removeAllManifestPlaceholders();
    }

    @Override
    @NotNull
    public BuildTypeModel setMultiDexEnabled(boolean multiDexEnabled) {
        return (BuildTypeModel)super.setMultiDexEnabled(multiDexEnabled);
    }

    @Override
    @NotNull
    public BuildTypeModel removeMultiDexEnabled() {
        return (BuildTypeModel)super.removeMultiDexEnabled();
    }

    @Override
    @NotNull
    public BuildTypeModel addProguardFile(@NotNull String proguardFile) {
        return (BuildTypeModel)super.addProguardFile(proguardFile);
    }

    @Override
    @NotNull
    public BuildTypeModel removeProguardFile(@NotNull String proguardFile) {
        return (BuildTypeModel)super.removeProguardFile(proguardFile);
    }

    @Override
    @NotNull
    public BuildTypeModel removeAllProguardFiles() {
        return (BuildTypeModel)super.removeAllProguardFiles();
    }

    @Override
    @NotNull
    public BuildTypeModel replaceProguardFile(@NotNull String oldProguardFile, @NotNull String newProguardFile) {
        return (BuildTypeModel)super.replaceProguardFile(oldProguardFile, newProguardFile);
    }

    @Override
    @NotNull
    public BuildTypeModel addResValue(@NotNull AbstractFlavorTypeModel.ResValue resValue) {
        return (BuildTypeModel)super.addResValue(resValue);
    }

    @Override
    @NotNull
    public BuildTypeModel removeResValue(@NotNull AbstractFlavorTypeModel.ResValue resValue) {
        return (BuildTypeModel)super.removeResValue(resValue);
    }

    @Override
    @NotNull
    public BuildTypeModel removeAllResValues() {
        return (BuildTypeModel)super.removeAllResValues();
    }

    @Override
    @NotNull
    public BuildTypeModel replaceResValue(@NotNull AbstractFlavorTypeModel.ResValue oldResValue, @NotNull AbstractFlavorTypeModel.ResValue newResValue) {
        return (BuildTypeModel)super.replaceResValue(oldResValue, newResValue);
    }

    @Override
    @NotNull
    public BuildTypeModel setUseJack(boolean useJack) {
        return (BuildTypeModel)super.setUseJack(useJack);
    }

    @Override
    @NotNull
    public BuildTypeModel removeUseJack() {
        return (BuildTypeModel)super.removeUseJack();
    }

    public static final class BuildConfigField
    extends AbstractFlavorTypeModel.TypeNameValueElement {
        public BuildConfigField(@NotNull String type, @NotNull String name, @NotNull String value) {
            super(BuildTypeModel.BUILD_CONFIG_FIELD, type, name, value);
        }
    }
}

