/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.android.BuildTypeModel;
import com.android.tools.idea.gradle.dsl.model.android.CompileOptionsModel;
import com.android.tools.idea.gradle.dsl.model.android.ProductFlavorModel;
import com.android.tools.idea.gradle.dsl.model.android.external.ExternalNativeBuildModel;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.BuildTypeDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.BuildTypesDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.CompileOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.ProductFlavorDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.ProductFlavorsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.external.ExternalNativeBuildDslElement;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidModel
extends GradleDslBlockModel {
    @NonNls
    private static final String BUILD_TOOLS_VERSION = "buildToolsVersion";
    @NonNls
    private static final String COMPILE_SDK_VERSION = "compileSdkVersion";
    @NonNls
    private static final String DEFAULT_CONFIG = "defaultConfig";
    @NonNls
    private static final String DEFAULT_PUBLISH_CONFIG = "defaultPublishConfig";
    @NonNls
    private static final String FLAVOR_DIMENSIONS = "flavorDimensions";
    @NonNls
    private static final String GENERATE_PURE_SPLITS = "generatePureSplits";
    @NonNls
    private static final String PUBLISH_NON_DEFAULT = "publishNonDefault";
    @NonNls
    private static final String RESOURCE_PREFIX = "resourcePrefix";

    public AndroidModel(@NotNull AndroidDslElement dslElement) {
        super(dslElement);
    }

    @Nullable
    public String buildToolsVersion() {
        Integer intValue = this.myDslElement.getProperty(BUILD_TOOLS_VERSION, Integer.class);
        return intValue != null ? intValue.toString() : this.myDslElement.getProperty(BUILD_TOOLS_VERSION, String.class);
    }

    @NotNull
    public AndroidModel setBuildToolsVersion(int buildToolsVersion) {
        this.myDslElement.setNewLiteral(BUILD_TOOLS_VERSION, buildToolsVersion);
        return this;
    }

    @NotNull
    public AndroidModel setBuildToolsVersion(@NotNull String buildToolsVersion) {
        this.myDslElement.setNewLiteral(BUILD_TOOLS_VERSION, buildToolsVersion);
        return this;
    }

    @NotNull
    public AndroidModel removeBuildToolsVersion() {
        this.myDslElement.removeProperty(BUILD_TOOLS_VERSION);
        return this;
    }

    @NotNull
    public Collection<BuildTypeModel> buildTypes() {
        BuildTypesDslElement buildTypes = this.myDslElement.getProperty("buildTypes", BuildTypesDslElement.class);
        return buildTypes == null ? ImmutableList.of() : buildTypes.get();
    }

    @NotNull
    public AndroidModel addBuildType(@NotNull String buildType) {
        BuildTypeDslElement buildTypeElement;
        BuildTypesDslElement buildTypes = this.myDslElement.getProperty("buildTypes", BuildTypesDslElement.class);
        if (buildTypes == null) {
            buildTypes = new BuildTypesDslElement(this.myDslElement);
            this.myDslElement.setNewElement("buildTypes", buildTypes);
        }
        if ((buildTypeElement = buildTypes.getProperty(buildType, BuildTypeDslElement.class)) == null) {
            buildTypeElement = new BuildTypeDslElement(buildTypes, buildType);
            buildTypes.setNewElement(buildType, buildTypeElement);
        }
        return this;
    }

    @NotNull
    public AndroidModel removeBuildType(@NotNull String buildType) {
        BuildTypesDslElement buildTypes = this.myDslElement.getProperty("buildTypes", BuildTypesDslElement.class);
        if (buildTypes != null) {
            buildTypes.removeProperty(buildType);
        }
        return this;
    }

    @NotNull
    public CompileOptionsModel compileOptions() {
        CompileOptionsDslElement element = this.myDslElement.getProperty("compileOptions", CompileOptionsDslElement.class);
        if (element == null) {
            element = new CompileOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("compileOptions", element);
        }
        return new CompileOptionsModel(element, false);
    }

    @Nullable
    public String compileSdkVersion() {
        Integer intValue = this.myDslElement.getProperty(COMPILE_SDK_VERSION, Integer.class);
        return intValue != null ? intValue.toString() : this.myDslElement.getProperty(COMPILE_SDK_VERSION, String.class);
    }

    @NotNull
    public AndroidModel setCompileSdkVersion(int compileSdkVersion) {
        this.myDslElement.setNewLiteral(COMPILE_SDK_VERSION, compileSdkVersion);
        return this;
    }

    @NotNull
    public AndroidModel setCompileSdkVersion(@NotNull String compileSdkVersion) {
        this.myDslElement.setNewLiteral(COMPILE_SDK_VERSION, compileSdkVersion);
        return this;
    }

    @NotNull
    public AndroidModel removeCompileSdkVersion() {
        this.myDslElement.removeProperty(COMPILE_SDK_VERSION);
        return this;
    }

    @NotNull
    public ProductFlavorModel defaultConfig() {
        ProductFlavorDslElement defaultConfigElement = this.myDslElement.getProperty(DEFAULT_CONFIG, ProductFlavorDslElement.class);
        if (defaultConfigElement == null) {
            defaultConfigElement = new ProductFlavorDslElement(this.myDslElement, DEFAULT_CONFIG);
            this.myDslElement.setNewElement(DEFAULT_CONFIG, defaultConfigElement);
        }
        return new ProductFlavorModel(defaultConfigElement);
    }

    @Nullable
    public String defaultPublishConfig() {
        return this.myDslElement.getProperty(DEFAULT_PUBLISH_CONFIG, String.class);
    }

    @NotNull
    public AndroidModel setDefaultPublishConfig(@NotNull String defaultPublishConfig) {
        this.myDslElement.setNewLiteral(DEFAULT_PUBLISH_CONFIG, defaultPublishConfig);
        return this;
    }

    @NotNull
    public AndroidModel removeDefaultPublishConfig() {
        this.myDslElement.removeProperty(DEFAULT_PUBLISH_CONFIG);
        return this;
    }

    @NotNull
    public ExternalNativeBuildModel externalNativeBuild() {
        ExternalNativeBuildDslElement externalNativeBuildDslElement = this.myDslElement.getProperty("externalNativeBuild", ExternalNativeBuildDslElement.class);
        if (externalNativeBuildDslElement == null) {
            externalNativeBuildDslElement = new ExternalNativeBuildDslElement(this.myDslElement);
            this.myDslElement.setNewElement("externalNativeBuild", externalNativeBuildDslElement);
        }
        return new ExternalNativeBuildModel(externalNativeBuildDslElement);
    }

    @Nullable
    public List<String> flavorDimensions() {
        return this.myDslElement.getListProperty(FLAVOR_DIMENSIONS, String.class);
    }

    @NotNull
    public AndroidModel addFlavorDimension(@NotNull String flavorDimension) {
        this.myDslElement.addToNewLiteralList(FLAVOR_DIMENSIONS, flavorDimension);
        return this;
    }

    @NotNull
    public AndroidModel removeFlavorDimension(@NotNull String flavorDimension) {
        this.myDslElement.removeFromExpressionList(FLAVOR_DIMENSIONS, flavorDimension);
        return this;
    }

    @NotNull
    public AndroidModel removeAllFlavorDimensions() {
        this.myDslElement.removeProperty(FLAVOR_DIMENSIONS);
        return this;
    }

    @NotNull
    public AndroidModel replaceFlavorDimension(@NotNull String oldFlavorDimension, @NotNull String newFlavorDimension) {
        this.myDslElement.replaceInExpressionList(FLAVOR_DIMENSIONS, oldFlavorDimension, newFlavorDimension);
        return this;
    }

    @Nullable
    public Boolean generatePureSplits() {
        return this.myDslElement.getProperty(GENERATE_PURE_SPLITS, Boolean.class);
    }

    @NotNull
    public AndroidModel setGeneratePureSplits(boolean generatePureSplits) {
        this.myDslElement.setNewLiteral(GENERATE_PURE_SPLITS, generatePureSplits);
        return this;
    }

    @NotNull
    public AndroidModel removeGeneratePureSplits() {
        this.myDslElement.removeProperty(GENERATE_PURE_SPLITS);
        return this;
    }

    @NotNull
    public Collection<ProductFlavorModel> productFlavors() {
        ProductFlavorsDslElement productFlavors = this.myDslElement.getProperty("productFlavors", ProductFlavorsDslElement.class);
        return productFlavors == null ? ImmutableList.of() : productFlavors.get();
    }

    @NotNull
    public AndroidModel addProductFlavor(@NotNull String flavor) {
        ProductFlavorDslElement flavorElement;
        ProductFlavorsDslElement productFlavors = this.myDslElement.getProperty("productFlavors", ProductFlavorsDslElement.class);
        if (productFlavors == null) {
            productFlavors = new ProductFlavorsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("productFlavors", productFlavors);
        }
        if ((flavorElement = productFlavors.getProperty(flavor, ProductFlavorDslElement.class)) == null) {
            flavorElement = new ProductFlavorDslElement(productFlavors, flavor);
            productFlavors.setNewElement(flavor, flavorElement);
        }
        return this;
    }

    @NotNull
    public AndroidModel removeProductFlavor(@NotNull String flavor) {
        ProductFlavorsDslElement productFlavors = this.myDslElement.getProperty("productFlavors", ProductFlavorsDslElement.class);
        if (productFlavors != null) {
            productFlavors.removeProperty(flavor);
        }
        return this;
    }

    @Nullable
    public Boolean publishNonDefault() {
        return this.myDslElement.getProperty(PUBLISH_NON_DEFAULT, Boolean.class);
    }

    @NotNull
    public AndroidModel setPublishNonDefault(boolean publishNonDefault) {
        this.myDslElement.setNewLiteral(PUBLISH_NON_DEFAULT, publishNonDefault);
        return this;
    }

    @NotNull
    public AndroidModel removePublishNonDefault() {
        this.myDslElement.removeProperty(PUBLISH_NON_DEFAULT);
        return this;
    }

    @Nullable
    public String resourcePrefix() {
        return this.myDslElement.getProperty(RESOURCE_PREFIX, String.class);
    }

    @NotNull
    public AndroidModel setResourcePrefix(@NotNull String resourcePrefix) {
        this.myDslElement.setNewLiteral(RESOURCE_PREFIX, resourcePrefix);
        return this;
    }

    @NotNull
    public AndroidModel removeResourcePrefix() {
        this.myDslElement.removeProperty(RESOURCE_PREFIX);
        return this;
    }
}

