/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.parser.android.AbstractFlavorTypeDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFlavorTypeModel
extends GradleDslBlockModel {
    @NonNls
    private static final String CONSUMER_PROGUARD_FILES = "consumerProguardFiles";
    @NonNls
    private static final String MANIFEST_PLACEHOLDERS = "manifestPlaceholders";
    @NonNls
    private static final String MULTI_DEX_ENABLED = "multiDexEnabled";
    @NonNls
    private static final String PROGUARD_FILES = "proguardFiles";
    @NonNls
    private static final String RES_VALUE = "resValue";
    @NonNls
    private static final String USE_JACK = "useJack";

    public AbstractFlavorTypeModel(@NotNull AbstractFlavorTypeDslElement dslElement) {
        super(dslElement);
    }

    @NotNull
    public String name() {
        return this.myDslElement.getName();
    }

    @Nullable
    public List<String> consumerProguardFiles() {
        return this.myDslElement.getListProperty(CONSUMER_PROGUARD_FILES, String.class);
    }

    @NotNull
    public AbstractFlavorTypeModel addConsumerProguardFile(@NotNull String consumerProguardFile) {
        this.myDslElement.addToNewLiteralList(CONSUMER_PROGUARD_FILES, consumerProguardFile);
        return this;
    }

    @NotNull
    public AbstractFlavorTypeModel removeConsumerProguardFile(@NotNull String consumerProguardFile) {
        this.myDslElement.removeFromExpressionList(CONSUMER_PROGUARD_FILES, consumerProguardFile);
        return this;
    }

    @NotNull
    public AbstractFlavorTypeModel removeAllConsumerProguardFiles() {
        this.myDslElement.removeProperty(CONSUMER_PROGUARD_FILES);
        return this;
    }

    @NotNull
    public AbstractFlavorTypeModel replaceConsumerProguardFile(@NotNull String oldConsumerProguardFile, @NotNull String newConsumerProguardFile) {
        this.myDslElement.replaceInExpressionList(CONSUMER_PROGUARD_FILES, oldConsumerProguardFile, newConsumerProguardFile);
        return this;
    }

    @Nullable
    public Map<String, Object> manifestPlaceholders() {
        return this.myDslElement.getMapProperty(MANIFEST_PLACEHOLDERS, Object.class);
    }

    @NotNull
    public AbstractFlavorTypeModel setManifestPlaceholder(@NotNull String name, @NotNull String value) {
        this.myDslElement.setInNewLiteralMap(MANIFEST_PLACEHOLDERS, name, value);
        return this;
    }

    @NotNull
    public AbstractFlavorTypeModel setManifestPlaceholder(@NotNull String name, int value) {
        this.myDslElement.setInNewLiteralMap(MANIFEST_PLACEHOLDERS, name, value);
        return this;
    }

    @NotNull
    public AbstractFlavorTypeModel setManifestPlaceholder(@NotNull String name, boolean value) {
        this.myDslElement.setInNewLiteralMap(MANIFEST_PLACEHOLDERS, name, value);
        return this;
    }

    @NotNull
    public AbstractFlavorTypeModel removeManifestPlaceholder(@NotNull String name) {
        this.myDslElement.removeFromExpressionMap(MANIFEST_PLACEHOLDERS, name);
        return this;
    }

    @NotNull
    public AbstractFlavorTypeModel removeAllManifestPlaceholders() {
        this.myDslElement.removeProperty(MANIFEST_PLACEHOLDERS);
        return this;
    }

    @Nullable
    public Boolean multiDexEnabled() {
        return this.myDslElement.getProperty(MULTI_DEX_ENABLED, Boolean.class);
    }

    @NotNull
    public AbstractFlavorTypeModel setMultiDexEnabled(boolean multiDexEnabled) {
        this.myDslElement.setNewLiteral(MULTI_DEX_ENABLED, multiDexEnabled);
        return this;
    }

    @NotNull
    public AbstractFlavorTypeModel removeMultiDexEnabled() {
        this.myDslElement.removeProperty(MULTI_DEX_ENABLED);
        return this;
    }

    @Nullable
    public List<String> proguardFiles() {
        return this.myDslElement.getListProperty(PROGUARD_FILES, String.class);
    }

    @NotNull
    public AbstractFlavorTypeModel addProguardFile(@NotNull String proguardFile) {
        this.myDslElement.addToNewLiteralList(PROGUARD_FILES, proguardFile);
        return this;
    }

    @NotNull
    public AbstractFlavorTypeModel removeProguardFile(@NotNull String proguardFile) {
        this.myDslElement.removeFromExpressionList(PROGUARD_FILES, proguardFile);
        return this;
    }

    @NotNull
    public AbstractFlavorTypeModel removeAllProguardFiles() {
        this.myDslElement.removeProperty(PROGUARD_FILES);
        return this;
    }

    @NotNull
    public AbstractFlavorTypeModel replaceProguardFile(@NotNull String oldProguardFile, @NotNull String newProguardFile) {
        this.myDslElement.replaceInExpressionList(PROGUARD_FILES, oldProguardFile, newProguardFile);
        return this;
    }

    @Nullable
    protected List<TypeNameValueElement> getTypeNameValueElements(@NotNull String elementName) {
        GradleDslElementList typeNameValueElements = this.myDslElement.getProperty(elementName, GradleDslElementList.class);
        if (typeNameValueElements == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (GradleDslElement typeNameValue : typeNameValueElements.getElements()) {
            GradleDslExpressionList listElement;
            List<String> values;
            if (!(typeNameValue instanceof GradleDslExpressionList) || (values = (listElement = (GradleDslExpressionList)typeNameValue).getValues(String.class)).size() != 3) continue;
            result.add(new TypeNameValueElement(elementName, values.get(0), values.get(1), values.get(2)));
        }
        return result;
    }

    @Nullable
    public List<ResValue> resValues() {
        List<TypeNameValueElement> typeNameValueElements = this.getTypeNameValueElements(RES_VALUE);
        if (typeNameValueElements == null) {
            return null;
        }
        ArrayList resValues = Lists.newArrayListWithCapacity((int)typeNameValueElements.size());
        for (TypeNameValueElement typeNameValueElement : typeNameValueElements) {
            resValues.add(new ResValue(typeNameValueElement.type(), typeNameValueElement.name(), typeNameValueElement.value()));
        }
        return resValues;
    }

    @NotNull
    protected AbstractFlavorTypeModel addTypeNameValueElement(@NotNull TypeNameValueElement typeNameValueElement) {
        GradleDslElementList elementList = this.myDslElement.getProperty(typeNameValueElement.myElementName, GradleDslElementList.class);
        if (elementList == null) {
            elementList = new GradleDslElementList(this.myDslElement, typeNameValueElement.myElementName);
            this.myDslElement.setNewElement(typeNameValueElement.myElementName, elementList);
        }
        elementList.addNewElement(typeNameValueElement.toLiteralListElement(this.myDslElement));
        return this;
    }

    @NotNull
    public AbstractFlavorTypeModel addResValue(@NotNull ResValue resValue) {
        return this.addTypeNameValueElement(resValue);
    }

    @NotNull
    protected AbstractFlavorTypeModel removeTypeNameValueElement(@NotNull TypeNameValueElement typeNameValueElement) {
        GradleDslElementList elementList = this.myDslElement.getProperty(typeNameValueElement.myElementName, GradleDslElementList.class);
        if (elementList != null) {
            for (GradleDslExpressionList element : elementList.getElements(GradleDslExpressionList.class)) {
                List<String> values = element.getValues(String.class);
                if (values.size() != 3 || !typeNameValueElement.type().equals(values.get(0)) || !typeNameValueElement.name().equals(values.get(1)) || !typeNameValueElement.value().equals(values.get(2))) continue;
                elementList.removeElement(element);
            }
        }
        return this;
    }

    @NotNull
    public AbstractFlavorTypeModel removeResValue(@NotNull ResValue resValue) {
        return this.removeTypeNameValueElement(resValue);
    }

    @NotNull
    public AbstractFlavorTypeModel removeAllResValues() {
        this.myDslElement.removeProperty(RES_VALUE);
        return this;
    }

    @NotNull
    protected AbstractFlavorTypeModel replaceTypeNameValueElement(@NotNull TypeNameValueElement oldElement, @NotNull TypeNameValueElement newElement) {
        GradleDslElementList elementList;
        if (oldElement.myElementName.equals(newElement.myElementName) && (elementList = this.myDslElement.getProperty(oldElement.myElementName, GradleDslElementList.class)) != null) {
            for (GradleDslExpressionList element : elementList.getElements(GradleDslExpressionList.class)) {
                List<GradleDslExpression> gradleDslLiterals = element.getExpressions();
                if (gradleDslLiterals.size() != 3 || !oldElement.type().equals(gradleDslLiterals.get(0).getValue()) || !oldElement.name().equals(gradleDslLiterals.get(1).getValue()) || !oldElement.value().equals(gradleDslLiterals.get(2).getValue())) continue;
                gradleDslLiterals.get(0).setValue(newElement.type());
                gradleDslLiterals.get(1).setValue(newElement.name());
                gradleDslLiterals.get(2).setValue(newElement.value());
            }
        }
        return this;
    }

    @NotNull
    public AbstractFlavorTypeModel replaceResValue(@NotNull ResValue oldResValue, @NotNull ResValue newResValue) {
        return this.replaceTypeNameValueElement(oldResValue, newResValue);
    }

    @Nullable
    public Boolean useJack() {
        return this.myDslElement.getProperty(USE_JACK, Boolean.class);
    }

    @NotNull
    public AbstractFlavorTypeModel setUseJack(boolean useJack) {
        this.myDslElement.setNewLiteral(USE_JACK, useJack);
        return this;
    }

    @NotNull
    public AbstractFlavorTypeModel removeUseJack() {
        this.myDslElement.removeProperty(USE_JACK);
        return this;
    }

    public static final class ResValue
    extends TypeNameValueElement {
        public ResValue(@NotNull String type, @NotNull String name, @NotNull String value) {
            super(AbstractFlavorTypeModel.RES_VALUE, type, name, value);
        }
    }

    public static class TypeNameValueElement {
        @NotNull
        private final String myElementName;
        @NotNull
        private final String myType;
        @NotNull
        private final String myName;
        @NotNull
        private final String myValue;

        public TypeNameValueElement(@NotNull String elementName, @NotNull String type, @NotNull String name, @NotNull String value) {
            this.myElementName = elementName;
            this.myType = type;
            this.myName = name;
            this.myValue = value;
        }

        @NotNull
        public String type() {
            return this.myType;
        }

        @NotNull
        public String name() {
            return this.myName;
        }

        @NotNull
        public String value() {
            return this.myValue;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.myType, this.myName, this.myValue});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TypeNameValueElement)) {
                return false;
            }
            TypeNameValueElement other = (TypeNameValueElement)o;
            return this.myElementName.equals(other.myElementName) && this.myType.equals(other.myType) && this.myName.equals(other.myName) && this.myValue.equals(other.myValue);
        }

        public String toString() {
            return String.format("Type: %1$s, Name: %2$s, Value: %3$s", this.myType, this.myName, this.myValue);
        }

        @NotNull
        protected GradleDslExpressionList toLiteralListElement(@NotNull GradleDslElement parent) {
            GradleDslLiteral typeElement = new GradleDslLiteral(parent, this.myElementName);
            typeElement.setValue(this.myType);
            GradleDslLiteral nameElement = new GradleDslLiteral(parent, this.myElementName);
            nameElement.setValue(this.myName);
            GradleDslLiteral valueElement = new GradleDslLiteral(parent, this.myElementName);
            valueElement.setValue(this.myValue);
            GradleDslExpressionList gradleDslExpressionList = new GradleDslExpressionList(parent, this.myElementName);
            gradleDslExpressionList.addNewExpression(typeElement);
            gradleDslExpressionList.addNewExpression(nameElement);
            gradleDslExpressionList.addNewExpression(valueElement);
            return gradleDslExpressionList;
        }
    }
}

