/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.GradleFileModel;
import com.android.tools.idea.gradle.dsl.parser.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSettingsModel
extends GradleFileModel {
    private static final String INCLUDE = "include";

    @Nullable
    public static GradleSettingsModel get(@NotNull Project project) {
        VirtualFile file = GradleUtil.getGradleSettingsFile(Projects.getBaseDirPath(project));
        return file != null ? GradleSettingsModel.parseBuildFile(file, project, "settings") : null;
    }

    @NotNull
    public static GradleSettingsModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        GradleSettingsDslFile settingsFile = new GradleSettingsDslFile(file, project, moduleName);
        settingsFile.parse();
        return new GradleSettingsModel(settingsFile);
    }

    private GradleSettingsModel(@NotNull GradleSettingsDslFile parsedModel) {
        super(parsedModel);
    }

    @NotNull
    public List<String> modulePaths() {
        ArrayList result = Lists.newArrayList();
        result.add(":");
        List<String> includePaths = this.myGradleDslFile.getListProperty(INCLUDE, String.class);
        if (includePaths == null) {
            return result;
        }
        for (String includePath : includePaths) {
            result.add(GradleSettingsModel.standardiseModulePath(includePath));
        }
        return result;
    }

    @NotNull
    public GradleSettingsModel addModulePath(@NotNull String modulePath) {
        modulePath = GradleSettingsModel.standardiseModulePath(modulePath);
        this.myGradleDslFile.addToNewLiteralList(INCLUDE, modulePath);
        return this;
    }

    @NotNull
    public GradleSettingsModel removeModulePath(@NotNull String modulePath) {
        if (!modulePath.startsWith(":")) {
            this.myGradleDslFile.removeFromExpressionList(INCLUDE, ":" + modulePath);
        }
        this.myGradleDslFile.removeFromExpressionList(INCLUDE, modulePath);
        return this;
    }

    @NotNull
    public GradleSettingsModel replaceModulePath(@NotNull String oldModulePath, @NotNull String newModulePath) {
        if (!newModulePath.startsWith(":")) {
            newModulePath = ":" + newModulePath;
        }
        if (!oldModulePath.startsWith(":")) {
            this.myGradleDslFile.replaceInExpressionList(INCLUDE, ":" + oldModulePath, newModulePath);
        }
        this.myGradleDslFile.replaceInExpressionList(INCLUDE, oldModulePath, newModulePath);
        return this;
    }

    @Nullable
    public File moduleDirectory(String modulePath) {
        File parentDir;
        File projectDir;
        modulePath = GradleSettingsModel.standardiseModulePath(modulePath);
        if (!this.modulePaths().contains(modulePath)) {
            return null;
        }
        File rootDirPath = Projects.getBaseDirPath(this.myGradleDslFile.getProject());
        if (modulePath.equals(":")) {
            return rootDirPath;
        }
        String projectKey = "project('" + modulePath + "')";
        ProjectPropertiesDslElement projectProperties = this.myGradleDslFile.getProperty(projectKey, ProjectPropertiesDslElement.class);
        if (projectProperties != null && (projectDir = projectProperties.projectDir()) != null) {
            return projectDir;
        }
        if (modulePath.lastIndexOf(58) == 0) {
            parentDir = rootDirPath;
        } else {
            String parentModule = this.parentModule(modulePath);
            if (parentModule == null) {
                return null;
            }
            parentDir = this.moduleDirectory(parentModule);
        }
        String moduleName = modulePath.substring(modulePath.lastIndexOf(58) + 1);
        return new File(parentDir, moduleName);
    }

    @Nullable
    public String moduleWithDirectory(@NotNull File moduleDir) {
        for (String modulePath : this.modulePaths()) {
            if (!FileUtil.filesEqual((File)moduleDir, (File)this.moduleDirectory(modulePath))) continue;
            return modulePath;
        }
        return null;
    }

    @Nullable
    public GradleBuildModel moduleModel(@NotNull String modulePath) {
        File buildFilePath = this.buildFile(modulePath);
        if (buildFilePath == null) {
            return null;
        }
        VirtualFile buildFile = VfsUtil.findFileByIoFile((File)buildFilePath, (boolean)true);
        if (buildFile == null) {
            return null;
        }
        return GradleBuildModel.parseBuildFile(buildFile, this.myGradleDslFile.getProject(), modulePath.substring(modulePath.lastIndexOf(":") + 1));
    }

    @Nullable
    public String parentModule(@NotNull String modulePath) {
        String parentModulePath;
        modulePath = GradleSettingsModel.standardiseModulePath(modulePath);
        List<String> allModulePaths = this.modulePaths();
        if (!allModulePaths.contains(modulePath)) {
            return null;
        }
        if (modulePath.equals(":")) {
            return null;
        }
        int lastPathElementIndex = modulePath.lastIndexOf(58);
        String string = parentModulePath = lastPathElementIndex == 0 ? ":" : modulePath.substring(0, lastPathElementIndex);
        if (allModulePaths.contains(parentModulePath)) {
            return parentModulePath;
        }
        return null;
    }

    @Nullable
    public GradleBuildModel getParentModuleModel(@NotNull String modulePath) {
        String parentModule = this.parentModule(modulePath);
        if (parentModule == null) {
            return null;
        }
        return this.moduleModel(parentModule);
    }

    @Nullable
    public File buildFile(@NotNull String modulePath) {
        File moduleDirectory = this.moduleDirectory(modulePath);
        if (moduleDirectory == null) {
            return null;
        }
        String buildFileName = null;
        String projectKey = "project('" + modulePath + "')";
        ProjectPropertiesDslElement projectProperties = this.myGradleDslFile.getProperty(projectKey, ProjectPropertiesDslElement.class);
        if (projectProperties != null) {
            buildFileName = projectProperties.buildFileName();
        }
        if (buildFileName == null) {
            buildFileName = "build.gradle";
        }
        return new File(moduleDirectory, buildFileName);
    }

    private static String standardiseModulePath(@NotNull String modulePath) {
        return modulePath.startsWith(":") ? modulePath : ":" + modulePath;
    }

    private static class GradleSettingsDslFile
    extends GradleDslFile {
        private GradleSettingsDslFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
            super(file, project, moduleName);
        }

        @Override
        public void addParsedElement(@NotNull String property, @NotNull GradleDslElement element) {
            if (property.equals(GradleSettingsModel.INCLUDE)) {
                this.addToParsedExpressionList(property, element);
                return;
            }
            super.addParsedElement(property, element);
        }
    }
}

