/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.java;

import com.android.tools.idea.gradle.JavaProject;
import com.android.tools.idea.gradle.customizer.AbstractContentRootModuleCustomizer;
import com.android.tools.idea.gradle.model.java.JavaModuleContentRoot;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Lists;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ContentRootModuleCustomizer
extends AbstractContentRootModuleCustomizer<JavaProject> {
    @Override
    @NotNull
    protected Collection<ContentEntry> findOrCreateContentEntries(@NotNull ModifiableRootModel moduleModel, @NotNull JavaProject javaProject) {
        ArrayList allEntries = Lists.newArrayList();
        for (JavaModuleContentRoot contentRoot : javaProject.getContentRoots()) {
            File rootDirPath = contentRoot.getRootDirPath();
            ContentEntry contentEntry = moduleModel.addContentEntry(FilePaths.pathToIdeaUrl(rootDirPath));
            allEntries.add(contentEntry);
        }
        return allEntries;
    }

    @Override
    protected void setUpContentEntries(@NotNull ModifiableRootModel ideaModuleModel, @NotNull Collection<ContentEntry> contentEntries, @NotNull JavaProject javaProject, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        boolean isTopLevelJavaModule = Projects.isGradleProjectModule(ideaModuleModel.getModule());
        File buildFolderPath = javaProject.getBuildFolderPath();
        boolean buildFolderUnexcluded = buildFolderPath == null;
        for (JavaModuleContentRoot contentRoot : javaProject.getContentRoots()) {
            if (contentRoot == null) continue;
            this.addSourceFolders(contentEntries, contentRoot.getSourceDirPaths(), (JpsModuleSourceRootType)JavaSourceRootType.SOURCE, orphans, false);
            this.addSourceFolders(contentEntries, contentRoot.getGenSourceDirPaths(), (JpsModuleSourceRootType)JavaSourceRootType.SOURCE, orphans, true);
            this.addSourceFolders(contentEntries, contentRoot.getResourceDirPaths(), (JpsModuleSourceRootType)JavaResourceRootType.RESOURCE, orphans, false);
            this.addSourceFolders(contentEntries, contentRoot.getTestDirPaths(), (JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE, orphans, false);
            this.addSourceFolders(contentEntries, contentRoot.getGenTestDirPaths(), (JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE, orphans, true);
            this.addSourceFolders(contentEntries, contentRoot.getTestResourceDirPaths(), (JpsModuleSourceRootType)JavaResourceRootType.TEST_RESOURCE, orphans, false);
            for (File excluded : contentRoot.getExcludeDirPaths()) {
                ContentEntry contentEntry = FilePaths.findParentContentEntry(excluded, contentEntries);
                if (contentEntry == null) continue;
                if (isTopLevelJavaModule && !buildFolderUnexcluded && FileUtil.filesEqual((File)excluded, (File)buildFolderPath)) {
                    buildFolderUnexcluded = true;
                    continue;
                }
                this.addExcludedFolder(contentEntry, excluded);
            }
        }
    }

    private void addSourceFolders(@NotNull Collection<ContentEntry> contentEntries, @NotNull Collection<File> sourceDirPaths, @NotNull JpsModuleSourceRootType type, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans, boolean generated) {
        for (File path : sourceDirPaths) {
            this.addSourceFolder(contentEntries, path, type, generated, orphans);
        }
    }
}

