/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.dependency;

import com.android.tools.idea.gradle.customizer.dependency.Dependency;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LibraryDependency
extends Dependency {
    @NotNull
    private final Map<PathType, Collection<String>> myPathsByType = Maps.newEnumMap(PathType.class);
    private String myName;

    @VisibleForTesting
    public LibraryDependency(@NotNull File binaryPath, @NotNull DependencyScope scope) {
        this(FileUtil.getNameWithoutExtension((File)binaryPath), scope);
        this.addPath(PathType.BINARY, binaryPath);
    }

    LibraryDependency(@NotNull String name, @NotNull DependencyScope scope) {
        super(scope);
        this.setName(name);
    }

    void addPath(@NotNull PathType type, @NotNull File path) {
        HashSet paths = this.myPathsByType.get((Object)type);
        if (paths == null) {
            paths = Sets.newHashSet();
            this.myPathsByType.put(type, paths);
        }
        paths.add(path.getPath());
    }

    @NotNull
    public Collection<String> getPaths(@NotNull PathType type) {
        Collection<String> paths = this.myPathsByType.get((Object)type);
        return paths == null ? Collections.emptyList() : paths;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    void setName(@NotNull String name) {
        this.myName = name;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name='" + this.myName + '\'' + ", scope=" + this.getScope() + ", pathsByType=" + this.myPathsByType + "]";
    }

    public static enum PathType {
        BINARY,
        SOURCE,
        DOC;

    }
}

