/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.dependency;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencySetupErrors {
    @NotNull
    private final Map<String, MissingModule> myMissingModules = Maps.newHashMap();
    @NotNull
    private final Map<String, MissingModule> myMissingModulesWithBackupLibraries = Maps.newHashMap();
    @NotNull
    private final Set<String> myDependentsOnModulesWithoutName = Sets.newHashSet();
    @NotNull
    private final Set<String> myDependentsOnLibrariesWithoutBinaryPath = Sets.newHashSet();
    @NotNull
    private final Set<InvalidModuleDependency> myInvalidModuleDependencies = Sets.newHashSet();

    public void addMissingModule(@NotNull String dependencyName, @NotNull String dependentName, @Nullable String backupLibraryName) {
        Map<String, MissingModule> mapping = StringUtil.isNotEmpty((String)backupLibraryName) ? this.myMissingModulesWithBackupLibraries : this.myMissingModules;
        MissingModule missingModule = mapping.get(dependencyName);
        if (missingModule == null) {
            missingModule = new MissingModule(dependencyName, backupLibraryName);
            mapping.put(dependencyName, missingModule);
        }
        missingModule.addDependent(dependentName);
    }

    public void addMissingName(@NotNull String dependentName) {
        this.myDependentsOnModulesWithoutName.add(dependentName);
    }

    public void addMissingBinaryPath(@NotNull String dependentName) {
        this.myDependentsOnLibrariesWithoutBinaryPath.add(dependentName);
    }

    public void addInvalidModuleDependency(@NotNull Module module, @NotNull String targetModuleName, @NotNull String detail) {
        this.myInvalidModuleDependencies.add(new InvalidModuleDependency(module, targetModuleName, detail));
    }

    @NotNull
    public List<MissingModule> getMissingModules() {
        return DependencySetupErrors.getMissingModules(this.myMissingModules);
    }

    @NotNull
    public List<MissingModule> getMissingModulesWithBackupLibraries() {
        return DependencySetupErrors.getMissingModules(this.myMissingModulesWithBackupLibraries);
    }

    @NotNull
    private static List<MissingModule> getMissingModules(@NotNull Map<String, MissingModule> missingModulesByName) {
        if (missingModulesByName.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList missingModules = Lists.newArrayList();
        ArrayList names = Lists.newArrayList(missingModulesByName.keySet());
        if (names.size() > 1) {
            Collections.sort(names);
        }
        for (String name : names) {
            MissingModule missingModule = missingModulesByName.get(name);
            missingModule.sortDependentNames();
            missingModules.add(missingModule);
        }
        return missingModules;
    }

    @NotNull
    public List<String> getMissingNames() {
        return DependencySetupErrors.sortSet(this.myDependentsOnModulesWithoutName);
    }

    @NotNull
    public List<String> getDependentsOnLibrariesWithoutBinaryPath() {
        return DependencySetupErrors.sortSet(this.myDependentsOnLibrariesWithoutBinaryPath);
    }

    @NotNull
    public Set<InvalidModuleDependency> getInvalidModuleDependencies() {
        return this.myInvalidModuleDependencies;
    }

    @NotNull
    private static List<String> sortSet(@NotNull Set<String> set) {
        if (set.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList sorted = Lists.newArrayList(set);
        if (sorted.size() > 1) {
            Collections.sort(sorted);
        }
        return sorted;
    }

    public static class InvalidModuleDependency {
        @NotNull
        public final Module dependency;
        @NotNull
        public final String dependent;
        @NotNull
        public final String detail;

        InvalidModuleDependency(@NotNull Module dependency, @NotNull String dependent, @NotNull String detail) {
            this.dependency = dependency;
            this.dependent = dependent;
            this.detail = detail;
        }
    }

    public static class MissingModule {
        @NotNull
        public final String dependencyPath;
        @NotNull
        public final List<String> dependentNames = Lists.newArrayList();
        @Nullable
        public final String backupLibraryName;

        MissingModule(@NotNull String dependencyPath, @Nullable String backupLibraryName) {
            this.dependencyPath = dependencyPath;
            this.backupLibraryName = backupLibraryName;
        }

        void addDependent(@NotNull String dependentName) {
            this.dependentNames.add(dependentName);
        }

        void sortDependentNames() {
            if (!this.dependentNames.isEmpty()) {
                Collections.sort(this.dependentNames);
            }
        }
    }
}

