/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.cpp;

import com.android.tools.idea.gradle.NativeAndroidGradleModel;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.facet.NativeAndroidGradleFacet;
import com.android.tools.idea.gradle.facet.NativeAndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.facet.NativeAndroidGradleFacetType;
import com.android.tools.idea.gradle.util.Facets;
import com.intellij.facet.Facet;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeAndroidGradleFacetModuleCustomizer
implements ModuleCustomizer<NativeAndroidGradleModel> {
    @Override
    public void customizeModule(@NotNull Project project, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @Nullable NativeAndroidGradleModel nativeAndroidModel) {
        if (nativeAndroidModel == null) {
            Facets.removeAllFacetsOfType(NativeAndroidGradleFacet.TYPE_ID, modelsProvider.getModifiableFacetModel(module));
        } else {
            NativeAndroidGradleFacet facet = Facets.findFacet(module, modelsProvider, NativeAndroidGradleFacet.TYPE_ID);
            if (facet != null) {
                NativeAndroidGradleFacetModuleCustomizer.configureFacet(facet, nativeAndroidModel);
            } else {
                ModifiableFacetModel model = modelsProvider.getModifiableFacetModel(module);
                NativeAndroidGradleFacetType facetType = NativeAndroidGradleFacet.getFacetType();
                facet = facetType.createFacet(module, "Native-Android-Gradle", facetType.createDefaultConfiguration(), (Facet)null);
                model.addFacet((Facet)facet);
                NativeAndroidGradleFacetModuleCustomizer.configureFacet(facet, nativeAndroidModel);
            }
        }
    }

    private static void configureFacet(@NotNull NativeAndroidGradleFacet facet, @NotNull NativeAndroidGradleModel nativeAndroidModel) {
        NativeAndroidGradleFacetConfiguration configuration = (NativeAndroidGradleFacetConfiguration)facet.getConfiguration();
        String selectedVariant = configuration.SELECTED_BUILD_VARIANT;
        if (StringUtil.isNotEmpty((String)selectedVariant)) {
            String variant;
            Module module = facet.getModule();
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet != null && StringUtil.isNotEmpty((String)(variant = androidFacet.getProperties().SELECTED_BUILD_VARIANT)) && !variant.equals(selectedVariant)) {
                configuration.SELECTED_BUILD_VARIANT = selectedVariant = variant;
            }
            nativeAndroidModel.setSelectedVariantName(selectedVariant);
        }
        facet.setNativeAndroidGradleModel(nativeAndroidModel);
    }
}

