/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.android;

import com.android.builder.model.JavaArtifact;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.customizer.AbstractCompileOutputModuleCustomizer;
import com.android.tools.idea.gradle.variant.view.BuildVariantModuleCustomizer;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerOutputModuleCustomizer
extends AbstractCompileOutputModuleCustomizer<AndroidGradleModel>
implements BuildVariantModuleCustomizer<AndroidGradleModel> {
    @Override
    public void customizeModule(@NotNull Project project, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @Nullable AndroidGradleModel androidModel) {
        if (androidModel == null) {
            return;
        }
        GradleVersion modelVersion = androidModel.getModelVersion();
        if (modelVersion == null) {
            return;
        }
        Variant selectedVariant = androidModel.getSelectedVariant();
        File mainClassesFolder = selectedVariant.getMainArtifact().getClassesFolder();
        ModifiableRootModel moduleModel = modelsProvider.getModifiableRootModel(module);
        JavaArtifact testArtifact = androidModel.getUnitTestArtifactInSelectedVariant();
        File testClassesFolder = testArtifact == null ? null : testArtifact.getClassesFolder();
        this.setOutputPaths(moduleModel, mainClassesFolder, testClassesFolder);
    }

    @Override
    @NotNull
    public ProjectSystemId getProjectSystemId() {
        return ProjectSystemId.IDE;
    }

    @Override
    @NotNull
    public Class<AndroidGradleModel> getSupportedModelType() {
        return AndroidGradleModel.class;
    }
}

