/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.structure.AndroidProjectStructureConfigurable;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.android.tools.idea.structure.dialog.ProjectStructureConfigurable;
import com.intellij.ide.actions.ShowStructureSettingsAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class AndroidShowStructureSettingsAction
extends ShowStructureSettingsAction {
    public void update(AnActionEvent e) {
        Project project = e.getProject();
        if (project != null && Projects.requiresAndroidModel(project)) {
            e.getPresentation().setEnabledAndVisible(Projects.isBuildWithGradle(project));
        }
        super.update(e);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null && AndroidStudioInitializer.isAndroidStudio()) {
            project = ProjectManager.getInstance().getDefaultProject();
            AndroidShowStructureSettingsAction.showAndroidProjectStructure(project);
            return;
        }
        if (project != null && Projects.isBuildWithGradle(project)) {
            AndroidShowStructureSettingsAction.showAndroidProjectStructure(project);
            return;
        }
        super.actionPerformed(e);
    }

    private static void showAndroidProjectStructure(@NotNull Project project) {
        if (GradleExperimentalSettings.getInstance().USE_NEW_PROJECT_STRUCTURE_DIALOG) {
            ProjectStructureConfigurable projectStructure = ProjectStructureConfigurable.getInstance(project);
            AtomicBoolean needsSync = new AtomicBoolean();
            ProjectStructureConfigurable.ProjectStructureChangeListener changeListener = () -> needsSync.set(true);
            projectStructure.add(changeListener);
            projectStructure.showDialog();
            projectStructure.remove(changeListener);
            if (needsSync.get()) {
                GradleProjectImporter.getInstance().requestProjectSync(project, null);
            }
            return;
        }
        AndroidProjectStructureConfigurable.getInstance(project).showDialog();
    }
}

