/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleContentRoot;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;

public class JavaProject
implements Serializable {
    private static final long serialVersionUID = 3L;
    @NotNull
    private String myModuleName;
    @NotNull
    private Collection<JavaModuleContentRoot> myContentRoots = Lists.newArrayList();
    @NotNull
    private Collection<JavaModuleDependency> myJavaModuleDependencies = Lists.newArrayList();
    @NotNull
    private Collection<JarLibraryDependency> myJarLibraryDependencies = Lists.newArrayList();
    @NotNull
    private Map<String, Set<File>> myArtifactsByConfiguration;
    @NotNull
    private List<String> myConfigurations;
    @Nullable
    private ExtIdeaCompilerOutput myCompilerOutput;
    @Nullable
    private File myBuildFolderPath;
    @Nullable
    private String myLanguageLevel;
    private boolean myBuildable;
    private boolean myAndroidProjectWithoutVariants;

    @NotNull
    public static JavaProject create(@NotNull IdeaModule ideaModule, @Nullable ModuleExtendedModel extendedModel, boolean androidProjectWithoutVariants) {
        DomainObjectSet contentRoots;
        DomainObjectSet domainObjectSet = contentRoots = extendedModel != null ? extendedModel.getContentRoots() : null;
        if (contentRoots == null) {
            contentRoots = ideaModule.getContentRoots();
        }
        contentRoots = contentRoots != null ? contentRoots : Collections.emptyList();
        Map artifactsByConfiguration = Maps.newHashMap();
        if (extendedModel != null) {
            artifactsByConfiguration = extendedModel.getArtifactsByConfiguration();
        }
        ExtIdeaCompilerOutput compilerOutput = extendedModel != null ? extendedModel.getCompilerOutput() : null;
        File buildFolderPath = ideaModule.getGradleProject().getBuildDirectory();
        boolean buildable = !androidProjectWithoutVariants && JavaProject.isBuildable(ideaModule);
        String languageLevel = null;
        if (extendedModel != null) {
            languageLevel = extendedModel.getJavaSourceCompatibility();
        }
        return new JavaProject(ideaModule.getName(), (Collection<? extends IdeaContentRoot>)contentRoots, JavaProject.getDependencies(ideaModule), artifactsByConfiguration, compilerOutput, buildFolderPath, languageLevel, buildable, androidProjectWithoutVariants);
    }

    @NotNull
    private static List<? extends IdeaDependency> getDependencies(@NotNull IdeaModule ideaModule) {
        List dependencies = ideaModule.getDependencies().getAll();
        if (dependencies != null) {
            return dependencies;
        }
        return Collections.emptyList();
    }

    private static boolean isBuildable(@NotNull IdeaModule ideaModule) {
        for (GradleTask task : ideaModule.getGradleProject().getTasks()) {
            if (!"compileJava".equals(task.getName())) continue;
            return true;
        }
        return false;
    }

    public JavaProject(@NotNull String name, @NotNull Collection<? extends IdeaContentRoot> contentRoots, @NotNull List<? extends IdeaDependency> dependencies, @Nullable Map<String, Set<File>> artifactsByConfiguration, @Nullable ExtIdeaCompilerOutput compilerOutput, @Nullable File buildFolderPath, @Nullable String languageLevel, boolean buildable, boolean androidProjectWithoutVariants) {
        this.myModuleName = name;
        for (IdeaContentRoot ideaContentRoot : contentRoots) {
            if (ideaContentRoot == null) continue;
            this.myContentRoots.add(JavaModuleContentRoot.copy(ideaContentRoot));
        }
        for (IdeaDependency ideaDependency : dependencies) {
            JavaModuleDependency moduleDependency;
            if (ideaDependency instanceof IdeaSingleEntryLibraryDependency) {
                JarLibraryDependency libraryDependency = JarLibraryDependency.copy((IdeaSingleEntryLibraryDependency)ideaDependency);
                if (libraryDependency == null) continue;
                this.myJarLibraryDependencies.add(libraryDependency);
                continue;
            }
            if (!(ideaDependency instanceof IdeaModuleDependency) || (moduleDependency = JavaModuleDependency.copy((IdeaModuleDependency)ideaDependency)) == null) continue;
            this.myJavaModuleDependencies.add(moduleDependency);
        }
        this.myArtifactsByConfiguration = artifactsByConfiguration != null ? artifactsByConfiguration : Collections.emptyMap();
        this.myConfigurations = Lists.newArrayList(this.myArtifactsByConfiguration.keySet());
        Collections.sort(this.myConfigurations);
        this.myCompilerOutput = compilerOutput;
        this.myBuildFolderPath = buildFolderPath;
        this.myLanguageLevel = languageLevel;
        this.myBuildable = buildable;
        this.myAndroidProjectWithoutVariants = androidProjectWithoutVariants;
    }

    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    @NotNull
    public Collection<JavaModuleContentRoot> getContentRoots() {
        return this.myContentRoots;
    }

    public boolean containsSourceFile(@NotNull File file) {
        for (JavaModuleContentRoot contentRoot : this.getContentRoots()) {
            if (contentRoot == null || !JavaProject.containsFile(contentRoot, file)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsFile(@NotNull JavaModuleContentRoot contentRoot, @NotNull File file) {
        return JavaProject.containsFile(contentRoot.getSourceDirPaths(), file) || JavaProject.containsFile(contentRoot.getTestDirPaths(), file) || JavaProject.containsFile(contentRoot.getResourceDirPaths(), file) || JavaProject.containsFile(contentRoot.getGenSourceDirPaths(), file) || JavaProject.containsFile(contentRoot.getGenTestDirPaths(), file) || JavaProject.containsFile(contentRoot.getTestResourceDirPaths(), file);
    }

    private static boolean containsFile(@Nullable Collection<File> folderPaths, @NotNull File file) {
        if (folderPaths != null) {
            for (File path : folderPaths) {
                if (!FileUtil.isAncestor((File)path, (File)file, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public Map<String, Set<File>> getArtifactsByConfiguration() {
        return this.myArtifactsByConfiguration;
    }

    @Nullable
    public ExtIdeaCompilerOutput getCompilerOutput() {
        return this.myCompilerOutput;
    }

    @Nullable
    public File getBuildFolderPath() {
        return this.myBuildFolderPath;
    }

    @NotNull
    public Collection<JavaModuleDependency> getJavaModuleDependencies() {
        return this.myJavaModuleDependencies;
    }

    @NotNull
    public Collection<JarLibraryDependency> getJarLibraryDependencies() {
        return this.myJarLibraryDependencies;
    }

    public boolean isBuildable() {
        return this.myBuildable;
    }

    public boolean isAndroidProjectWithoutVariants() {
        return this.myAndroidProjectWithoutVariants;
    }

    @Nullable
    public LanguageLevel getJavaLanguageLevel() {
        if (this.myLanguageLevel != null) {
            return LanguageLevel.parse((String)this.myLanguageLevel);
        }
        return null;
    }

    @NotNull
    public List<String> getConfigurations() {
        return this.myConfigurations;
    }
}

