/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final List<String> myTaskNames;
    @NotNull
    private final String myGradlePath;
    @Nullable
    private final File myBuildFile;
    @Nullable
    private final String myGradleVersion;

    public static GradleModel create(@NotNull String moduleName, @NotNull GradleProject gradleProject, @Nullable File buildFile, @Nullable String gradleVersion) {
        ArrayList taskNames = Lists.newArrayList();
        DomainObjectSet tasks = gradleProject.getTasks();
        if (!tasks.isEmpty()) {
            for (GradleTask task : tasks) {
                String name = task.getName();
                if (!StringUtil.isNotEmpty((String)name)) continue;
                taskNames.add(task.getProject().getPath() + ":" + task.getName());
            }
        }
        return new GradleModel(moduleName, taskNames, gradleProject.getPath(), buildFile, gradleVersion);
    }

    public GradleModel(@NotNull String moduleName, @NotNull List<String> taskNames, @NotNull String gradlePath, @Nullable File buildFile, @Nullable String gradleVersion) {
        this.myModuleName = moduleName;
        this.myTaskNames = taskNames;
        this.myGradlePath = gradlePath;
        this.myBuildFile = buildFile;
        this.myGradleVersion = gradleVersion;
    }

    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    @NotNull
    public String getGradlePath() {
        return this.myGradlePath;
    }

    @NotNull
    public List<String> getTaskNames() {
        return this.myTaskNames;
    }

    @Nullable
    public VirtualFile getBuildFile() {
        return this.myBuildFile != null ? VfsUtil.findFileByIoFile((File)this.myBuildFile, (boolean)true) : null;
    }

    @Nullable
    public String getGradleVersion() {
        return this.myGradleVersion;
    }
}

