/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.JavaCompileOptions;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.AndroidGradleClassJarProvider;
import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.GradleModelFeatures;
import com.android.tools.idea.gradle.compiler.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ProxyUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.ClassJarProvider;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class AndroidGradleModel
implements AndroidModel,
Serializable {
    public static final String EXPLODED_BUNDLES = "exploded-bundles";
    public static final String EXPLODED_AAR = "exploded-aar";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getInstance(AndroidGradleModel.class);
    private static final String[] TEST_ARTIFACT_NAMES = new String[]{"_unit_test_", "_android_test_"};
    @NotNull
    private ProjectSystemId myProjectSystemId;
    @NotNull
    private String myModuleName;
    @NotNull
    private File myRootDirPath;
    @NotNull
    private AndroidProject myAndroidProject;
    @NotNull
    private transient GradleModelFeatures myFeatures;
    @Nullable
    private transient GradleVersion myModelVersion;
    @Nullable
    private transient CountDownLatch myProxyAndroidProjectLatch;
    @Nullable
    private AndroidProject myProxyAndroidProject;
    @NotNull
    private String mySelectedVariantName;
    @NotNull
    private String mySelectedTestArtifactName;
    private transient VirtualFile myRootDir;
    @Nullable
    private Boolean myOverridesManifestPackage;
    @Nullable
    private transient AndroidVersion myMinSdkVersion;
    @NotNull
    private Map<String, BuildTypeContainer> myBuildTypesByName = Maps.newHashMap();
    @NotNull
    private Map<String, ProductFlavorContainer> myProductFlavorsByName = Maps.newHashMap();
    @NotNull
    private Map<String, Variant> myVariantsByName = Maps.newHashMap();
    @NotNull
    private Set<File> myExtraGeneratedSourceFolders = Sets.newHashSet();
    private static final AndroidVersion NOT_SPECIFIED = new AndroidVersion(0, null);

    public AndroidGradleModel(@NotNull ProjectSystemId projectSystemId, @NotNull String moduleName, @NotNull File rootDirPath, @NotNull AndroidProject androidProject, @NotNull String selectedVariantName, @NotNull String selectedTestArtifactName) {
        this.myProjectSystemId = projectSystemId;
        this.myModuleName = moduleName;
        this.myRootDirPath = rootDirPath;
        this.myAndroidProject = androidProject;
        this.parseAndSetModelVersion();
        this.myFeatures = new GradleModelFeatures(this.myModelVersion);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.myProxyAndroidProjectLatch = new CountDownLatch(1);
            this.myProxyAndroidProject = ProxyUtil.reproxy(AndroidProject.class, this.myAndroidProject);
            this.myProxyAndroidProjectLatch.countDown();
        });
        this.populateBuildTypesByName();
        this.populateProductFlavorsByName();
        this.populateVariantsByName();
        this.mySelectedVariantName = this.findVariantToSelect(selectedVariantName);
        this.mySelectedTestArtifactName = AndroidGradleModel.validateTestArtifactName(selectedTestArtifactName);
    }

    private void populateBuildTypesByName() {
        for (BuildTypeContainer container : this.myAndroidProject.getBuildTypes()) {
            String name = container.getBuildType().getName();
            this.myBuildTypesByName.put(name, container);
        }
    }

    private void populateProductFlavorsByName() {
        for (ProductFlavorContainer container : this.myAndroidProject.getProductFlavors()) {
            String name = container.getProductFlavor().getName();
            this.myProductFlavorsByName.put(name, container);
        }
    }

    private void populateVariantsByName() {
        for (Variant variant : this.myAndroidProject.getVariants()) {
            this.myVariantsByName.put(variant.getName(), variant);
        }
    }

    @NotNull
    public Dependencies getSelectedMainCompileDependencies() {
        AndroidArtifact mainArtifact = this.getMainArtifact();
        return GradleUtil.getDependencies((BaseArtifact)mainArtifact, this.getModelVersion());
    }

    @Nullable
    public Dependencies getSelectedAndroidTestCompileDependencies() {
        AndroidArtifact androidTestArtifact = this.getAndroidTestArtifactInSelectedVariant();
        if (androidTestArtifact == null) {
            return null;
        }
        return GradleUtil.getDependencies((BaseArtifact)androidTestArtifact, this.getModelVersion());
    }

    @NotNull
    public GradleModelFeatures getFeatures() {
        return this.myFeatures;
    }

    @Nullable
    public GradleVersion getModelVersion() {
        return this.myModelVersion;
    }

    @NotNull
    public AndroidArtifact getMainArtifact() {
        return this.getSelectedVariant().getMainArtifact();
    }

    @Override
    @NotNull
    public SourceProvider getDefaultSourceProvider() {
        return this.getAndroidProject().getDefaultConfig().getSourceProvider();
    }

    @Override
    @NotNull
    public List<SourceProvider> getActiveSourceProviders() {
        return this.getMainSourceProviders(this.mySelectedVariantName);
    }

    @NotNull
    public List<SourceProvider> getMainSourceProviders(@NotNull String variantName) {
        Variant variant = this.myVariantsByName.get(variantName);
        if (variant == null) {
            LOG.error("Unknown variant name '" + variantName + "' found in the module '" + this.myModuleName + "'");
            return ImmutableList.of();
        }
        ArrayList providers = Lists.newArrayList();
        providers.add(this.getDefaultSourceProvider());
        for (String flavor : variant.getProductFlavors()) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.add(productFlavor.getSourceProvider());
        }
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        SourceProvider multiFlavorProvider = mainArtifact.getMultiFlavorSourceProvider();
        if (multiFlavorProvider != null) {
            providers.add(multiFlavorProvider);
        }
        BuildTypeContainer buildType = this.findBuildType(variant.getBuildType());
        assert (buildType != null);
        providers.add(buildType.getSourceProvider());
        SourceProvider variantProvider = mainArtifact.getVariantSourceProvider();
        if (variantProvider != null) {
            providers.add(variantProvider);
        }
        return providers;
    }

    @NotNull
    public Collection<SourceProvider> getTestSourceProviders(@NotNull Iterable<SourceProviderContainer> containers) {
        return AndroidGradleModel.getSourceProvidersForArtifacts(containers, TEST_ARTIFACT_NAMES);
    }

    @Override
    @NotNull
    public List<SourceProvider> getTestSourceProviders() {
        return this.getTestSourceProviders(this.mySelectedVariantName, TEST_ARTIFACT_NAMES);
    }

    @NotNull
    public List<SourceProvider> getTestSourceProviders(@NotNull String artifactName) {
        return this.getTestSourceProviders(this.mySelectedVariantName, artifactName);
    }

    @NotNull
    public List<SourceProvider> getTestSourceProviders(@NotNull String variantName, String ... testArtifactNames) {
        AndroidGradleModel.validateTestArtifactNames(testArtifactNames);
        ArrayList providers = Lists.newArrayList();
        Collection extraSourceProviders = this.getAndroidProject().getDefaultConfig().getExtraSourceProviders();
        providers.addAll(AndroidGradleModel.getSourceProvidersForArtifacts(extraSourceProviders, testArtifactNames));
        Variant variant = this.myVariantsByName.get(variantName);
        assert (variant != null);
        for (String flavor : variant.getProductFlavors()) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.addAll(AndroidGradleModel.getSourceProvidersForArtifacts(productFlavor.getExtraSourceProviders(), testArtifactNames));
        }
        BuildTypeContainer buildType = this.findBuildType(variant.getBuildType());
        assert (buildType != null);
        providers.addAll(AndroidGradleModel.getSourceProvidersForArtifacts(buildType.getExtraSourceProviders(), testArtifactNames));
        return providers;
    }

    private static void validateTestArtifactNames(@NotNull String[] testArtifactNames) {
        for (String name : testArtifactNames) {
            if (AndroidGradleModel.isTestArtifact(name)) continue;
            String msg = String.format("'%1$s' is not a test artifact", name);
            throw new IllegalArgumentException(msg);
        }
    }

    @NotNull
    public Collection<BaseArtifact> getTestArtifactsInSelectedVariant() {
        HashSet testArtifacts = Sets.newHashSet();
        Variant selectedVariant = this.getSelectedVariant();
        for (BaseArtifact artifact : selectedVariant.getExtraAndroidArtifacts()) {
            if (!AndroidGradleModel.isTestArtifact(artifact)) continue;
            testArtifacts.add(artifact);
        }
        for (BaseArtifact artifact : selectedVariant.getExtraJavaArtifacts()) {
            if (!AndroidGradleModel.isTestArtifact(artifact)) continue;
            testArtifacts.add(artifact);
        }
        return testArtifacts;
    }

    @Nullable
    public AndroidArtifact getAndroidTestArtifactInSelectedVariant() {
        for (AndroidArtifact artifact : this.getSelectedVariant().getExtraAndroidArtifacts()) {
            if (!AndroidGradleModel.isTestArtifact((BaseArtifact)artifact)) continue;
            return artifact;
        }
        return null;
    }

    @Nullable
    public JavaArtifact getUnitTestArtifactInSelectedVariant() {
        for (JavaArtifact artifact : this.getSelectedVariant().getExtraJavaArtifacts()) {
            if (!AndroidGradleModel.isTestArtifact((BaseArtifact)artifact)) continue;
            return artifact;
        }
        return null;
    }

    public static boolean isTestArtifact(@NotNull BaseArtifact artifact) {
        String artifactName = artifact.getName();
        return AndroidGradleModel.isTestArtifact(artifactName);
    }

    private static boolean isTestArtifact(@Nullable String artifactName) {
        return ArrayUtil.contains((String)artifactName, (String[])TEST_ARTIFACT_NAMES);
    }

    @Override
    @NotNull
    public List<SourceProvider> getAllSourceProviders() {
        Collection variants = this.myAndroidProject.getVariants();
        ArrayList providers = Lists.newArrayList();
        providers.add(this.getDefaultSourceProvider());
        Collection flavors = this.myAndroidProject.getProductFlavors();
        for (ProductFlavorContainer pfc : flavors) {
            providers.add(pfc.getSourceProvider());
        }
        for (Variant v : variants) {
            SourceProvider provider = v.getMainArtifact().getMultiFlavorSourceProvider();
            if (provider == null) continue;
            providers.add(provider);
        }
        Collection buildTypes = this.myAndroidProject.getBuildTypes();
        for (BuildTypeContainer btc : buildTypes) {
            providers.add(btc.getSourceProvider());
        }
        for (Variant v : variants) {
            SourceProvider provider = v.getMainArtifact().getVariantSourceProvider();
            if (provider == null) continue;
            providers.add(provider);
        }
        return providers;
    }

    @Override
    @NotNull
    public String getApplicationId() {
        return this.getSelectedVariant().getMainArtifact().getApplicationId();
    }

    @Override
    @NotNull
    public Set<String> getAllApplicationIds() {
        HashSet ids = Sets.newHashSet();
        for (Variant v : this.myAndroidProject.getVariants()) {
            String applicationId = v.getMergedFlavor().getApplicationId();
            if (applicationId == null) continue;
            ids.add(applicationId);
        }
        return ids;
    }

    @Override
    public Boolean isDebuggable() {
        BuildTypeContainer buildTypeContainer = this.findBuildType(this.getSelectedVariant().getBuildType());
        if (buildTypeContainer != null) {
            return buildTypeContainer.getBuildType().isDebuggable();
        }
        return null;
    }

    @Override
    @Nullable
    public AndroidVersion getMinSdkVersion() {
        if (this.myMinSdkVersion == null) {
            ApiVersion minSdkVersion = this.getSelectedVariant().getMergedFlavor().getMinSdkVersion();
            if (minSdkVersion != null && minSdkVersion.getCodename() != null) {
                ApiVersion defaultConfigVersion = this.getAndroidProject().getDefaultConfig().getProductFlavor().getMinSdkVersion();
                if (defaultConfigVersion != null) {
                    minSdkVersion = defaultConfigVersion;
                }
                List flavors = this.getSelectedVariant().getProductFlavors();
                for (String flavor : flavors) {
                    ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
                    assert (productFlavor != null);
                    ApiVersion flavorVersion = productFlavor.getProductFlavor().getMinSdkVersion();
                    if (flavorVersion == null) continue;
                    minSdkVersion = flavorVersion;
                    break;
                }
            }
            this.myMinSdkVersion = minSdkVersion != null ? LintUtils.convertVersion((ApiVersion)minSdkVersion, null) : NOT_SPECIFIED;
        }
        return this.myMinSdkVersion != NOT_SPECIFIED ? this.myMinSdkVersion : null;
    }

    @Override
    @Nullable
    public AndroidVersion getRuntimeMinSdkVersion() {
        ApiVersion minSdkVersion = this.getSelectedVariant().getMergedFlavor().getMinSdkVersion();
        if (minSdkVersion != null) {
            return new AndroidVersion(minSdkVersion.getApiLevel(), minSdkVersion.getCodename());
        }
        return null;
    }

    @Override
    @Nullable
    public AndroidVersion getTargetSdkVersion() {
        ApiVersion targetSdkVersion = this.getSelectedVariant().getMergedFlavor().getTargetSdkVersion();
        if (targetSdkVersion != null) {
            return new AndroidVersion(targetSdkVersion.getApiLevel(), targetSdkVersion.getCodename());
        }
        return null;
    }

    @Override
    @Nullable
    public Integer getVersionCode() {
        Variant variant = this.getSelectedVariant();
        ProductFlavor flavor = variant.getMergedFlavor();
        return flavor.getVersionCode();
    }

    @NotNull
    public ProjectSystemId getProjectSystemId() {
        return this.myProjectSystemId;
    }

    @Nullable
    public BuildTypeContainer findBuildType(@NotNull String name) {
        return this.myBuildTypesByName.get(name);
    }

    @NotNull
    public Set<String> getBuildTypes() {
        return this.myBuildTypesByName.keySet();
    }

    @NotNull
    public Set<String> getProductFlavors() {
        return this.myProductFlavorsByName.keySet();
    }

    @Nullable
    public ProductFlavorContainer findProductFlavor(@NotNull String name) {
        return this.myProductFlavorsByName.get(name);
    }

    @Nullable
    public BaseArtifact findSelectedTestArtifact(@NotNull Variant variant) {
        BaseArtifact artifact = this.getBaseArtifact(variant.getExtraAndroidArtifacts());
        if (artifact != null) {
            return artifact;
        }
        return this.getBaseArtifact(variant.getExtraJavaArtifacts());
    }

    @Nullable
    private BaseArtifact getBaseArtifact(@NotNull Iterable<? extends BaseArtifact> artifacts) {
        for (BaseArtifact baseArtifact : artifacts) {
            if (!this.getSelectedTestArtifactName().equals(baseArtifact.getName())) continue;
            return baseArtifact;
        }
        return null;
    }

    @Nullable
    public BaseArtifact findSelectedTestArtifactInSelectedVariant() {
        return this.findSelectedTestArtifact(this.getSelectedVariant());
    }

    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    @Override
    @NotNull
    public File getRootDirPath() {
        return this.myRootDirPath;
    }

    @Override
    @NotNull
    public VirtualFile getRootDir() {
        if (this.myRootDir == null) {
            VirtualFile found = VfsUtil.findFileByIoFile((File)this.myRootDirPath, (boolean)true);
            assert (found != null);
            this.myRootDir = found;
        }
        return this.myRootDir;
    }

    @Override
    public boolean isGenerated(@NotNull VirtualFile file) {
        VirtualFile buildFolder = VfsUtil.findFileByIoFile((File)this.myAndroidProject.getBuildFolder(), (boolean)false);
        return buildFolder != null && VfsUtilCore.isAncestor((VirtualFile)buildFolder, (VirtualFile)file, (boolean)false);
    }

    @NotNull
    public AndroidProject getAndroidProject() {
        return this.myAndroidProject;
    }

    @NotNull
    public AndroidProject waitForAndGetProxyAndroidProject() {
        this.waitForProxyAndroidProject();
        assert (this.myProxyAndroidProject != null);
        return this.myProxyAndroidProject;
    }

    public void waitForProxyAndroidProject() {
        if (this.myProxyAndroidProjectLatch != null) {
            try {
                this.myProxyAndroidProjectLatch.await();
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    @NotNull
    public Variant getSelectedVariant() {
        Variant selected = this.myVariantsByName.get(this.mySelectedVariantName);
        assert (selected != null);
        return selected;
    }

    @Nullable
    public Variant findVariantByName(@NotNull String variantName) {
        return this.myVariantsByName.get(variantName);
    }

    public void setSelectedVariantName(@NotNull String name) {
        this.mySelectedVariantName = this.findVariantToSelect(name);
        this.myOverridesManifestPackage = null;
        this.myMinSdkVersion = null;
    }

    @NotNull
    private String findVariantToSelect(@NotNull String variantName) {
        String newVariantName;
        Collection<String> variantNames = this.getVariantNames();
        if (variantNames.contains(variantName)) {
            newVariantName = variantName;
        } else {
            ArrayList sorted = Lists.newArrayList(variantNames);
            Collections.sort(sorted);
            newVariantName = (String)sorted.get(0);
        }
        return newVariantName;
    }

    public void setSelectedTestArtifactName(@NotNull String selectedTestArtifactName) {
        this.mySelectedTestArtifactName = AndroidGradleModel.validateTestArtifactName(selectedTestArtifactName);
    }

    @NotNull
    private static String validateTestArtifactName(@NotNull String selectedTestArtifactName) {
        assert (selectedTestArtifactName.equals("_android_test_") || selectedTestArtifactName.equals("_unit_test_"));
        return selectedTestArtifactName;
    }

    @NotNull
    public String getSelectedTestArtifactName() {
        return this.mySelectedTestArtifactName;
    }

    @NotNull
    private static Collection<SourceProvider> getSourceProvidersForArtifacts(@NotNull Iterable<SourceProviderContainer> containers, String ... artifactNames) {
        HashSet providers = Sets.newHashSet();
        block0: for (SourceProviderContainer container : containers) {
            for (String artifactName : artifactNames) {
                if (!artifactName.equals(container.getArtifactName())) continue;
                providers.add(container.getSourceProvider());
                continue block0;
            }
        }
        return providers;
    }

    @NotNull
    public Collection<String> getBuildTypeNames() {
        return this.myBuildTypesByName.keySet();
    }

    @NotNull
    public Collection<String> getProductFlavorNames() {
        return this.myProductFlavorsByName.keySet();
    }

    @NotNull
    public Collection<String> getVariantNames() {
        return this.myVariantsByName.keySet();
    }

    @Nullable
    public LanguageLevel getJavaLanguageLevel() {
        JavaCompileOptions compileOptions = this.myAndroidProject.getJavaCompileOptions();
        String sourceCompatibility = compileOptions.getSourceCompatibility();
        return LanguageLevel.parse((String)sourceCompatibility);
    }

    public boolean isLibrary() {
        return this.getAndroidProject().isLibrary();
    }

    @Override
    public boolean overridesManifestPackage() {
        if (this.myOverridesManifestPackage == null) {
            this.myOverridesManifestPackage = this.getAndroidProject().getDefaultConfig().getProductFlavor().getApplicationId() != null;
            Variant variant = this.getSelectedVariant();
            List flavors = variant.getProductFlavors();
            for (String flavor : flavors) {
                ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
                assert (productFlavor != null);
                if (productFlavor.getProductFlavor().getApplicationId() == null) continue;
                this.myOverridesManifestPackage = true;
                break;
            }
        }
        return this.myOverridesManifestPackage;
    }

    public void registerExtraGeneratedSourceFolder(@NotNull File folderPath) {
        this.myExtraGeneratedSourceFolders.add(folderPath);
    }

    @NotNull
    public List<File> getExcludedFolderPaths() {
        File buildFolderPath = this.getAndroidProject().getBuildFolder();
        ArrayList excludedFolderPaths = Lists.newArrayList();
        if (buildFolderPath.isDirectory()) {
            for (File folderPath : FileUtil.notNullize((File[])buildFolderPath.listFiles())) {
                String folderName = folderPath.getName();
                if (folderName.equals("intermediates") || folderName.equals("generated")) continue;
                excludedFolderPaths.add(folderPath);
            }
            File intermediates = new File(buildFolderPath, "intermediates");
            if (intermediates.isDirectory()) {
                for (File folderPath : FileUtil.notNullize((File[])intermediates.listFiles())) {
                    String folderName = folderPath.getName();
                    if (folderName.equals(EXPLODED_AAR) || folderName.equals(EXPLODED_BUNDLES) || folderName.equals("manifest")) continue;
                    excludedFolderPaths.add(folderPath);
                }
            }
        } else {
            excludedFolderPaths.add(new File(buildFolderPath, "outputs"));
            excludedFolderPaths.add(new File(buildFolderPath, "tmp"));
        }
        return excludedFolderPaths;
    }

    @NotNull
    public File[] getExtraGeneratedSourceFolders() {
        return this.myExtraGeneratedSourceFolders.toArray(new File[this.myExtraGeneratedSourceFolders.size()]);
    }

    @Nullable
    public Collection<SyncIssue> getSyncIssues() {
        if (this.getFeatures().isIssueReportingSupported()) {
            return this.myAndroidProject.getSyncIssues();
        }
        return null;
    }

    @Nullable
    public SourceFileContainerInfo containsSourceFile(@NotNull File file) {
        ProductFlavorContainer defaultConfig = this.myAndroidProject.getDefaultConfig();
        if (AndroidGradleModel.containsSourceFile(defaultConfig, file)) {
            return new SourceFileContainerInfo();
        }
        for (Variant variant : this.myAndroidProject.getVariants()) {
            AndroidArtifact artifact = variant.getMainArtifact();
            if (AndroidGradleModel.containsSourceFile((BaseArtifact)artifact, file)) {
                return new SourceFileContainerInfo(variant, (BaseArtifact)artifact);
            }
            for (AndroidArtifact extraArtifact : variant.getExtraAndroidArtifacts()) {
                if (!AndroidGradleModel.containsSourceFile((BaseArtifact)extraArtifact, file)) continue;
                return new SourceFileContainerInfo(variant, (BaseArtifact)extraArtifact);
            }
            String buildTypeName = variant.getBuildType();
            BuildTypeContainer buildTypeContainer = this.findBuildType(buildTypeName);
            if (buildTypeContainer != null) {
                if (AndroidGradleModel.containsFile(buildTypeContainer.getSourceProvider(), file)) {
                    return new SourceFileContainerInfo(variant);
                }
                for (SourceProviderContainer extraSourceProvider : buildTypeContainer.getExtraSourceProviders()) {
                    if (!AndroidGradleModel.containsFile(extraSourceProvider.getSourceProvider(), file)) continue;
                    return new SourceFileContainerInfo(variant);
                }
            }
            for (String flavorName : variant.getProductFlavors()) {
                ProductFlavorContainer flavor = this.findProductFlavor(flavorName);
                if (flavor == null || !AndroidGradleModel.containsSourceFile(flavor, file)) continue;
                return new SourceFileContainerInfo(variant);
            }
        }
        return null;
    }

    private static boolean containsSourceFile(@NotNull ProductFlavorContainer flavorContainer, @NotNull File file) {
        if (AndroidGradleModel.containsFile(flavorContainer.getSourceProvider(), file)) {
            return true;
        }
        for (SourceProviderContainer extraSourceProvider : flavorContainer.getExtraSourceProviders()) {
            if (!AndroidGradleModel.containsFile(extraSourceProvider.getSourceProvider(), file)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSourceFile(@NotNull BaseArtifact artifact, @NotNull File file) {
        AndroidArtifact androidArtifact;
        if (artifact instanceof AndroidArtifact && (AndroidGradleModel.containsFile(GradleUtil.getGeneratedSourceFolders((BaseArtifact)(androidArtifact = (AndroidArtifact)artifact)), file) || AndroidGradleModel.containsFile(androidArtifact.getGeneratedResourceFolders(), file))) {
            return true;
        }
        SourceProvider sourceProvider = artifact.getVariantSourceProvider();
        if (sourceProvider != null && AndroidGradleModel.containsFile(sourceProvider, file)) {
            return true;
        }
        sourceProvider = artifact.getMultiFlavorSourceProvider();
        return sourceProvider != null && AndroidGradleModel.containsFile(sourceProvider, file);
    }

    private static boolean containsFile(@NotNull SourceProvider sourceProvider, @NotNull File file) {
        return AndroidGradleModel.containsFile(sourceProvider.getAidlDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getAssetsDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getCDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getCppDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getJavaDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getRenderscriptDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getResDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getResourcesDirectories(), file);
    }

    private static boolean containsFile(@NotNull Collection<File> directories, @NotNull File file) {
        for (File directory : directories) {
            if (!FileUtil.isAncestor((File)directory, (File)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.waitForProxyAndroidProject();
        out.writeObject(this.myProjectSystemId);
        out.writeObject(this.myModuleName);
        out.writeObject(this.myRootDirPath);
        out.writeObject(this.myProxyAndroidProject);
        out.writeObject(this.mySelectedVariantName);
        out.writeObject(this.mySelectedTestArtifactName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.myProjectSystemId = (ProjectSystemId)in.readObject();
        this.myModuleName = (String)in.readObject();
        this.myRootDirPath = (File)in.readObject();
        this.myAndroidProject = (AndroidProject)in.readObject();
        this.parseAndSetModelVersion();
        this.myFeatures = new GradleModelFeatures(this.myModelVersion);
        this.myProxyAndroidProject = this.myAndroidProject;
        this.myBuildTypesByName = Maps.newHashMap();
        this.myProductFlavorsByName = Maps.newHashMap();
        this.myVariantsByName = Maps.newHashMap();
        this.myExtraGeneratedSourceFolders = Sets.newHashSet();
        this.populateBuildTypesByName();
        this.populateProductFlavorsByName();
        this.populateVariantsByName();
        this.setSelectedVariantName((String)in.readObject());
        this.setSelectedTestArtifactName((String)in.readObject());
    }

    private void parseAndSetModelVersion() {
        this.myModelVersion = GradleVersion.tryParse((String)this.myAndroidProject.getModelVersion());
    }

    @Nullable
    public static AndroidGradleModel get(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? AndroidGradleModel.get(facet) : null;
    }

    @Nullable
    public static AndroidGradleModel get(@NotNull AndroidFacet androidFacet) {
        AndroidModel androidModel = androidFacet.getAndroidModel();
        if (androidModel == null) {
            return null;
        }
        if (!(androidModel instanceof AndroidGradleModel)) {
            return null;
        }
        return (AndroidGradleModel)androidModel;
    }

    @NotNull
    public SourceProvider getBuildTypeSourceProvider() {
        Variant selectedVariant = this.getSelectedVariant();
        BuildTypeContainer buildType = this.findBuildType(selectedVariant.getBuildType());
        assert (buildType != null);
        return buildType.getSourceProvider();
    }

    @NotNull
    public List<SourceProvider> getFlavorSourceProviders() {
        Variant selectedVariant = this.getSelectedVariant();
        List productFlavors = selectedVariant.getProductFlavors();
        ArrayList providers = Lists.newArrayList();
        for (String flavor : productFlavors) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.add(productFlavor.getSourceProvider());
        }
        return providers;
    }

    public void syncSelectedVariantAndTestArtifact(@NotNull AndroidFacet facet) {
        Variant variant = this.getSelectedVariant();
        JpsAndroidModuleProperties state = facet.getProperties();
        state.SELECTED_BUILD_VARIANT = variant.getName();
        state.SELECTED_TEST_ARTIFACT = this.getSelectedTestArtifactName();
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        AndroidGradleModel.updateGradleTaskNames(state, mainArtifact, null);
    }

    @VisibleForTesting
    static void updateGradleTaskNames(@NotNull JpsAndroidModuleProperties state, @NotNull AndroidArtifact mainArtifact, @Nullable BaseArtifact testArtifact) {
        state.ASSEMBLE_TASK_NAME = mainArtifact.getAssembleTaskName();
        state.COMPILE_JAVA_TASK_NAME = mainArtifact.getCompileTaskName();
        state.AFTER_SYNC_TASK_NAMES = Sets.newHashSet(AndroidGradleModel.getIdeSetupTasks((BaseArtifact)mainArtifact));
        if (testArtifact != null) {
            state.ASSEMBLE_TEST_TASK_NAME = testArtifact.getAssembleTaskName();
            state.COMPILE_JAVA_TEST_TASK_NAME = testArtifact.getCompileTaskName();
            state.AFTER_SYNC_TASK_NAMES.addAll(AndroidGradleModel.getIdeSetupTasks(testArtifact));
        } else {
            state.ASSEMBLE_TEST_TASK_NAME = "";
            state.COMPILE_JAVA_TEST_TASK_NAME = "";
        }
    }

    @NotNull
    public static Set<String> getIdeSetupTasks(@NotNull BaseArtifact artifact) {
        block4: {
            try {
                return artifact.getIdeSetupTaskNames();
            }
            catch (NoSuchMethodError e) {
                if (artifact instanceof AndroidArtifact) {
                    return Sets.newHashSet((Object[])new String[]{((AndroidArtifact)artifact).getSourceGenTaskName()});
                }
            }
            catch (UnsupportedMethodException e) {
                if (!(artifact instanceof AndroidArtifact)) break block4;
                return Sets.newHashSet((Object[])new String[]{((AndroidArtifact)artifact).getSourceGenTaskName()});
            }
        }
        return Collections.emptySet();
    }

    @Nullable
    public SourceProvider getMultiFlavorSourceProvider() {
        AndroidArtifact mainArtifact = this.getSelectedVariant().getMainArtifact();
        return mainArtifact.getMultiFlavorSourceProvider();
    }

    @Nullable
    public SourceProvider getVariantSourceProvider() {
        AndroidArtifact mainArtifact = this.getSelectedVariant().getMainArtifact();
        return mainArtifact.getVariantSourceProvider();
    }

    @Override
    public boolean getDataBindingEnabled() {
        return GradleUtil.dependsOn(this, "com.android.databinding:library");
    }

    @Override
    @NotNull
    public ClassJarProvider getClassJarProvider() {
        return new AndroidGradleClassJarProvider();
    }

    @Override
    @Nullable
    public Long getLastBuildTimestamp(@NotNull Project project) {
        return PostProjectBuildTasksExecutor.getInstance(project).getLastBuildTimestamp();
    }

    public static class SourceFileContainerInfo {
        @Nullable
        public final Variant variant;
        @Nullable
        public final BaseArtifact artifact;

        SourceFileContainerInfo() {
            this(null);
        }

        SourceFileContainerInfo(@Nullable Variant variant) {
            this(variant, null);
        }

        SourceFileContainerInfo(@Nullable Variant variant, @Nullable BaseArtifact artifact) {
            this.variant = variant;
            this.artifact = artifact;
        }

        public void updateSelectedVariantIn(@NotNull DataNode<ModuleData> moduleNode) {
            DataNode androidProjectNode;
            if (this.variant != null && (androidProjectNode = ExternalSystemApiUtil.find(moduleNode, AndroidProjectKeys.ANDROID_MODEL)) != null) {
                ((AndroidGradleModel)androidProjectNode.getData()).setSelectedVariantName(this.variant.getName());
            }
        }
    }
}

