/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.fd.BuildCause;
import com.android.tools.idea.fd.DeployType;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.google.wireless.android.sdk.stats.AndroidStudioStats;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunStatsService {
    private final Object LOCK = new Object();
    @NotNull
    private UUID mySessionId = UUID.randomUUID();
    private long myBuildStartTime;

    public static InstantRunStatsService get(@NotNull Project project) {
        return (InstantRunStatsService)ServiceManager.getService((Project)project, InstantRunStatsService.class);
    }

    private InstantRunStatsService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBuildStarted() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myBuildStartTime = System.currentTimeMillis();
        }
    }

    public void notifyDeployStarted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDeployType(@NotNull DeployType type, @NotNull BuildCause buildCause, @NotNull IDevice device) {
        String sessionId;
        long buildAndDeployTime;
        Object object = this.LOCK;
        synchronized (object) {
            buildAndDeployTime = System.currentTimeMillis() - this.myBuildStartTime;
            if (type == DeployType.FULLAPK || type == DeployType.LEGACY || type == DeployType.SPLITAPK) {
                this.resetSession();
            }
            sessionId = this.mySessionId.toString();
        }
        AndroidStudioStats.AndroidStudioEvent.Builder studioEvent = AndroidStudioStats.AndroidStudioEvent.newBuilder().setCategory(AndroidStudioStats.AndroidStudioEvent.EventCategory.STUDIO_BUILD).setKind(AndroidStudioStats.AndroidStudioEvent.EventKind.INSTANT_RUN).setInstantRun(AndroidStudioStats.InstantRun.newBuilder().setSessionId(sessionId).setBuildTime(buildAndDeployTime).setDeploymentKind(InstantRunStatsService.deployTypeToDeploymentKind(type)).setIdeBuildCause(InstantRunStatsService.buildCauseToProto(buildCause)));
        if (buildCause == BuildCause.API_TOO_LOW_FOR_INSTANT_RUN || buildCause == BuildCause.FREEZE_SWAP_REQUIRES_API21 || buildCause == BuildCause.FREEZE_SWAP_REQUIRES_WORKING_RUN_AS) {
            studioEvent.setDeviceInfo(AndroidStudioUsageTracker.deviceToDeviceInfo(device));
        } else {
            studioEvent.setDeviceInfo(AndroidStudioUsageTracker.deviceToDeviceInfoApilLevelOnly(device));
        }
        UsageTracker.getInstance().log(studioEvent);
    }

    private static AndroidStudioStats.InstantRun.InstantRunIdeBuildCause buildCauseToProto(@Nullable BuildCause buildCause) {
        if (buildCause == null) {
            return AndroidStudioStats.InstantRun.InstantRunIdeBuildCause.UNKNOWN_INSTANT_RUN_IDE_BUILD_CAUSE;
        }
        try {
            return AndroidStudioStats.InstantRun.InstantRunIdeBuildCause.valueOf((String)buildCause.toString());
        }
        catch (IllegalArgumentException e) {
            return AndroidStudioStats.InstantRun.InstantRunIdeBuildCause.UNKNOWN_INSTANT_RUN_IDE_BUILD_CAUSE;
        }
    }

    private static AndroidStudioStats.InstantRun.InstantRunDeploymentKind deployTypeToDeploymentKind(@NotNull DeployType type) {
        switch (type) {
            case LEGACY: {
                return AndroidStudioStats.InstantRun.InstantRunDeploymentKind.LEGACY;
            }
            case FULLAPK: {
                return AndroidStudioStats.InstantRun.InstantRunDeploymentKind.FULL_APK;
            }
            case HOTSWAP: {
                return AndroidStudioStats.InstantRun.InstantRunDeploymentKind.HOT_SWAP;
            }
            case SPLITAPK: {
                return AndroidStudioStats.InstantRun.InstantRunDeploymentKind.SPLIT_APK;
            }
            case DEX: {
                return AndroidStudioStats.InstantRun.InstantRunDeploymentKind.DEX;
            }
            case WARMSWAP: {
                return AndroidStudioStats.InstantRun.InstantRunDeploymentKind.WARM_SWAP;
            }
            case NO_CHANGES: {
                return AndroidStudioStats.InstantRun.InstantRunDeploymentKind.NO_CHANGES;
            }
        }
        return AndroidStudioStats.InstantRun.InstantRunDeploymentKind.UNKNOWN_INSTANT_RUN_DEPLOYMENT_KIND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSession() {
        Object object = this.LOCK;
        synchronized (object) {
            this.mySessionId = UUID.randomUUID();
        }
    }
}

