/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.tools.idea.fd.BuildCause;
import com.android.tools.idea.fd.BuildMode;
import com.android.tools.idea.fd.BuildSelection;
import com.android.tools.idea.fd.DeployType;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunNotificationProvider {
    private static final Set<BuildCause> ourCausesThatDontNeedNotifications = ImmutableSet.of((Object)((Object)BuildCause.FIRST_INSTALLATION_TO_DEVICE), (Object)((Object)BuildCause.APP_NOT_INSTALLED));
    private static final Map<BuildCause, String> ourFullBuildNotificationsByCause = new ImmutableMap.Builder().put((Object)BuildCause.USER_REQUESTED_CLEAN_BUILD, (Object)AndroidBundle.message("instant.run.notification.cleanbuild.on.user.request", new Object[0])).put((Object)BuildCause.MISMATCHING_TIMESTAMPS, (Object)AndroidBundle.message("instant.run.notification.cleanbuild.mismatching.timestamps", new Object[0])).put((Object)BuildCause.API_TOO_LOW_FOR_INSTANT_RUN, (Object)AndroidBundle.message("instant.run.notification.fullbuild.api.less.than.15", new Object[0])).put((Object)BuildCause.MANIFEST_RESOURCE_CHANGED, (Object)AndroidBundle.message("instant.run.notification.fullbuild.manifestresourcechanged", new Object[0])).put((Object)BuildCause.FREEZE_SWAP_REQUIRES_API21, (Object)AndroidBundle.message("instant.run.notification.fullbuild.api.less.than.21", new Object[0])).put((Object)BuildCause.FREEZE_SWAP_REQUIRES_WORKING_RUN_AS, (Object)AndroidBundle.message("instant.run.notification.fullbuild.broken.runas", new Object[0])).build();
    private final BuildSelection myBuildSelection;
    private final DeployType myDeployType;
    private final String myVerifierStatus;

    public InstantRunNotificationProvider(@NotNull BuildSelection buildSelection, @NotNull DeployType deployType, @NotNull String verifierStatus) {
        this.myBuildSelection = buildSelection;
        this.myDeployType = deployType;
        this.myVerifierStatus = verifierStatus;
    }

    @Nullable
    public String getNotificationText() {
        BuildMode buildMode = this.myBuildSelection.mode;
        BuildCause buildCause = this.myBuildSelection.why;
        if (ourCausesThatDontNeedNotifications.contains((Object)buildCause)) {
            return null;
        }
        if (ourFullBuildNotificationsByCause.containsKey((Object)buildCause)) {
            return ourFullBuildNotificationsByCause.get((Object)buildCause);
        }
        if (buildCause == BuildCause.APP_NOT_RUNNING) {
            return this.myDeployType == DeployType.NO_CHANGES ? AndroidBundle.message("instant.run.notification.coldswap.nochanges", new Object[0]) : AndroidBundle.message("instant.run.notification.coldswap", new Object[0]);
        }
        if (buildCause == BuildCause.ANDROID_TV_UNSUPPORTED) {
            return AndroidBundle.message("instant.run.notification.coldswap.tv", new Object[0]);
        }
        switch (this.myDeployType) {
            case NO_CHANGES: {
                return AndroidBundle.message("instant.run.notification.nochanges", new Object[0]);
            }
            case HOTSWAP: {
                return AndroidBundle.message("instant.run.notification.hotswap", InstantRunNotificationProvider.getRestartActivityShortcutText());
            }
            case WARMSWAP: {
                return AndroidBundle.message("instant.run.notification.warmswap", new Object[0]);
            }
            case SPLITAPK: 
            case DEX: {
                StringBuilder sb = new StringBuilder("Instant Run applied code changes and restarted the app.");
                if (buildMode == BuildMode.HOT) {
                    if (!this.myVerifierStatus.isEmpty()) {
                        sb.append(' ');
                        sb.append(StringUtil.capitalizeWords((String)this.myVerifierStatus.toLowerCase(Locale.US).replace('_', ' '), (boolean)true));
                        sb.append('.');
                    }
                } else if (buildMode == BuildMode.COLD) {
                    if (buildCause == BuildCause.APP_USES_MULTIPLE_PROCESSES) {
                        return AndroidBundle.message("instant.run.notification.coldswap.multiprocess", new Object[0]);
                    }
                    sb.append(' ').append((Object)buildCause).append('.');
                }
                return sb.toString();
            }
            case FULLAPK: {
                return "Instant Run re-installed and restarted the app";
            }
        }
        return null;
    }

    @NotNull
    private static String getRestartActivityShortcutText() {
        if (ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isUnitTestMode()) {
            return "";
        }
        Shortcut[] shortcuts = ActionManager.getInstance().getAction("Android.RestartActivity").getShortcutSet().getShortcuts();
        return shortcuts.length > 0 ? " (" + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + ") " : "";
    }
}

