/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.AttributeReferenceRendererEditor;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResourcesCompletionProvider
implements AttributeReferenceRendererEditor.CompletionProvider,
ThemeEditorContext.ChangeListener {
    private final ArrayList<ResourceValue> myAllResources = new ArrayList();

    ResourcesCompletionProvider(@NotNull ThemeEditorContext themeEditorContext) {
        this.fillResources(themeEditorContext.getResourceResolver());
    }

    @Override
    @NotNull
    public List<String> getCompletions(@NotNull EditedStyleItem value) {
        ConfiguredThemeEditorStyle selectedStyle = value.getSourceStyle();
        AttributeDefinition attrDefinition = ResolutionUtils.getAttributeDefinition(selectedStyle.getConfiguration(), value.getSelectedValue());
        if (attrDefinition == null) {
            return Collections.emptyList();
        }
        EnumSet<ResourceType> acceptedTypes = EnumSet.noneOf(ResourceType.class);
        if (ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Color)) {
            acceptedTypes.add(ResourceType.COLOR);
        }
        if (ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Dimension)) {
            acceptedTypes.add(ResourceType.DIMEN);
        }
        if (ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.String)) {
            acceptedTypes.add(ResourceType.STRING);
        }
        if (ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Reference)) {
            acceptedTypes.addAll((Collection<ResourceType>)ImmutableList.of((Object)ResourceType.LAYOUT, (Object)ResourceType.COLOR, (Object)ResourceType.DRAWABLE, (Object)ResourceType.MIPMAP, (Object)ResourceType.STYLE, (Object)ResourceType.ATTR, (Object)ResourceType.STRING, (Object)ResourceType.DIMEN, (Object)ResourceType.TRANSITION));
        }
        ArrayList<String> resourceNamesList = new ArrayList<String>(this.myAllResources.size());
        for (ResourceValue resource : this.myAllResources) {
            if (!acceptedTypes.contains(resource.getResourceType())) continue;
            String name = String.format("%1$s%2$s%3$s/%4$s", ResourceType.ATTR == resource.getResourceType() ? "?" : "@", resource.isFramework() ? "android:" : "", resource.getResourceType().getName(), resource.getName());
            resourceNamesList.add(name);
        }
        return resourceNamesList;
    }

    private void fillResources(@Nullable ResourceResolver resourceResolver) {
        this.myAllResources.clear();
        if (resourceResolver == null) {
            return;
        }
        for (Map resourceTypeResource : resourceResolver.getFrameworkResources().values()) {
            this.myAllResources.addAll(resourceTypeResource.values());
        }
        for (Map resourceTypeResource : resourceResolver.getProjectResources().values()) {
            this.myAllResources.addAll(resourceTypeResource.values());
        }
    }

    @Override
    public void onNewConfiguration(ThemeEditorContext context) {
        this.fillResources(context.getResourceResolver());
    }
}

