/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.table.ConstantColumn;
import com.android.tools.idea.editors.strings.table.HeaderCellRenderer;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class ConstantHeaderCellRenderer
implements HeaderCellRenderer {
    private final int myCollapsedWidth;
    private final int myExpandedWidth;

    public ConstantHeaderCellRenderer(int index, @NotNull FontMetrics metrics) {
        int descriptionWidth = 20 + metrics.stringWidth(ConstantColumn.values()[index].name);
        int dataWidth = 20 + metrics.stringWidth(String.valueOf(ConstantColumn.values()[index].sampleData));
        this.myCollapsedWidth = Math.min(descriptionWidth, dataWidth);
        this.myExpandedWidth = Math.max(descriptionWidth, dataWidth);
    }

    @Override
    public int getCollapsedWidth() {
        return this.myCollapsedWidth;
    }

    @Override
    public int getFullExpandedWidth() {
        return this.myExpandedWidth;
    }

    @Override
    public int getMinimumExpandedWidth() {
        return (this.myCollapsedWidth + this.myExpandedWidth) / 2;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
        return table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, value, selected, focused, row, column);
    }
}

