/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.table.ConstantColumn;
import com.android.tools.idea.editors.strings.table.ConstantHeaderCellRenderer;
import com.android.tools.idea.editors.strings.table.HeaderCellRenderer;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.StringsCellRenderer;
import com.android.tools.idea.editors.strings.table.TranslationHeaderCellRenderer;
import com.android.tools.idea.rendering.Locale;
import com.intellij.ui.BooleanTableCellRenderer;
import java.awt.FontMetrics;
import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;

public class ColumnUtil {
    private static final TableCellRenderer CELL_RENDERER = new StringsCellRenderer();

    public static void setColumns(@NotNull JTable table) {
        StringResourceTableModel model = (StringResourceTableModel)table.getModel();
        Enumeration<TableColumn> columns = table.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            if (column.getModelIndex() == ConstantColumn.UNTRANSLATABLE.ordinal()) {
                column.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
            } else {
                column.setCellRenderer(CELL_RENDERER);
            }
            int index = column.getModelIndex();
            FontMetrics fontMetrics = table.getFontMetrics(table.getFont());
            Locale locale = model.localeOfColumn(index);
            HeaderCellRenderer renderer = locale == null ? new ConstantHeaderCellRenderer(index, fontMetrics) : new TranslationHeaderCellRenderer(fontMetrics, locale);
            column.setHeaderRenderer(renderer);
            int width = ConstantColumn.KEY.ordinal() == index || ConstantColumn.DEFAULT_VALUE.ordinal() == index ? renderer.getFullExpandedWidth() : renderer.getCollapsedWidth();
            ColumnUtil.setPreferredWidth(column, width);
        }
        ColumnUtil.expandToViewportWidthIfNecessary(table, -1);
    }

    static int getAdditionalWidthToFillViewport(@NotNull JTable table) {
        return table.getParent().getWidth() - table.getPreferredSize().width;
    }

    static void expandToViewportWidthIfNecessary(@NotNull JTable table, int ignoreIndex) {
        TableColumn column;
        if (table.getColumnModel().getColumnCount() < ConstantColumn.COUNT) {
            return;
        }
        int widthToFillViewport = ColumnUtil.getAdditionalWidthToFillViewport(table);
        if (widthToFillViewport <= 0) {
            return;
        }
        int totalNumColumns = table.getColumnModel().getColumnCount();
        int numColumnsForDistribution = totalNumColumns - ConstantColumn.COUNT;
        if (ConstantColumn.COUNT <= ignoreIndex && ignoreIndex < totalNumColumns) {
            --numColumnsForDistribution;
        }
        if (numColumnsForDistribution == 0) {
            TableColumn column2 = table.getColumn(ConstantColumn.DEFAULT_VALUE.name);
            ColumnUtil.setPreferredWidth(column2, column2.getPreferredWidth() + widthToFillViewport);
            return;
        }
        int extraWidth = widthToFillViewport / numColumnsForDistribution;
        for (int i = ConstantColumn.COUNT; i < totalNumColumns; ++i) {
            if (i == ignoreIndex) continue;
            column = table.getColumnModel().getColumn(i);
            ColumnUtil.setPreferredWidth(column, column.getPreferredWidth() + extraWidth);
            widthToFillViewport -= extraWidth;
        }
        int resizeIndex = totalNumColumns - 1;
        if (resizeIndex == ignoreIndex) {
            --resizeIndex;
        }
        column = table.getColumnModel().getColumn(resizeIndex);
        ColumnUtil.setPreferredWidth(column, column.getPreferredWidth() + widthToFillViewport);
    }

    static void setPreferredWidth(@NotNull TableColumn column, int width) {
        column.setPreferredWidth(width);
        ColumnUtil.toggleColumnNameIfApplicable(column);
    }

    private static void toggleColumnNameIfApplicable(@NotNull TableColumn column) {
        if (column.getHeaderRenderer() instanceof TranslationHeaderCellRenderer) {
            TranslationHeaderCellRenderer renderer = (TranslationHeaderCellRenderer)column.getHeaderRenderer();
            renderer.setUseBriefName(column.getPreferredWidth() < renderer.getMinimumExpandedWidth());
        }
    }
}

