/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.manifest;

import com.android.tools.idea.editors.manifest.ManifestEditor;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class ManifestEditorProvider
implements FileEditorProvider {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        boolean isManifest;
        AndroidFacet facet;
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        return module != null && (facet = AndroidFacet.getInstance(module)) != null && (isManifest = "AndroidManifest.xml".equals(file.getName())) && Projects.isBuildWithGradle(module);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        assert (module != null);
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        return new ManifestEditor(facet, file);
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        return FileEditorState.INSTANCE;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
    }

    @NotNull
    public String getEditorTypeId() {
        return "android-manifest";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
    }
}

