/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layeredimage;

import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.PixelProbe;
import com.android.tools.pixelprobe.decoder.Decoder;
import com.android.tools.pixelprobe.util.Images;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

class Utilities {
    private Utilities() {
    }

    @NotNull
    static Image loadImage(@NotNull VirtualFile file) throws IOException {
        try (InputStream in = file.getInputStream();){
            Image image = PixelProbe.probe((InputStream)in, (Decoder.Options)Decoder.Options.LAYER_METADATA_ONLY);
            return image;
        }
    }

    @NotNull
    static BufferedImage getDisplayableImage(@NotNull Image image) throws IOException {
        BufferedImage bufferedImage = image.getMergedImage();
        if (bufferedImage == null) {
            throw new IOException("Unable to extract flattened bitmap");
        }
        if (!Images.isColorSpace_sRGB((BufferedImage)bufferedImage)) {
            return Images.copyTo_sRGB((BufferedImage)bufferedImage);
        }
        return bufferedImage;
    }
}

