/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hierarchyview.model;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.HandleViewDebug;
import com.android.tools.idea.editors.hierarchyview.model.ViewNode;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientWindow {
    public final String title;
    public final Client client;

    public ClientWindow(@NotNull String title, @NotNull Client client) {
        this.title = title;
        this.client = client;
    }

    @NotNull
    public String getDisplayName() {
        String appName = this.client.getClientData().getClientDescription();
        ArrayList parts = Lists.newArrayList((Object[])this.title.split("/"));
        parts.remove("");
        parts.remove(appName);
        if (parts.isEmpty()) {
            return appName;
        }
        return (String)parts.get(parts.size() > 2 ? 1 : 0);
    }

    @Nullable
    public byte[] loadWindowData(long timeout, TimeUnit unit) {
        CaptureByteArrayHandler handler = new CaptureByteArrayHandler(HandleViewDebug.CHUNK_VURT);
        try {
            HandleViewDebug.dumpViewHierarchy((Client)this.client, (String)this.title, (boolean)false, (boolean)true, (HandleViewDebug.ViewDumpHandler)handler);
        }
        catch (IOException e) {
            return null;
        }
        return handler.getData(timeout, unit);
    }

    @Nullable
    public byte[] loadViewImage(@NotNull ViewNode node, long timeout, TimeUnit unit) {
        CaptureByteArrayHandler handler = new CaptureByteArrayHandler(HandleViewDebug.CHUNK_VUOP);
        try {
            HandleViewDebug.captureView((Client)this.client, (String)this.title, (String)node.toString(), (HandleViewDebug.ViewDumpHandler)handler);
        }
        catch (IOException e) {
            return null;
        }
        return handler.getData(timeout, unit);
    }

    @Nullable
    public static List<ClientWindow> getAll(@NotNull Client client, long timeout, @NotNull TimeUnit unit) {
        ClientData cd = client.getClientData();
        if (cd.hasFeature("view-hierarchy")) {
            try {
                return new ListViewRootsHandler().getWindows(client, timeout, unit);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static class CaptureByteArrayHandler
    extends HandleViewDebug.ViewDumpHandler {
        private AtomicReference<byte[]> mData = new AtomicReference();

        public CaptureByteArrayHandler(int type) {
            super(type);
        }

        protected void handleViewDebugResult(ByteBuffer data) {
            byte[] b = new byte[data.remaining()];
            data.get(b);
            this.mData.set(b);
        }

        public byte[] getData(long timeout, TimeUnit unit) {
            this.waitForResult(timeout, unit);
            return this.mData.get();
        }
    }

    private static class ListViewRootsHandler
    extends HandleViewDebug.ViewDumpHandler {
        private final List<String> myViewRoots = Lists.newCopyOnWriteArrayList();

        public ListViewRootsHandler() {
            super(HandleViewDebug.CHUNK_VULW);
        }

        protected void handleViewDebugResult(ByteBuffer data) {
            int nWindows = data.getInt();
            for (int i = 0; i < nWindows; ++i) {
                int len = data.getInt();
                this.myViewRoots.add(ListViewRootsHandler.getString((ByteBuffer)data, (int)len));
            }
        }

        @NotNull
        public List<ClientWindow> getWindows(@NotNull Client c, long timeout, TimeUnit unit) throws IOException {
            HandleViewDebug.listViewRoots((Client)c, (HandleViewDebug.ViewDumpHandler)this);
            this.waitForResult(timeout, unit);
            ArrayList windows = Lists.newArrayList();
            for (String root : this.myViewRoots) {
                windows.add(new ClientWindow(root, c));
            }
            return windows;
        }
    }
}

