/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hierarchyview;

import com.android.tools.idea.editors.hierarchyview.model.ViewNode;
import com.android.tools.idea.editors.hierarchyview.ui.RollOverTree;
import com.android.tools.idea.editors.hierarchyview.ui.ViewNodeActiveDisplay;
import com.android.tools.idea.editors.hierarchyview.ui.ViewNodeTableModel;
import com.android.tools.idea.editors.hierarchyview.ui.ViewNodeTreeRenderer;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.JBCheckboxMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HierarchyViewer
implements TreeSelectionListener,
RollOverTree.TreeHoverListener,
ViewNodeActiveDisplay.ViewNodeActiveDisplayListener {
    private static final String FIRST_COMPONENT_WIDTH = "com.android.hv.first.comp.width";
    private static final String LAST_COMPONENT_WIDTH = "com.android.hv.last.comp.width";
    private static final int DEFAULT_WIDTH = 200;
    private static final Key<ViewNode> KEY_VIEWNODE = Key.create((String)ViewNode.class.getName());
    private final ViewNode myRoot;
    private final ThreeComponentsSplitter myContentSplitter;
    private final ViewNodeActiveDisplay myPreview;
    private final RollOverTree myNodeTree;
    private final ViewNodeTableModel myTableModel;
    private final JBTable myPropertiesPanel;
    private final JBPopupMenu myNodePopup;
    private final JBCheckboxMenuItem myNodeVisibleMenuItem;

    public HierarchyViewer(@NotNull ViewNode node, @NotNull BufferedImage preview, final @NotNull PropertiesComponent propertiesComponent, @NotNull Disposable parent) {
        this.myRoot = node;
        this.myPreview = new ViewNodeActiveDisplay(node, preview);
        this.myNodeTree = new RollOverTree(node);
        this.myNodeTree.setCellRenderer((TreeCellRenderer)((Object)new ViewNodeTreeRenderer()));
        this.myTableModel = new ViewNodeTableModel();
        this.myPropertiesPanel = new JBTable((TableModel)this.myTableModel);
        this.myPropertiesPanel.setFillsViewportHeight(true);
        this.myPropertiesPanel.getTableHeader().setReorderingAllowed(false);
        this.myContentSplitter = new ThreeComponentsSplitter(false, true);
        Disposer.register((Disposable)parent, (Disposable)this.myContentSplitter);
        final JScrollPane firstComponent = ScrollPaneFactory.createScrollPane((Component)((Object)this.myNodeTree));
        final JScrollPane lastComponent = ScrollPaneFactory.createScrollPane((Component)this.myPropertiesPanel);
        this.myContentSplitter.setFirstComponent((JComponent)firstComponent);
        this.myContentSplitter.setInnerComponent((JComponent)this.myPreview);
        this.myContentSplitter.setLastComponent((JComponent)lastComponent);
        int minWidth = 20;
        HierarchyViewer.setMinimumWidth(firstComponent, minWidth);
        HierarchyViewer.setMinimumWidth(lastComponent, minWidth);
        this.myContentSplitter.setHonorComponentsMinimumSize(true);
        int width = Math.max(propertiesComponent.getInt(FIRST_COMPONENT_WIDTH, 200), minWidth);
        this.myContentSplitter.setFirstSize(width);
        width = Math.max(propertiesComponent.getInt(LAST_COMPONENT_WIDTH, 200), minWidth);
        this.myContentSplitter.setLastSize(width);
        ComponentAdapter resizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                propertiesComponent.setValue(HierarchyViewer.FIRST_COMPONENT_WIDTH, firstComponent.getSize().width, 200);
                propertiesComponent.setValue(HierarchyViewer.LAST_COMPONENT_WIDTH, lastComponent.getSize().width, 200);
            }
        };
        firstComponent.addComponentListener(resizeListener);
        lastComponent.addComponentListener(resizeListener);
        this.myPreview.addViewNodeActiveDisplayListener(this);
        this.myNodeTree.addTreeSelectionListener(this);
        this.myNodeTree.addTreeHoverListener(this);
        for (int i = 0; i < this.myNodeTree.getRowCount(); ++i) {
            TreePath path = this.myNodeTree.getPathForRow(i);
            ViewNode n = (ViewNode)path.getLastPathComponent();
            if (!n.isDrawn()) continue;
            this.myNodeTree.expandPath(path);
        }
        this.myNodeTree.setSelectionRow(0);
        this.myNodePopup = new JBPopupMenu();
        this.myNodeVisibleMenuItem = new JBCheckboxMenuItem("Show in preview");
        this.myNodeVisibleMenuItem.addActionListener((ActionListener)new ShowHidePreviewActionListener());
        this.myNodePopup.add((JMenuItem)this.myNodeVisibleMenuItem);
        this.myNodeTree.addMouseListener(new NodeRightClickAdapter());
    }

    private static void setMinimumWidth(@NotNull JComponent component, int minWidth) {
        Dimension minimumSize = component.getMinimumSize();
        minimumSize.width = Math.max(minimumSize.width, minWidth);
        component.setMinimumSize(minimumSize);
    }

    public JComponent getRootComponent() {
        return this.myContentSplitter;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        ViewNode selection = (ViewNode)this.myNodeTree.getLastSelectedPathComponent();
        if (selection != null) {
            this.myTableModel.setNode(selection);
            this.myPreview.setSelectedNode(selection);
        }
    }

    @Override
    public void onTreeCellHover(@Nullable TreePath path) {
        this.myPreview.setHoverNode(path == null ? null : (ViewNode)path.getLastPathComponent());
    }

    @Override
    public void onViewNodeOver(ViewNode node) {
        if (node == null) {
            this.myNodeTree.updateHoverPath(null);
        } else {
            TreePath path = HierarchyViewer.getPath(node);
            this.myNodeTree.scrollPathToVisible(path);
            this.myNodeTree.updateHoverPath(path);
        }
    }

    @Override
    public void onNodeSelected(@NotNull ViewNode node) {
        TreePath path = HierarchyViewer.getPath(node);
        this.myNodeTree.scrollPathToVisible(path);
        this.myNodeTree.setSelectionPath(path);
    }

    private static TreePath getPath(@NotNull ViewNode node) {
        ArrayList nodes = Lists.newArrayList();
        do {
            nodes.add(0, node);
        } while ((node = node.parent) != null);
        return new TreePath(nodes.toArray());
    }

    private class ShowHidePreviewActionListener
    implements ActionListener {
        private ShowHidePreviewActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewNode node = (ViewNode)HierarchyViewer.this.myNodePopup.getClientProperty((Object)KEY_VIEWNODE);
            if (node == null) {
                return;
            }
            node.setForcedState(HierarchyViewer.this.myNodeVisibleMenuItem.getState() ? ViewNode.ForcedState.VISIBLE : ViewNode.ForcedState.INVISIBLE);
            HierarchyViewer.this.myRoot.updateNodeDrawn();
            HierarchyViewer.this.myPreview.repaint();
            HierarchyViewer.this.myNodeTree.repaint();
        }
    }

    private class NodeRightClickAdapter
    extends MouseAdapter {
        private NodeRightClickAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                TreePath path = HierarchyViewer.this.myNodeTree.getPathForEvent(e);
                if (path == null) {
                    return;
                }
                ViewNode node = (ViewNode)path.getLastPathComponent();
                if (node.isParentVisible()) {
                    HierarchyViewer.this.myNodeVisibleMenuItem.setEnabled(true);
                    if (node.getForcedState() == ViewNode.ForcedState.NONE) {
                        HierarchyViewer.this.myNodeVisibleMenuItem.setState(node.isDrawn());
                    } else {
                        HierarchyViewer.this.myNodeVisibleMenuItem.setState(node.getForcedState() == ViewNode.ForcedState.VISIBLE);
                    }
                } else {
                    HierarchyViewer.this.myNodeVisibleMenuItem.setEnabled(false);
                    HierarchyViewer.this.myNodeVisibleMenuItem.setState(false);
                }
                HierarchyViewer.this.myNodePopup.putClientProperty((Object)KEY_VIEWNODE, (Object)node);
                HierarchyViewer.this.myNodePopup.show((Component)((Object)HierarchyViewer.this.myNodeTree), e.getX(), e.getY());
            }
        }
    }
}

