/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.widgets;

import com.android.tools.rpclib.futures.SingleInFlight;
import com.intellij.icons.AllIcons;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.Alarm;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadablePanel
extends JBLayeredPane
implements SingleInFlight.Listener {
    private static final long DELAY_MS = 50L;
    @NotNull
    private final JPanel myContents;
    @NotNull
    private final LoadingLayer myLoadingLayer;
    @NotNull
    private final AtomicBoolean myShouldShow = new AtomicBoolean();
    @NotNull
    private final Alarm myAlarm = new Alarm();

    public LoadablePanel(@NotNull LayoutManager layout) {
        this(new JPanel(layout), Style.TRANSPARENT);
    }

    public LoadablePanel(@NotNull JPanel contents) {
        this(contents, Style.TRANSPARENT);
    }

    public LoadablePanel(@NotNull JPanel contents, @NotNull Style style) {
        this.myContents = contents;
        this.myLoadingLayer = new LoadingLayer(style);
        this.add(this.myContents, JLayeredPane.DEFAULT_LAYER);
        this.add(this.myLoadingLayer, JLayeredPane.POPUP_LAYER);
    }

    @NotNull
    public JPanel getContentLayer() {
        return this.myContents;
    }

    public void setLoadingText(@NotNull String loadingText) {
        this.myLoadingLayer.setLoadingText(loadingText);
    }

    public void startLoading() {
        this.myShouldShow.set(true);
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (LoadablePanel.this.myShouldShow.get()) {
                    LoadablePanel.this.myLoadingLayer.startLoading();
                }
            }
        }, 50L);
    }

    public void stopLoading() {
        this.stopLoading(null, null);
    }

    public void showLoadingError(@NotNull String message) {
        this.stopLoading(message, null);
    }

    public void showLoadingError(@NotNull String message, @Nullable Component errorComponent) {
        this.stopLoading(message, errorComponent);
    }

    private void stopLoading(final String message, final Component errorComponent) {
        this.myShouldShow.set(false);
        this.myAlarm.cancelAllRequests();
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!LoadablePanel.this.myShouldShow.get()) {
                    LoadablePanel.this.myLoadingLayer.stopLoading(message, errorComponent);
                }
            }
        });
    }

    public void onIdleToWorking() {
        this.startLoading();
    }

    public void onWorkingToIdle() {
        this.stopLoading();
    }

    public Dimension getMinimumSize() {
        return this.myContents.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        return this.myContents.getPreferredSize();
    }

    public void doLayout() {
        this.myContents.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.myLoadingLayer.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    private static class LoadingLayer
    extends JPanel {
        @NotNull
        private final JPanel myCenteredChildPanel = new JPanel(new FlowLayout(1, 12, 0));
        @NotNull
        private final AsyncProcessIcon mySpinner = new AsyncProcessIcon.Big("Loading");
        @NotNull
        private final JBLabel myLabel = new JBLabel();
        private boolean myShowingError = false;
        @NotNull
        private String myLoadingText = "Loading...";

        public LoadingLayer(Style style) {
            super(new GridBagLayout());
            style.styleLabel(this.myLabel);
            this.setOpaque(false);
            this.add(style.stylePanel(this.myCenteredChildPanel));
            this.setVisible(false);
        }

        public void setLoadingText(@NotNull String loadingText) {
            this.myLoadingText = loadingText;
        }

        public void startLoading() {
            this.reset(true, this.myLoadingText, null);
            this.myShowingError = false;
            this.setVisible(true);
        }

        public void stopLoading(@Nullable String error, @Nullable Component errorComponent) {
            if (error == null) {
                if (!this.myShowingError) {
                    this.setVisible(false);
                }
            } else {
                this.reset(false, error, AllIcons.General.ErrorDialog);
                if (errorComponent != null) {
                    this.myCenteredChildPanel.add(errorComponent);
                }
                this.myShowingError = true;
                this.setVisible(true);
            }
        }

        private void reset(boolean spinner, String text, Icon icon) {
            this.myCenteredChildPanel.removeAll();
            if (spinner) {
                this.myCenteredChildPanel.add((Component)this.mySpinner);
            }
            this.myCenteredChildPanel.add((Component)this.myLabel);
            this.myLabel.setText(text);
            this.myLabel.setIcon(icon);
        }
    }

    public static enum Style {
        TRANSPARENT{

            @Override
            public JPanel stylePanel(JPanel panel) {
                panel.setOpaque(false);
                return panel;
            }
        }
        ,
        OPAQUE{

            @Override
            public JPanel stylePanel(JPanel panel) {
                panel.setOpaque(true);
                panel.setBackground(UIUtil.getPanelBackground());
                panel.setBorder(JBUI.Borders.merge((Border)JBUI.Borders.customLine((Color)new JBColor(0, 0xFFFFFF), (int)1), (Border)JBUI.Borders.empty((int)5), (boolean)false));
                return panel;
            }
        };


        public void styleLabel(JBLabel label) {
            Font font = label.getFont();
            label.setFont(font.deriveFont((float)font.getSize() * 1.5f));
        }

        public abstract JPanel stylePanel(JPanel var1);
    }
}

